/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.sequence.common.util;

import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.sequence.common.exception.SequenceConfigException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SequenceConfigUtil {
    private static final SimpleDateFormat SEQUENCE_DAY_FORMAT = new SimpleDateFormat("yyyyMMdd");
    private static final SimpleDateFormat SEQUENCE_MONTH_FORMAT = new SimpleDateFormat("yyyyMM");
    private static final SimpleDateFormat SEQUENCE_YEAR_FORMAT = new SimpleDateFormat("yyyy");
    private static Pattern pt;
    private static Map<String, String> resetSeqIdMap;
    private static ConcurrentHashMap<String, Object> lockMap;
    private static final Object lock;

    public static String getMsgContent(String templet, Map<String, String> paramsMap) {
        String newTemplet = templet;
        if (newTemplet == null || newTemplet == "") {
            return "";
        }
        for (Map.Entry<String, String> entry : paramsMap.entrySet()) {
            String key = entry.getKey();
            if (!newTemplet.contains("{" + key + "}")) continue;
            newTemplet = newTemplet.replaceAll("\\{" + key + "\\}", entry.getValue());
        }
        return newTemplet;
    }

    public static String numFormatToSeq(long len, String value) {
        if (len <= 0L) {
            return "";
        }
        StringBuilder seq = new StringBuilder();
        int i = 0;
        while ((long)i < len - (long)value.length()) {
            seq.append('0');
            ++i;
        }
        seq.append(value);
        return seq.toString();
    }

    public static boolean reg(String str) {
        pt = Pattern.compile("[A-Z]{1}[A-Z0-9_]+");
        Matcher mt = pt.matcher(str);
        return mt.matches();
    }

    public static String dealWithSeq2Templet(String sequenceStr, String zeroFill, String seqTemplet, Long seqPlace, Map<String, String> paramsMap) throws SequenceConfigException {
        try {
            if ("Y".equals(zeroFill)) {
                sequenceStr = SequenceConfigUtil.numFormatToSeq(seqPlace, sequenceStr);
            }
            if (paramsMap == null) {
                paramsMap = new HashMap<String, String>();
            }
            paramsMap.put("SEQUENCE", sequenceStr);
            String openday = DateUtils.formatDateTimeByDef();
            String year = openday.substring(0, 4);
            String month = openday.substring(5, 7);
            String day = openday.substring(8, 10);
            String hour = openday.substring(11, 13);
            String minute = openday.substring(14, 16);
            String second = openday.substring(17, 19);
            paramsMap.put("yyyy", year);
            paramsMap.put("MM", month);
            paramsMap.put("dd", day);
            paramsMap.put("HH", hour);
            paramsMap.put("mm", minute);
            paramsMap.put("ss", second);
            sequenceStr = SequenceConfigUtil.getMsgContent(seqTemplet, paramsMap);
        }
        catch (Exception e) {
            throw new SequenceConfigException(e.getMessage());
        }
        return sequenceStr;
    }

    public static Map<String, String> getResetSeqIdMap() {
        return resetSeqIdMap;
    }

    public static void removeSeqIdMap(String key) {
        resetSeqIdMap.remove(key);
    }

    public static String resetSeqId(String seqId, String resetType) throws SequenceConfigException {
        if (StringUtils.isEmpty((CharSequence)seqId)) {
            throw new SequenceConfigException("SeqId Can Not Empty\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)resetType)) {
            return seqId;
        }
        String sequenceName = "";
        sequenceName = "DAY".equals(resetType) ? "s" + SequenceConfigUtil.getCurrentDay() + "#" + seqId : ("MONTH".equals(resetType) ? "s" + SequenceConfigUtil.getCurrentMonth() + "#" + seqId : ("YEAR".equals(resetType) ? "s" + SequenceConfigUtil.getCurrentYear() + "#" + seqId : seqId));
        String newSeqId = sequenceName.toUpperCase();
        resetSeqIdMap.put(newSeqId, seqId);
        return newSeqId;
    }

    public static String builder0(Object ... args) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            stringBuilder.append(args[i]);
        }
        return stringBuilder.toString();
    }

    public static int getDayDiffer(String day, String type) throws ParseException {
        Date endDate = new Date();
        SimpleDateFormat dateFormat = null;
        if ("DAY".equals(type)) {
            dateFormat = SEQUENCE_DAY_FORMAT;
        } else if ("MONTH".equals(type)) {
            dateFormat = SEQUENCE_MONTH_FORMAT;
        } else if ("YEAR".equals(type)) {
            dateFormat = SEQUENCE_YEAR_FORMAT;
        }
        long startDateTime = dateFormat.parse(day).getTime();
        long endDateTime = dateFormat.parse(dateFormat.format(endDate)).getTime();
        return (int)((endDateTime - startDateTime) / 86400000L);
    }

    public static String getCurrentDay() {
        SimpleDateFormat df = SEQUENCE_DAY_FORMAT;
        return df.format(new Date());
    }

    public static String getCurrentMonth() {
        SimpleDateFormat df = SEQUENCE_MONTH_FORMAT;
        return df.format(new Date());
    }

    public static String getCurrentYear() {
        SimpleDateFormat df = SEQUENCE_YEAR_FORMAT;
        return df.format(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkAndAddLock(String seqId) {
        if (!lockMap.containsKey(seqId)) {
            Object object = lock;
            synchronized (object) {
                if (!lockMap.containsKey(seqId)) {
                    lockMap.put(seqId, new Object());
                }
            }
        }
    }

    public static Object getLock(String seqId) {
        SequenceConfigUtil.checkAndAddLock(seqId);
        return lockMap.get(seqId);
    }

    static {
        resetSeqIdMap = new ConcurrentHashMap<String, String>();
        lockMap = new ConcurrentHashMap();
        lock = new Object();
    }
}

