/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.service;

import cn.com.yusys.yusp.commons.module.adapter.web.rest.ResultDto;
import cn.com.yusys.yusp.service.FileOperateServiceHystrix;
import cn.com.yusys.yusp.web.rest.dto.FileQueryRetDTO;
import cn.com.yusys.yusp.web.rest.dto.FileUploadRetDTO;
import feign.Contract;
import feign.Response;
import feign.codec.Encoder;
import feign.form.spring.SpringFormEncoder;
import java.util.List;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.context.annotation.Bean;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

@FeignClient(fallbackFactory=FileOperateServiceHystrix.class, name="yusp-file", path="/api/file", configuration={MultipartSupportConfig.class})
public interface FileFeignClient {
    @PostMapping(value={"/upload"}, consumes={"multipart/form-data"})
    public ResultDto<FileUploadRetDTO> upload(@RequestPart(value="file") MultipartFile var1, @RequestParam(value="busNo") String var2, @RequestParam(value="fileSource") String var3, @RequestParam(value="storageType") String var4, @RequestParam(value="expireDays") String var5, @RequestParam(value="fileRemark") String var6, @RequestParam(value="showName") String var7);

    @GetMapping(value={"/query"})
    public ResultDto<List<FileQueryRetDTO>> query(@RequestParam(value="busNo") String var1, @RequestParam(value="fileId") String var2, @RequestParam(value="fileSource") String var3, @RequestParam(value="storageType") String var4);

    @GetMapping(value={"/download"}, consumes={"application/problem+json"})
    public Response download(@RequestParam(value="fileId") String var1, @RequestParam(value="storageType") String var2);

    @GetMapping(value={"/downloadLarge"})
    public Response downloadLarge(@RequestParam(value="fileId") String var1, @RequestParam(value="storageType") String var2);

    @GetMapping(value={"/delete"})
    public ResultDto<String> delete(@RequestParam(value="busNo") String var1, @RequestParam(value="fileId") String var2, @RequestParam(value="storageType") String var3);

    public static class MultipartSupportConfig {
        @Autowired
        private ObjectFactory<HttpMessageConverters> messageConverters;

        public Contract feignContract() {
            return new Contract.Default();
        }

        @Bean
        public Encoder feignEncoder() {
            return new SpringFormEncoder((Encoder)new SpringEncoder(this.messageConverters));
        }
    }
}

