/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.common.exception;

import cn.com.yusys.yusp.commons.util.date.DateUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.helpers.MessageFormatter;

public class IcspException
extends RuntimeException {
    private static final long serialVersionUID = 1088570243487187197L;
    private Map<String, Object> head = new LinkedHashMap<String, Object>();
    private Map<String, Object> body;

    public IcspException(String globalSeq, String code, String message, Throwable cause, Object ... args) {
        super(MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage(), cause);
        this.head.put("globalSeq", globalSeq);
        this.head.put("responseDate", DateUtils.formatDateTimeByDef());
        this.head.put("responseCode", code);
        this.head.put("responseMes", MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage());
        this.head.put("totalSize", -1);
    }

    public IcspException(String globalSeq, String code, String message, Throwable e) {
        this(globalSeq, code, message, e, null);
    }

    public IcspException(String code, String message) {
        this(null, code, message, null, null);
    }

    public IcspException(String globalSeq, String code, String message) {
        this(globalSeq, code, message, null, null);
    }

    public IcspException(String code, Throwable e) {
        this(null, code, Objects.nonNull(e) ? e.getMessage() : null, e, null);
    }

    public IcspException(String globalSeq, String code, Throwable e) {
        this(globalSeq, code, Objects.nonNull(e) ? e.getMessage() : null, e, null);
    }

    public IcspException(String code, String message, Object ... args) {
        this(null, code, message, null, args);
    }

    public IcspException(String globalSeq, String code, String message, Object ... args) {
        this(globalSeq, code, message, null, args);
    }

    public String getResponseCode() {
        Object code = this.head.get("responseCode");
        if (code instanceof String) {
            return (String)code;
        }
        if (code instanceof Integer) {
            return String.valueOf(code);
        }
        return null;
    }

    public Map<String, Object> getBody() {
        return this.body;
    }

    public String getGlobalSeq() {
        return (String)this.head.get("globalSeq");
    }

    public String getResponseMes() {
        return (String)this.head.get("responseMes");
    }
}

