/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.common.bsp;

import cn.com.yusys.yusp.common.bsp.BspReq;
import cn.com.yusys.yusp.common.bsp.BspResp;
import cn.com.yusys.yusp.common.bsp.IBspFeignClient;
import cn.com.yusys.yusp.common.bsp.head.ReqLocalHead;
import cn.com.yusys.yusp.common.bsp.sec.EsbSeqNo;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import com.qzbank.util.CommonUtils;
import com.qzbank.util.SM2Utils;
import java.lang.reflect.Field;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class BspFeignServer {
    @Value(value="${esb.nmgs_public_key}")
    private String nmgs_public_key;
    @Value(value="${esb.nccs_public_key}")
    private String nccs_public_key;
    @Value(value="${esb.tranDate}")
    private String tran_date;
    private static final Logger logger = LoggerFactory.getLogger(BspFeignServer.class);
    @Autowired
    private IBspFeignClient iBspFeignClient;

    public BspResp call(String serviceCode, String serviceScene, IcspRequest request) {
        BspReq bspReq = new BspReq();
        bspReq.setBODY(request.getBody());
        bspReq.getSYS_HEAD().setBRANCH_ID(request.getTradeHead().getOrgId());
        bspReq.getSYS_HEAD().setUSER_ID(request.getTradeHead().getUserId());
        bspReq.getSYS_HEAD().setCONSUMER_SEQ_NO(request.getTradeHead().getTradeSerialNo());
        bspReq.getSYS_HEAD().setTRAN_DATE(request.getTradeHead().getWorkDate());
        bspReq.getSYS_HEAD().setSERVICE_CODE(serviceCode);
        bspReq.getSYS_HEAD().setSERVICE_SCENE(serviceScene);
        return this.call(bspReq);
    }

    public BspResp call(BspReq bspReq) {
        this.copyHead(bspReq);
        this.packSysHead(bspReq);
        this.packAppHead(bspReq);
        this.packLocalHead(bspReq);
        BspResp call = null;
        try {
            call = this.iBspFeignClient.call(bspReq);
        }
        finally {
            if (call == null) {
                call = new BspResp();
            }
            call.setBspReq(bspReq);
        }
        logger.info("BSP callback message : " + call.toString());
        return call;
    }

    public <T> T call(BspReq bspReq, Class<T> tClass) {
        this.copyHead(bspReq);
        this.packSysHead(bspReq);
        this.packAppHead(bspReq);
        this.packLocalHead(bspReq);
        T call = this.iBspFeignClient.call(bspReq, tClass);
        return call;
    }

    private void copyHead(BspReq req) {
        if (req.getBODY() instanceof Map && ((Map)req.getBODY()).get("head") instanceof Map) {
            Map head = (Map)((Map)req.getBODY()).get("head");
            this.setHeadValue(req.getSYS_HEAD(), head);
            this.setHeadValue(req.getAPP_HEAD(), head);
            if (req.getLOCAL_HEAD() != null) {
                this.setHeadValue(req.getLOCAL_HEAD(), head);
            } else {
                req.setLOCAL_HEAD(head);
            }
        }
    }

    private void setHeadValue(Object head, Map<String, Object> body) {
        if (head == null || body == null || body.isEmpty()) {
            return;
        }
        Field[] fields = head.getClass().getDeclaredFields();
        try {
            for (String columnName : body.keySet()) {
                Object value = body.get(columnName);
                if (value == null || !(value instanceof String)) continue;
                for (Field field : fields) {
                    String annColName = field.getName();
                    if (annColName == null || !columnName.equalsIgnoreCase(annColName)) continue;
                    field.setAccessible(true);
                    field.set(head, body.get(columnName));
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void packSysHead(BspReq req) {
        String HHmmssSSS = DateUtils.formatDate((String)"HHmmssSSS");
        String sendDate = req.getSYS_HEAD().getTRAN_DATE();
        if (StringUtils.isEmpty((CharSequence)sendDate)) {
            sendDate = this.tran_date;
        }
        String fullTime = sendDate + HHmmssSSS;
        req.getSYS_HEAD().setTRAN_DATE(sendDate);
        req.getSYS_HEAD().setTRAN_TIMESTAMP(HHmmssSSS);
        String consumer_seq_no = req.getSYS_HEAD().getCONSUMER_SEQ_NO();
        req.getSYS_HEAD().setCONSUMER_SEQ_NO(StringUtils.isEmpty((CharSequence)consumer_seq_no) ? EsbSeqNo.createComsumerSeqNo() : consumer_seq_no);
        String global_seq_no = req.getSYS_HEAD().getGLOBAL_SEQ_NO();
        req.getSYS_HEAD().setGLOBAL_SEQ_NO(StringUtils.isEmpty((CharSequence)global_seq_no) ? EsbSeqNo.createGlobaSeqNo() : global_seq_no);
        String buss_seq_no = req.getSYS_HEAD().getBUSS_SEQ_NO();
        req.getSYS_HEAD().setBUSS_SEQ_NO(StringUtils.isEmpty((CharSequence)buss_seq_no) ? EsbSeqNo.createComsumerSeqNo() : buss_seq_no);
        String org_sys_id = req.getSYS_HEAD().getORG_SYS_ID();
        req.getSYS_HEAD().setORG_SYS_ID(StringUtils.isEmpty((CharSequence)org_sys_id) ? "100017" : org_sys_id);
        String tran_mode = req.getSYS_HEAD().getTRAN_MODE();
        req.getSYS_HEAD().setTRAN_MODE(StringUtils.isEmpty((CharSequence)tran_mode) ? "ONLINE" : tran_mode);
        String source_type = req.getSYS_HEAD().getSOURCE_TYPE();
        req.getSYS_HEAD().setSOURCE_TYPE(StringUtils.isEmpty((CharSequence)source_type) ? "CH0901011" : source_type);
        String user_lang = req.getSYS_HEAD().getUSER_LANG();
        req.getSYS_HEAD().setUSER_LANG(StringUtils.isEmpty((CharSequence)user_lang) ? "CHINESE" : user_lang);
        String sysEngName = req.getSYS_HEAD().getSYS_ENG_NAME();
        req.getSYS_HEAD().setSYS_ENG_NAME(StringUtils.isEmpty((CharSequence)sysEngName) ? "NMGS" : sysEngName);
        String consumerId = req.getSYS_HEAD().getCONSUMER_ID();
        req.getSYS_HEAD().setCONSUMER_ID(StringUtils.isEmpty((CharSequence)consumerId) ? "100017" : consumerId);
        String encrypt = SM2Utils.encrypt((byte[])CommonUtils.hexToByte((String)this.nmgs_public_key), (byte[])fullTime.getBytes());
        if (StringUtils.nonEmpty((CharSequence)sysEngName) && "NCCS".equals(sysEngName)) {
            encrypt = SM2Utils.encrypt((byte[])CommonUtils.hexToByte((String)this.nccs_public_key), (byte[])fullTime.getBytes());
        }
        req.getSYS_HEAD().setMAC_CHECK_VAL(encrypt);
        String seq_no = req.getSYS_HEAD().getSEQ_NO();
        req.getSYS_HEAD().setSEQ_NO(StringUtils.isEmpty((CharSequence)seq_no) ? EsbSeqNo.createSeqNo() : seq_no);
    }

    private void packAppHead(BspReq req) {
        String company = req.getAPP_HEAD().getCOMPANY();
        req.getAPP_HEAD().setCOMPANY(StringUtils.isEmpty((CharSequence)company) ? "QZBANK" : company);
    }

    private void packLocalHead(BspReq req) {
        if (req.getLOCAL_HEAD() == null) {
            ReqLocalHead localHead = new ReqLocalHead();
            req.setLOCAL_HEAD(localHead);
        }
    }
}

