/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.common.interceptor;

import cn.com.yusys.yusp.common.dataauth.DataAuthHandler;
import cn.com.yusys.yusp.common.mapper.provider.OGNLUtil;
import java.util.HashMap;
import java.util.Properties;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;

public class CommonInterceptor
implements Interceptor {
    protected boolean basic2Map = false;
    protected DataAuthHandler dataAuthHandler;

    public CommonInterceptor() {
    }

    public CommonInterceptor(boolean basic2Map, DataAuthHandler dataAuthHandler) {
        this.basic2Map = basic2Map;
        this.dataAuthHandler = dataAuthHandler;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object parameter;
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        SqlCommandType commandType = ms.getSqlCommandType();
        this.handBasic2Map(args);
        if (commandType.equals((Object)SqlCommandType.SELECT)) {
            this.handDataAuth(args);
        } else if (commandType.equals((Object)SqlCommandType.INSERT)) {
            parameter = invocation.getArgs()[1];
            this.handDataAuth(args);
        } else if (commandType.equals((Object)SqlCommandType.UPDATE)) {
            parameter = invocation.getArgs()[1];
            this.handDataAuth(args);
        } else if (commandType.equals((Object)SqlCommandType.DELETE)) {
            this.handDataAuth(args);
        }
        parameter = invocation.proceed();
        return parameter;
    }

    protected boolean handBasic2Map(Object[] args) {
        if (this.basic2Map) {
            MappedStatement ms = (MappedStatement)args[0];
            Object parameter = args[1];
            if (parameter != null && !OGNLUtil.isBasic(parameter)) {
                return false;
            }
            HashMap newParameter = new HashMap();
            BoundSql boundSql = ms.getBoundSql(parameter);
            Object parameterObject = boundSql.getParameterObject();
            System.out.println(parameterObject);
            args[1] = newParameter;
            return true;
        }
        return false;
    }

    protected boolean handDataAuth(Object[] args) {
        if (this.dataAuthHandler != null) {
            MappedStatement ms = (MappedStatement)args[0];
            Object parameter = args[1];
            String sqlId = ms.getId();
            return this.dataAuthHandler.handDataAuth(sqlId, parameter);
        }
        return false;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

