/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.common.config;

import cn.com.yusys.yusp.common.dataauth.DataAuthHandler;
import cn.com.yusys.yusp.common.dataauth.DefaultDataAuthHandler;
import cn.com.yusys.yusp.common.dataauth.handler.DataAuthParamHander;
import cn.com.yusys.yusp.common.dataauth.handler.DefaultDataAuthParamHander;
import cn.com.yusys.yusp.common.filter.DataAuthFilter;
import cn.com.yusys.yusp.common.session.IcspCacheSessionServiceImpl;
import cn.com.yusys.yusp.common.session.IcspSessionService;
import javax.servlet.Filter;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class IcspCommonConfig {
    private static final Logger logger = LoggerFactory.getLogger(IcspCommonConfig.class);
    public static final Integer FILTER_ORDER_XSS = 100;
    public static final Integer FILTER_ORDER_UPLOAD = 99;
    public static final Integer FILTER_ORDER_ACCESS = 98;
    public static final Integer FILTER_ORDER_DATAAUTH = 97;
    public static final Integer FILTER_ORDER_SERVICEAUTH = 96;

    @Bean
    public IcspSessionService icspCacheSessionService() {
        logger.info("init icspCacheSessionService");
        return new IcspCacheSessionServiceImpl();
    }

    @Configuration
    @ConditionalOnProperty(name={"application.filter.dataauth.enabled"}, matchIfMissing=false)
    @ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class})
    public class DataAuthAutoConfiguration {
        private final Logger logger = LoggerFactory.getLogger(DataAuthAutoConfiguration.class);

        @Bean
        public DataAuthFilter dataAuthFilter() {
            this.logger.info("\u81ea\u52a8\u914d\u7f6e>> \u8bb0\u5f55\u96c6\u6743\u9650\u8fc7\u6ee4\u5668\u914d\u7f6e\u5b8c\u6210");
            return new DataAuthFilter();
        }

        @Bean
        public FilterRegistrationBean dataAuthFilterBean() {
            FilterRegistrationBean bean = new FilterRegistrationBean((Filter)this.dataAuthFilter(), new ServletRegistrationBean[0]);
            bean.setOrder(FILTER_ORDER_DATAAUTH.intValue());
            return bean;
        }

        @Bean
        @ConditionalOnMissingBean
        public DataAuthParamHander dataAuthParamHander() {
            System.out.println("DataAuthParamHander========>>>>>>>>>>>>");
            return new DefaultDataAuthParamHander();
        }

        @Bean
        @ConditionalOnMissingBean
        public DataAuthHandler dataAuthHandler() {
            System.out.println("dataAuthHandler========>>>>>>>>>>>>");
            return new DefaultDataAuthHandler();
        }
    }
}

