/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.common.config;

import cn.com.yusys.yusp.common.dataauth.DataAuthHandler;
import cn.com.yusys.yusp.common.dataauth.DefaultDataAuthHandler;
import cn.com.yusys.yusp.common.interceptor.SelectInterceptor;
import com.github.pagehelper.autoconfigure.PageHelperAutoConfiguration;
import java.util.List;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class})
@ConditionalOnBean(value={DataSource.class})
@AutoConfigureAfter(value={MybatisAutoConfiguration.class, PageHelperAutoConfiguration.class})
public class MyBatisExtendAutoConfiguration {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Configuration
    public class MyBatisExtendHandlerConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public DataAuthHandler dataAuthHandler() {
            return new DefaultDataAuthHandler();
        }
    }

    @Configuration
    public class MyBatisExtendInterceptorConfiguration {
        @Autowired
        public void addPageInterceptor(@Autowired(required=true) List<SqlSessionFactory> sqlSessionFactoryList, @Autowired(required=false) DataAuthHandler dataAuthHandler) {
            SelectInterceptor selectInterceptor = new SelectInterceptor(false, dataAuthHandler);
            for (SqlSessionFactory sqlSessionFactory : sqlSessionFactoryList) {
                sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)selectInterceptor);
            }
        }
    }
}

