/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.common.sftp;

import com.dcfs.fts.client.FtpClientConfig;
import com.dcfs.fts.client.FtpGet;
import com.dcfs.fts.client.FtpGetStream;
import com.dcfs.fts.client.FtpPut;
import com.dcfs.fts.client.FtpPutStream;
import com.dcfs.fts.common.FtpException;
import com.dcfs.fts.constant.FTPConfig;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import jdk.nashorn.internal.runtime.logging.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Logger
@Component
public class FileTransPlat {
    @Value(value="${esb.file.serverConnect}")
    String serverConnect;
    @Value(value="${esb.file.uid}")
    String uid;
    @Value(value="${esb.file.passwd}")
    String passwd;
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(FileTransPlat.class);

    private void initConfig() {
        FTPConfig.config = false;
        FTPConfig.serverConnect = this.serverConnect;
        FTPConfig.uid = this.uid;
        FTPConfig.passwd = this.passwd;
    }

    public String uploadFile(String localFileName, String remoteFileName, String tranCode, int mode) throws FtpException, IOException {
        this.initConfig();
        logger.info(String.format("localFileName=%s,remoteFileName=%s,tranCode=%s,mode=%s", localFileName, remoteFileName, tranCode, mode));
        FtpPut ftpPut = new FtpPut(localFileName, remoteFileName, tranCode, mode, FtpClientConfig.getInstance());
        String path = ftpPut.doPutFile();
        logger.info("uploadFile:" + path);
        return path;
    }

    public boolean downloadFile(String remoteFileName, String localFileName, String tranCode, int mode) throws IOException, FtpException {
        this.initConfig();
        logger.info(String.format("localFileName=%s,remoteFileName=%s,tranCode=%s,mode=%s", localFileName, remoteFileName, tranCode, mode));
        FtpGet ftpGet = new FtpGet(remoteFileName, localFileName, tranCode, mode, FtpClientConfig.getInstance());
        boolean res = ftpGet.doGetFile();
        logger.info("doGetFile:" + res);
        return res;
    }

    public String uploadStream(byte[] localFileStream, String realName, String tranCode, int mode) throws IOException, FtpException {
        this.initConfig();
        logger.info(String.format("localFileName=%s,remoteFileName=%s,tranCode=%s,mode=%s", localFileStream, realName, tranCode, mode));
        FtpPutStream ftpPutStream = new FtpPutStream(localFileStream, realName, tranCode, mode, FtpClientConfig.getInstance());
        String path = ftpPutStream.doPutFile();
        logger.info("uploadFile:" + path);
        return path;
    }

    public void downloadStream(String remoteFileName, String localFileName, String tranCode, int mode) throws FtpException, IOException {
        this.initConfig();
        FtpGetStream ftpGetStream = new FtpGetStream(remoteFileName, tranCode, mode, FtpClientConfig.getInstance());
        if (ftpGetStream.doGetFile()) {
            logger.info("localFileName:" + localFileName);
            this.writeFile(ftpGetStream.getFileBytes(), new File(localFileName));
        } else {
            logger.error("\u83b7\u53d6\u6587\u4ef6\u5f02\u5e38");
        }
    }

    public boolean writeFile(byte[] bytes, File localFileName) throws IOException {
        try (FilterOutputStream out = null;){
            localFileName.getParentFile().mkdirs();
            out = new BufferedOutputStream(new FileOutputStream(localFileName));
            out.write(bytes);
            ((BufferedOutputStream)out).flush();
            boolean bl = true;
            return bl;
        }
    }
}

