/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.common.qzyh.file;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.dcfs.fts.client.FtpClientConfig;
import com.dcfs.fts.client.FtpGet;
import com.dcfs.fts.client.FtpPut;
import com.dcfs.fts.common.FtpException;
import com.dcfs.fts.constant.FTPConfig;
import java.io.IOException;
import jdk.nashorn.internal.runtime.logging.Logger;
import org.slf4j.LoggerFactory;

@Logger
public class SftpUtil {
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(SftpUtil.class);

    private static void initConfig() {
        Config publicConfig = ConfigService.getConfig((String)"qzyh-esb");
        FTPConfig.config = false;
        FTPConfig.serverConnect = publicConfig.getProperty("esb.file.serverConnect", null);
        FTPConfig.uid = publicConfig.getProperty("esb.file.uid", null);
        FTPConfig.passwd = publicConfig.getProperty("esb.file.passwd", null);
    }

    public static String uploadFile(String localFileName, String remoteFileName, String tranCode, int mode) throws FtpException, IOException {
        SftpUtil.initConfig();
        logger.info(String.format("localFileName=%s,remoteFileName=%s,tranCode=%s,mode=%s", localFileName, remoteFileName, tranCode, mode));
        FtpPut ftpPut = new FtpPut(localFileName, remoteFileName, tranCode, mode, FtpClientConfig.getInstance());
        String path = ftpPut.doPutFile();
        logger.info("uploadFile:" + path);
        return path;
    }

    public static boolean downloadFile(String remoteFileName, String localFileName, String tranCode, int mode) throws IOException, FtpException {
        SftpUtil.initConfig();
        logger.info(String.format("localFileName=%s,remoteFileName=%s,tranCode=%s,mode=%s", localFileName, remoteFileName, tranCode, mode));
        FtpGet ftpGet = new FtpGet(remoteFileName, localFileName, tranCode, mode, FtpClientConfig.getInstance());
        boolean res = ftpGet.doGetFile();
        logger.info("doGetFile:" + res);
        return res;
    }
}

