/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.common.annotation;

import cn.com.yusys.yusp.common.bsp.BspReq;
import cn.com.yusys.yusp.common.bsp.BspResp;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class BspLoggerAspect {
    private static final Logger logger = LoggerFactory.getLogger(BspLoggerAspect.class);

    @Pointcut(value="execution(* cn.com.yusys.yusp.common.bsp.IBspFeignClient.call(..))")
    public void log() {
    }

    @Before(value="log()")
    public void doBefore(JoinPoint joinPoint) {
        Object[] obj = joinPoint.getArgs();
        if (obj != null && obj.length > 0 && obj[0] instanceof BspReq) {
            BspReq req = (BspReq)obj[0];
            logger.info(String.format("BSP\u8bf7\u6c42\u62a5\u6587\uff1acode[%s]scene[%s]", req.getSYS_HEAD().getSERVICE_CODE(), req.getSYS_HEAD().getSERVICE_SCENE()));
            if (logger.isInfoEnabled()) {
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    String reqStr = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)req);
                    logger.info("\u8bf7\u6c42\u62a5\u6587\n" + reqStr);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @AfterReturning(pointcut="log()", returning="resp")
    public void doAfterReturning(BspResp resp) {
        if (resp != null) {
            try {
                if (logger.isInfoEnabled()) {
                    logger.info(String.format("BSP\u8fd4\u56de\u62a5\u6587\uff1acode[%s]scene[%s] code[%s] msg[%s] ", resp.getSYS_HEAD().getSERVICE_CODE(), resp.getSYS_HEAD().getSERVICE_SCENE(), resp.getSYS_HEAD().getRET().get(0).getRET_CODE(), resp.getSYS_HEAD().getRET().get(0).getRET_CODE()));
                    ObjectMapper mapper = new ObjectMapper();
                    String reqStr = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)resp);
                    logger.info("\u8fd4\u56de\u62a5\u6587\n" + reqStr);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

