/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.common.bsp;

import cn.com.yusys.yusp.common.bsp.BspReq;
import cn.com.yusys.yusp.common.bsp.BspResp;
import cn.com.yusys.yusp.common.bsp.IBspFeignClient;
import cn.com.yusys.yusp.common.bsp.head.ReqLocalHead;
import cn.com.yusys.yusp.common.bsp.sec.EsbSeqNo;
import cn.com.yusys.yusp.common.log.LogTradeCommFeign;
import cn.com.yusys.yusp.common.log.domain.LogTradeCommBo;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import com.qzbank.util.CommonUtils;
import com.qzbank.util.SM2Utils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class BspFeignServer {
    @Value(value="${esb.publicKey}")
    private String public_key;
    private static final Logger logger = LoggerFactory.getLogger(BspFeignServer.class);
    @Autowired
    private IBspFeignClient iBspFeignClient;
    @Autowired
    private LogTradeCommFeign logTradeCommFeign;

    public BspResp call(String serviceCode, String serviceScene, IcspRequest request) {
        BspReq bspReq = new BspReq();
        bspReq.setBODY(request.getBody());
        bspReq.getSYS_HEAD().setBRANCH_ID(request.getTradeHead().getOrgId());
        bspReq.getSYS_HEAD().setUSER_ID(request.getTradeHead().getUserId());
        bspReq.getSYS_HEAD().setCONSUMER_SEQ_NO(request.getTradeHead().getTradeSerialNo());
        bspReq.getSYS_HEAD().setTRAN_DATE(request.getTradeHead().getWorkDate());
        bspReq.getSYS_HEAD().setSERVICE_CODE(serviceCode);
        bspReq.getSYS_HEAD().setSERVICE_SCENE(serviceScene);
        return this.call(bspReq);
    }

    public BspResp call(BspReq bspReq) {
        this.copyHead(bspReq);
        this.packSysHead(bspReq);
        this.packAppHead(bspReq);
        this.packLocalHead(bspReq);
        BspResp call = this.iBspFeignClient.call(bspReq);
        logger.info("BSP callback message : " + call.toString());
        return call;
    }

    public <T> T call(BspReq bspReq, Class<T> tClass) {
        this.copyHead(bspReq);
        this.packSysHead(bspReq);
        this.packAppHead(bspReq);
        this.packLocalHead(bspReq);
        T call = this.iBspFeignClient.call(bspReq, tClass);
        logger.info("BSP callback message : " + call.toString());
        return call;
    }

    private void copyHead(BspReq req) {
        if (req.getBODY() instanceof Map) {
            Map body = (Map)req.getBODY();
            this.setHeadValue(req.getSYS_HEAD(), body);
            this.setHeadValue(req.getAPP_HEAD(), body);
            this.setHeadValue(req.getLOCAL_HEAD(), body);
        }
    }

    private void setHeadValue(Object head, Map<String, Object> body) {
        if (head == null || body == null || body.isEmpty()) {
            return;
        }
        Field[] fields = head.getClass().getDeclaredFields();
        try {
            for (String columnName : body.keySet()) {
                Object value = body.get(columnName);
                if (value == null || !(value instanceof String)) continue;
                for (Field field : fields) {
                    String annColName = field.getName();
                    if (annColName == null || !columnName.equalsIgnoreCase(annColName)) continue;
                    field.setAccessible(true);
                    field.set(head, body.get(columnName));
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String[] args) {
        BspFeignServer bspFeignServer = new BspFeignServer();
        BspReq req = new BspReq();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("TRAN_DATE", "123");
        map.put("FILE_PATH", "abc");
        req.setBODY(map);
        bspFeignServer.copyHead(req);
        System.out.println(req.toString());
    }

    private void packSysHead(BspReq req) {
        String fullTime = DateUtils.formatDate((String)"yyyyMMddHHmmssSSS");
        String yyyyMMdd = fullTime.substring(0, 8);
        String HHmmssSSS = fullTime.substring(8, 17);
        String encrypt = SM2Utils.encrypt((byte[])CommonUtils.hexToByte((String)this.public_key), (byte[])fullTime.getBytes());
        req.getSYS_HEAD().setTRAN_DATE(yyyyMMdd);
        req.getSYS_HEAD().setTRAN_TIMESTAMP(HHmmssSSS);
        req.getSYS_HEAD().setMAC_CHECK_VAL(encrypt);
        String consumer_seq_no = req.getSYS_HEAD().getCONSUMER_SEQ_NO();
        req.getSYS_HEAD().setCONSUMER_SEQ_NO(StringUtils.isEmpty((CharSequence)consumer_seq_no) ? EsbSeqNo.createComsumerSeqNo() : consumer_seq_no);
        String global_seq_no = req.getSYS_HEAD().getGLOBAL_SEQ_NO();
        req.getSYS_HEAD().setGLOBAL_SEQ_NO(StringUtils.isEmpty((CharSequence)global_seq_no) ? EsbSeqNo.createGlobaSeqNo() : global_seq_no);
        String org_sys_id = req.getSYS_HEAD().getORG_SYS_ID();
        req.getSYS_HEAD().setORG_SYS_ID(StringUtils.isEmpty((CharSequence)org_sys_id) ? "100017" : org_sys_id);
        String tran_mode = req.getSYS_HEAD().getTRAN_MODE();
        req.getSYS_HEAD().setTRAN_MODE(StringUtils.isEmpty((CharSequence)tran_mode) ? "ONLINE" : tran_mode);
        String source_type = req.getSYS_HEAD().getSOURCE_TYPE();
        req.getSYS_HEAD().setSOURCE_TYPE(StringUtils.isEmpty((CharSequence)source_type) ? "0101" : source_type);
        String user_lang = req.getSYS_HEAD().getUSER_LANG();
        req.getSYS_HEAD().setUSER_LANG(StringUtils.isEmpty((CharSequence)user_lang) ? "CHINESE" : user_lang);
    }

    private void packAppHead(BspReq req) {
        String buss_seq_no = req.getAPP_HEAD().getBUSS_SEQ_NO();
        req.getAPP_HEAD().setBUSS_SEQ_NO(StringUtils.isEmpty((CharSequence)buss_seq_no) ? EsbSeqNo.createComsumerSeqNo() : buss_seq_no);
        String company = req.getAPP_HEAD().getCOMPANY();
        req.getAPP_HEAD().setCOMPANY(StringUtils.isEmpty((CharSequence)company) ? "QZBANK" : company);
    }

    private void packLocalHead(BspReq req) {
        if (req.getLOCAL_HEAD() == null) {
            ReqLocalHead localHead = new ReqLocalHead();
            req.setLOCAL_HEAD(localHead);
        }
    }

    public void recordCommLog(long startTime, Map<String, Object> header, BspResp bspResp) {
        String serviceCode = (String)header.get("SERVICE_CODE");
        String serviceScene = (String)header.get("SERVICE_SCENE");
        LogTradeCommBo logTradeCommBo = new LogTradeCommBo();
        logTradeCommBo.setLogId(StringUtils.getUUID());
        logTradeCommBo.setCustSeq((String)header.get("CUST_SEQ"));
        logTradeCommBo.setTradeSeq((String)header.get("TRADE_SEQ"));
        logTradeCommBo.setWorkDate((String)header.get("WORK_DATE"));
        logTradeCommBo.setChannel((String)header.get("CHANNEL"));
        logTradeCommBo.setChannelSeq((String)header.get("CHANNEL_SEQ"));
        logTradeCommBo.setOrgId((String)header.get("ORG_ID"));
        logTradeCommBo.setTradeCode((String)header.get("TRADE_CODE"));
        logTradeCommBo.setTradeName((String)header.get("TRADE_NAME"));
        logTradeCommBo.setServerNode((String)header.get("SERVER_NODE"));
        logTradeCommBo.setServerDate((String)header.get("SERVER_DATE"));
        logTradeCommBo.setServerTime((String)header.get("SERVER_TIME"));
        logTradeCommBo.setTrnsmtSts((String)header.get("TRNSMT_STS"));
        logTradeCommBo.setTrnsmtType((String)header.get("TRNSMT_TYPE"));
        logTradeCommBo.setTrnsmtTeller((String)header.get("TRNSMT_TELLER"));
        logTradeCommBo.setTrnsmtOrgId((String)header.get("TRNSMT_ORG_ID"));
        logTradeCommBo.setTerminId((String)header.get("TERMIN_ID"));
        logTradeCommBo.setTerminType((String)header.get("TERMIN_TYPE"));
        logTradeCommBo.setServiceCode(serviceCode);
        logTradeCommBo.setServiceScene(serviceScene);
        long endTime = System.currentTimeMillis();
        long retTime = endTime - startTime;
        logTradeCommBo.setRetTime(String.valueOf(retTime));
        if (bspResp != null) {
            logTradeCommBo.setRetCode(bspResp.getCode());
            logTradeCommBo.setRetMessage(bspResp.getMsg());
        } else {
            logTradeCommBo.setRetCode("500");
            logTradeCommBo.setRetMessage("BSP\u8bf7\u6c42\u5931\u8d25");
        }
        try {
            IcspRequest<LogTradeCommBo> icspRequest = new IcspRequest<LogTradeCommBo>();
            icspRequest.setBody(logTradeCommBo);
            this.logTradeCommFeign.create(icspRequest);
        }
        catch (Exception e) {
            logger.error("BSP\u901a\u8baf\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25,SERVICE_CODE:" + serviceCode + ",SERVICE_SCENE:" + serviceScene);
            logger.error("BSP\u901a\u8baf\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25:" + e.getMessage());
        }
    }
}

