/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.common.bsp;

import cn.com.yusys.yusp.common.bsp.BspReq;
import cn.com.yusys.yusp.common.bsp.BspResp;
import cn.com.yusys.yusp.common.bsp.IBspFeignClient;
import cn.com.yusys.yusp.common.bsp.sec.EsbSeqNo;
import cn.com.yusys.yusp.common.log.LogTradeCommFeign;
import cn.com.yusys.yusp.common.log.domain.LogTradeCommBo;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.qzbank.util.CommonUtils;
import com.qzbank.util.SM2Utils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class BspFeginServer {
    @Value(value="${esb.publicKey}")
    private String public_key;
    private static final Logger logger = LoggerFactory.getLogger(BspFeginServer.class);
    @Autowired
    private IBspFeignClient iBspFeignClient;
    @Autowired
    private LogTradeCommFeign logTradeCommFeign;

    public BspResp call(String serviceCode, String serviceScene, IcspRequest request) {
        Object body = request.getBody();
        String jsonStr = JSON.toJSONString(body);
        JSONObject bodyMap = JSON.parseObject((String)jsonStr);
        Map sysHead = BeanUtils.beanToMap((Object)request.getSysHead());
        Map tradeHead = BeanUtils.beanToMap((Object)request.getTradeHead());
        HashMap<String, Object> head = new HashMap<String, Object>();
        head.putAll(sysHead);
        head.putAll(tradeHead);
        Object bodyHead = bodyMap.remove("head");
        head.putAll(null == bodyHead ? new HashMap() : (Map)bodyHead);
        return this.call(serviceCode, serviceScene, head, (Map<String, Object>)bodyMap);
    }

    public BspResp call(String serviceCode, String serviceScene, Map<String, Object> head, Map<String, Object> body) {
        if (StringUtils.isEmpty((CharSequence)serviceCode) || StringUtils.isEmpty((CharSequence)serviceScene)) {
            BspResp resp = new BspResp();
            resp.setMsg("\u670d\u52a1\u7f16\u53f7\uff0c\u573a\u666f\u7f16\u53f7\u4e3a\u5fc5\u4f20\u5b57\u6bb5");
            resp.setCode("999999");
            return resp;
        }
        String tranMode = (String)head.get("TRAN_MODE");
        String sourceType = (String)head.get("SOURCE_TYPE");
        String userLang = (String)head.get("USER_LANG");
        String orgSysId = (String)head.get("ORG_SYS_ID");
        BspReq req = new BspReq(serviceCode, serviceScene);
        Map<String, Object> header = req.getHeader();
        header.put("CONSUMER_ID", "NMGS");
        header.put("BRANCH_ID", "9350501013");
        header.put("USER_ID", "903583");
        header.put("ORG_SYS_ID", StringUtils.isEmpty((CharSequence)orgSysId) ? "NMGS" : orgSysId);
        header.put("TRAN_MODE", StringUtils.isEmpty((CharSequence)tranMode) ? "ONLINE" : tranMode);
        header.put("SOURCE_TYPE", StringUtils.isEmpty((CharSequence)sourceType) ? "0101" : sourceType);
        header.put("USER_LANG", StringUtils.isEmpty((CharSequence)userLang) ? "CHINESE" : userLang);
        if (head != null) {
            header.putAll(head);
        }
        req.setHeader(header);
        if (body == null) {
            body = new HashMap<String, Object>();
        }
        req.setBody(body);
        BspResp resp = this.call(req);
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BspResp call(BspReq req) {
        long startTime = System.currentTimeMillis();
        String yyyyMMddSSmmssSSS = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()).toString();
        String yyyyMMdd = yyyyMMddSSmmssSSS.substring(0, 8);
        String HHmmssSSS = yyyyMMddSSmmssSSS.substring(8, 17);
        String encrypt = SM2Utils.encrypt((byte[])CommonUtils.hexToByte((String)this.public_key), (byte[])yyyyMMddSSmmssSSS.getBytes());
        Map<String, Object> request = req.getHeader();
        HashMap<String, Object> recv = new HashMap<String, Object>();
        HashMap<String, Object> SYS_HEAD = new HashMap<String, Object>();
        SYS_HEAD.put("SYS_NAME", request.get("SYS_NAME"));
        SYS_HEAD.put("SERVICE_CODE", request.get("SERVICE_CODE"));
        SYS_HEAD.put("SERVICE_SCENE", request.get("SERVICE_SCENE"));
        SYS_HEAD.put("CONSUMER_ID", request.get("CONSUMER_ID"));
        SYS_HEAD.put("TRAN_DATE", yyyyMMdd);
        SYS_HEAD.put("TRAN_TIMESTAMP", HHmmssSSS);
        SYS_HEAD.put("BRANCH_ID", request.get("BRANCH_ID"));
        SYS_HEAD.put("USER_ID", request.get("USER_ID"));
        SYS_HEAD.put("AUTH_FLAG", request.get("AUTH_FLAG"));
        String consumer_seq_no = (String)request.get("CONSUMER_SEQ_NO");
        SYS_HEAD.put("CONSUMER_SEQ_NO", consumer_seq_no == null || "".equals(consumer_seq_no) ? EsbSeqNo.createComsumerSeqNo() : consumer_seq_no);
        Object global_seq_no = request.get("GLOBAL_SEQ_NO");
        SYS_HEAD.put("GLOBAL_SEQ_NO", global_seq_no == null || "".equals(global_seq_no) ? EsbSeqNo.createGlobaSeqNo() : global_seq_no);
        SYS_HEAD.put("MAC_CHECK_VAL", encrypt);
        String org_sys_id = (String)request.get("ORG_SYS_ID");
        SYS_HEAD.put("ORG_SYS_ID", StringUtils.isEmpty((CharSequence)org_sys_id) ? "100017" : org_sys_id);
        String tran_mode = (String)request.get("TRAN_MODE");
        SYS_HEAD.put("TRAN_MODE", StringUtils.isEmpty((CharSequence)tran_mode) ? "ONLINE" : tran_mode);
        String source_type = (String)request.get("SOURCE_TYPE");
        SYS_HEAD.put("SOURCE_TYPE", StringUtils.isEmpty((CharSequence)source_type) ? "0101" : source_type);
        SYS_HEAD.put("SERVER_ID", request.get("SERVER_ID"));
        SYS_HEAD.put("WS_ID", request.get("WS_ID"));
        String user_lang = (String)request.get("USER_LANG");
        SYS_HEAD.put("USER_LANG", StringUtils.isEmpty((CharSequence)user_lang) ? "CHINESE" : user_lang);
        SYS_HEAD.put("SOURCE_BRANCH_NO", request.get("SOURCE_BRANCH_NO"));
        SYS_HEAD.put("DEST_BRANCH_NO", request.get("DEST_BRANCH_NO"));
        SYS_HEAD.put("MESSAGE_TYPE", request.get("MESSAGE_TYPE"));
        SYS_HEAD.put("MESSAGE_CODE", request.get("MESSAGE_CODE"));
        SYS_HEAD.put("USER_PASSWORD", request.get("USER_PASSWORD"));
        SYS_HEAD.put("USER_LEVEL", request.get("USER_LEVEL"));
        SYS_HEAD.put("USER_TYPE", request.get("USER_TYPE"));
        SYS_HEAD.put("PROGRAM_ID", request.get("PROGRAM_ID"));
        SYS_HEAD.put("APPR_FLAG", request.get("APPR_FLAG"));
        SYS_HEAD.put("MODULE_ID", request.get("MODULE_ID"));
        SYS_HEAD.put("CONSUMER_SVR_ID", request.get("CONSUMER_SVR_ID"));
        ArrayList auth = new ArrayList();
        SYS_HEAD.put("AUTH_USER_ID_ARRAY", request.get("AUTH_USER_ID_ARRAY"));
        SYS_HEAD.put("APPR_USER_ID_ARRAY", request.get("APPR_USER_ID_ARRAY"));
        HashMap<String, Object> APP_HEAD = new HashMap<String, Object>();
        Object buss_seq_no = request.get("BUSS_SEQ_NO");
        APP_HEAD.put("BUSS_SEQ_NO", buss_seq_no == null || "".equals(buss_seq_no) ? EsbSeqNo.createComsumerSeqNo() : buss_seq_no);
        APP_HEAD.put("REVERSAL_TRAN_TYPE", request.get("REVERSAL_TRAN_TYPE"));
        APP_HEAD.put("REVERSAL_SEQ_NO", request.get("REVERSAL_SEQ_NO"));
        APP_HEAD.put("REVERSAL_BUSS_SEQ_NO", request.get("REVERSAL_BUSS_SEQ_NO"));
        APP_HEAD.put("REVERSAL_DATE", request.get("REVERSAL_DATE"));
        APP_HEAD.put("QUERY_KEY", request.get("QUERY_KEY"));
        APP_HEAD.put("PAGE_START", request.get("PAGE_START"));
        APP_HEAD.put("PAGE_END", request.get("PAGE_END"));
        APP_HEAD.put("TOTAL_ROWS", request.get("TOTAL_ROWS"));
        APP_HEAD.put("TOTAL_PAGES", request.get("TOTAL_PAGES"));
        APP_HEAD.put("FILE_NAME", request.get("FILE_NAME"));
        APP_HEAD.put("FILE_SVR_IP", request.get("FILE_SVR_IP"));
        APP_HEAD.put("FILE_SVR_PORT", request.get("FILE_SVR_PORT"));
        APP_HEAD.put("FILE_SVR_PATH", request.get("FILE_SVR_PATH"));
        APP_HEAD.put("PGUP_OR_PGDN", request.get("PGUP_OR_PGDN"));
        APP_HEAD.put("TOTAL_NUM", request.get("TOTAL_NUM"));
        APP_HEAD.put("CURRENT_NUM", request.get("CURRENT_NUM"));
        APP_HEAD.put("TOTAL_FLAG", request.get("TOTAL_FLAG"));
        APP_HEAD.put("FILE_PATH", request.get("FILE_PATH"));
        APP_HEAD.put("COMPANY", request.get("COMPANY"));
        APP_HEAD.put("CLIENT_VER_RESULT", request.get("CLIENT_VER_RESULT"));
        APP_HEAD.put("TRUSTEE_INFO", request.get("TRUSTEE_INFO"));
        HashMap<String, Object> LOCAL_HEAD = new HashMap<String, Object>();
        LOCAL_HEAD.put("AUTH_RET", request.get("AUTH_RET"));
        LOCAL_HEAD.put("TRAN_CODE", request.get("TRAN_CODE"));
        LOCAL_HEAD.put("VERSION_NO", request.get("VERSION_NO"));
        LOCAL_HEAD.put("TRAN_TIME", request.get("TRAN_TIME"));
        LOCAL_HEAD.put("FILE_FLAG", request.get("FILE_FLAG"));
        LOCAL_HEAD.put("TELLER_SEQ_NO", request.get("TELLER_SEQ_NO"));
        LOCAL_HEAD.put("AUTH_TELLER_NO", request.get("AUTH_TELLER_NO"));
        LOCAL_HEAD.put("CLIENT_TYPE", request.get("CLIENT_TYPE"));
        LOCAL_HEAD.put("PWD_CHECK_FLAG", request.get("PWD_CHECK_FLAG"));
        LOCAL_HEAD.put("COMMU_SEQU_NO", request.get("COMMU_SEQU_NO"));
        LOCAL_HEAD.put("USERID", request.get("USERID"));
        LOCAL_HEAD.put("NODE_NAME", request.get("NODE_NAME"));
        LOCAL_HEAD.put("TRANSID", request.get("TRANSID"));
        LOCAL_HEAD.put("CIS_CODE", request.get("CIS_CODE"));
        LOCAL_HEAD.put("TRADECODE", request.get("TRADECODE"));
        LOCAL_HEAD.put("RUN_SCRIPT", request.get("RUN_SCRIPT"));
        Map<String, Object> body1 = req.getBody();
        recv.put("SYS_HEAD", SYS_HEAD);
        recv.put("APP_HEAD", APP_HEAD);
        recv.put("LOCAL_HEAD", LOCAL_HEAD);
        recv.put("BODY", body1);
        BspResp bspResp = new BspResp();
        try {
            Map<String, Object> call = this.iBspFeignClient.call(recv);
            if (null == call) {
                bspResp.setMsg("ESB\u670d\u52a1\u8bf7\u6c42\u5f02\u5e38");
                bspResp.setCode("500");
                BspResp bspResp2 = bspResp;
                return bspResp2;
            }
            logger.info("bsp return message : " + JSON.toJSONString(call));
            bspResp.setCode((String)((Map)((ArrayList)((Map)call.get("SYS_HEAD")).get("RET")).get(0)).get("RET_CODE"));
            bspResp.setMsg((String)((Map)((ArrayList)((Map)call.get("SYS_HEAD")).get("RET")).get(0)).get("RET_MSG"));
            bspResp.setData(call);
        }
        finally {
            this.recordCommLog(startTime, request, bspResp);
        }
        return bspResp;
    }

    public void recordCommLog(long startTime, Map<String, Object> header, BspResp bspResp) {
        String serviceCode = (String)header.get("SERVICE_CODE");
        String serviceScene = (String)header.get("SERVICE_SCENE");
        LogTradeCommBo logTradeCommBo = new LogTradeCommBo();
        logTradeCommBo.setLogId(StringUtils.getUUID());
        logTradeCommBo.setCustSeq((String)header.get("CUST_SEQ"));
        logTradeCommBo.setTradeSeq((String)header.get("TRADE_SEQ"));
        logTradeCommBo.setWorkDate((String)header.get("WORK_DATE"));
        logTradeCommBo.setChannel((String)header.get("CHANNEL"));
        logTradeCommBo.setChannelSeq((String)header.get("CHANNEL_SEQ"));
        logTradeCommBo.setOrgId((String)header.get("ORG_ID"));
        logTradeCommBo.setTradeCode((String)header.get("TRADE_CODE"));
        logTradeCommBo.setTradeName((String)header.get("TRADE_NAME"));
        logTradeCommBo.setServerNode((String)header.get("SERVER_NODE"));
        logTradeCommBo.setServerDate((String)header.get("SERVER_DATE"));
        logTradeCommBo.setServerTime((String)header.get("SERVER_TIME"));
        logTradeCommBo.setTrnsmtSts((String)header.get("TRNSMT_STS"));
        logTradeCommBo.setTrnsmtType((String)header.get("TRNSMT_TYPE"));
        logTradeCommBo.setTrnsmtTeller((String)header.get("TRNSMT_TELLER"));
        logTradeCommBo.setTrnsmtOrgId((String)header.get("TRNSMT_ORG_ID"));
        logTradeCommBo.setTerminId((String)header.get("TERMIN_ID"));
        logTradeCommBo.setTerminType((String)header.get("TERMIN_TYPE"));
        logTradeCommBo.setServiceCode(serviceCode);
        logTradeCommBo.setServiceScene(serviceScene);
        long endTime = System.currentTimeMillis();
        long retTime = endTime - startTime;
        logTradeCommBo.setRetTime(String.valueOf(retTime));
        if (bspResp != null) {
            logTradeCommBo.setRetCode(bspResp.getCode());
            logTradeCommBo.setRetMessage(bspResp.getMsg());
        } else {
            logTradeCommBo.setRetCode("500");
            logTradeCommBo.setRetMessage("BSP\u8bf7\u6c42\u5931\u8d25");
        }
        try {
            IcspRequest<LogTradeCommBo> icspRequest = new IcspRequest<LogTradeCommBo>();
            icspRequest.setBody(logTradeCommBo);
            this.logTradeCommFeign.create(icspRequest);
        }
        catch (Exception e) {
            logger.error("BSP\u901a\u8baf\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25,SERVICE_CODE:" + serviceCode + ",SERVICE_SCENE:" + serviceScene);
            logger.error("BSP\u901a\u8baf\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25:" + e.getMessage());
        }
    }
}

