/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.common.annotation;

import cn.com.yusys.yusp.common.bsp.BspReq;
import cn.com.yusys.yusp.common.bsp.BspResp;
import cn.com.yusys.yusp.common.log.LogTradeCommFeign;
import cn.com.yusys.yusp.common.log.domain.LogTradeCommBo;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class TradeCommLogAspect {
    private static final Logger logger = LoggerFactory.getLogger(TradeCommLogAspect.class);
    @Autowired
    private LogTradeCommFeign logTradeCommFeign;

    @Pointcut(value="@annotation(TradeCommLog)")
    private void cutMethod() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="cutMethod()")
    public void aroundMethod(ProceedingJoinPoint point) throws Throwable {
        LogTradeCommBo logTradeCommBo = null;
        long startTime = 0L;
        Object result = null;
        try {
            startTime = System.currentTimeMillis();
            result = point.proceed();
        }
        finally {
            logTradeCommBo = new LogTradeCommBo();
            Object[] args = point.getArgs();
            Map<String, Object> header = ((BspReq)args[0]).getHeader();
            BeanUtils.mapToBean(header, (Object)logTradeCommBo);
            logTradeCommBo.setLogId(StringUtils.getUUID());
            long endTime = System.currentTimeMillis();
            long retTime = endTime - startTime;
            logTradeCommBo.setRetTime(String.valueOf(retTime));
            if (result != null && result instanceof BspResp) {
                BspResp bspResp = (BspResp)result;
                logTradeCommBo.setRetCode(bspResp.getCode());
                logTradeCommBo.setRetMessage(bspResp.getMsg());
            } else {
                logTradeCommBo.setRetCode("9999");
                logTradeCommBo.setRetMessage("BSP\u8bf7\u6c42\u5931\u8d25");
            }
            IcspRequest<LogTradeCommBo> icspRequest = new IcspRequest<LogTradeCommBo>();
            icspRequest.setBody(logTradeCommBo);
            this.logTradeCommFeign.create(icspRequest);
        }
    }
}

