/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.common.bsp;

import cn.com.yusys.yusp.common.annotation.TradeCommLog;
import cn.com.yusys.yusp.common.bsp.BspReq;
import cn.com.yusys.yusp.common.bsp.BspResp;
import cn.com.yusys.yusp.common.bsp.IBspFeignClient;
import cn.com.yusys.yusp.common.bsp.sec.EsbSeqNo;
import cn.com.yusys.yusp.common.bsp.sec.IdentifyUtil;
import cn.com.yusys.yusp.common.req.IcspRequest;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class BspFeginServer {
    @Value(value="${esb.publicKey}")
    private String public_key;
    @Autowired
    private IBspFeignClient iBspFeignClient;

    public BspResp call(String serviceCode, String serviceScene, IcspRequest request) {
        Map body = (Map)request.getBody();
        Map head = (Map)body.remove("head");
        return this.call(serviceCode, serviceScene, head, body);
    }

    public BspResp call(String serviceCode, String serviceScene, Map<String, Object> head, Map<String, Object> body) {
        if (StringUtils.isEmpty((CharSequence)serviceCode) || StringUtils.isEmpty((CharSequence)serviceScene)) {
            BspResp resp = new BspResp();
            resp.setMsg("\u670d\u52a1\u7f16\u53f7\uff0c\u573a\u666f\u7f16\u53f7\u4e3a\u5fc5\u4f20\u5b57\u6bb5");
            resp.setCode("999999");
            return resp;
        }
        String tranMode = (String)head.get("tranMode");
        String sourceType = (String)head.get("sourceType");
        String userLang = (String)head.get("userLang");
        String orgSysId = (String)head.get("orgSysId");
        BspReq req = new BspReq(serviceCode, serviceScene);
        Map<String, Object> header = req.getHeader();
        header.put("consumerId", "NMGS");
        header.put("branchId", "9350501013");
        header.put("userId", "903583");
        header.put("orgSysId", StringUtils.isEmpty((CharSequence)orgSysId) ? "NMGS" : orgSysId);
        header.put("tranMode", StringUtils.isEmpty((CharSequence)tranMode) ? "ONLINE" : tranMode);
        header.put("sourceType", StringUtils.isEmpty((CharSequence)sourceType) ? "0101" : sourceType);
        header.put("userLang", StringUtils.isEmpty((CharSequence)userLang) ? "CHINESE" : userLang);
        if (head != null) {
            header.putAll(head);
        }
        req.setHeader(header);
        if (body == null) {
            body = new HashMap<String, Object>();
        }
        req.setBody(body);
        BspResp resp = this.call(req);
        return resp;
    }

    @TradeCommLog
    public BspResp call(BspReq req) {
        String yyyyMMddSSmmssSSS = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()).toString();
        String yyyyMMdd = yyyyMMddSSmmssSSS.substring(0, 8);
        String HHmmssSSS = yyyyMMddSSmmssSSS.substring(8, 17);
        String encrypt = IdentifyUtil.encrypt(yyyyMMddSSmmssSSS, this.public_key);
        Map<String, Object> request = req.getHeader();
        HashMap<String, Object> recv = new HashMap<String, Object>();
        HashMap<String, Object> sysHead = new HashMap<String, Object>();
        sysHead.put("sysName", request.get("sysName"));
        sysHead.put("serviceCode", request.get("serviceCode"));
        sysHead.put("serviceScene", request.get("serviceScene"));
        sysHead.put("consumerId", request.get("consumerId"));
        sysHead.put("tranDate", yyyyMMdd);
        sysHead.put("tranTimestamp", HHmmssSSS);
        sysHead.put("branchId", request.get("branchId"));
        sysHead.put("userId", request.get("userId"));
        sysHead.put("authFlag", request.get("authFlag"));
        String consumerSeqNo = (String)request.get("consumerSeqNo");
        sysHead.put("consumerSeqNo", consumerSeqNo == null || "".equals(consumerSeqNo) ? EsbSeqNo.createComsumerSeqNo() : consumerSeqNo);
        Object globalSeqNo = request.get("globalSeqNo");
        sysHead.put("globalSeqNo", globalSeqNo == null || "".equals(globalSeqNo) ? EsbSeqNo.createGlobaSeqNo() : globalSeqNo);
        sysHead.put("macCheckVal", encrypt);
        String orgSysId = (String)request.get("orgSysId");
        sysHead.put("orgSysId", StringUtils.isEmpty((CharSequence)orgSysId) ? "100017" : orgSysId);
        String tranMode = (String)request.get("tranMode");
        sysHead.put("tranMode", StringUtils.isEmpty((CharSequence)tranMode) ? "ONLINE" : tranMode);
        String sourceType = (String)request.get("sourceType");
        sysHead.put("sourceType", StringUtils.isEmpty((CharSequence)sourceType) ? "0101" : sourceType);
        sysHead.put("serverId", request.get("serverId"));
        sysHead.put("wsId", request.get("wsId"));
        String userLang = (String)request.get("userLang");
        sysHead.put("userLang", StringUtils.isEmpty((CharSequence)userLang) ? "CHINESE" : userLang);
        sysHead.put("sourceBranchNo", request.get("sourceBranchNo"));
        sysHead.put("destBranchNo", request.get("destBranchNo"));
        sysHead.put("messageType", request.get("messageType"));
        sysHead.put("messageCode", request.get("messageCode"));
        sysHead.put("userPassword", request.get("userPassword"));
        sysHead.put("userLevel", request.get("userLevel"));
        sysHead.put("userType", request.get("userType"));
        sysHead.put("programId", request.get("programId"));
        sysHead.put("apprFlag", request.get("apprFlag"));
        sysHead.put("moduleId", request.get("moduleId"));
        sysHead.put("consumerSvrId", request.get("consumerSvrId"));
        sysHead.put("authUserIdArray", request.get("authUserIdArray"));
        sysHead.put("apprUserIdArray", request.get("apprUserIdArray"));
        HashMap<String, Object> appHead = new HashMap<String, Object>();
        Object bussSeqNo = request.get("bussSeqNo");
        appHead.put("bussSeqNo", bussSeqNo == null || "".equals(bussSeqNo) ? EsbSeqNo.createComsumerSeqNo() : bussSeqNo);
        appHead.put("reversalTranType", request.get("reversalTranType"));
        appHead.put("reversalSeqNo", request.get("reversalSeqNo"));
        appHead.put("reversalBussSeqNo", request.get("reversalBussSeqNo"));
        appHead.put("reversalDate", request.get("reversalDate"));
        appHead.put("queryKey", request.get("queryKey"));
        appHead.put("pageStart", request.get("pageStart"));
        appHead.put("pageEnd", request.get("pageEnd"));
        appHead.put("totalRows", request.get("totalRows"));
        appHead.put("totalPages", request.get("totalPages"));
        appHead.put("fileName", request.get("fileName"));
        appHead.put("fileSvrIp", request.get("fileSvrIp"));
        appHead.put("fileSvrPort", request.get("fileSvrPort"));
        appHead.put("fileSvrPath", request.get("fileSvrPath"));
        appHead.put("pgupOrPgdn", request.get("pgupOrPgdn"));
        appHead.put("totalNum", request.get("totalNum"));
        appHead.put("currentNum", request.get("currentNum"));
        appHead.put("totalFlag", request.get("totalFlag"));
        appHead.put("filePath", request.get("filePath"));
        appHead.put("company", request.get("company"));
        appHead.put("clientVerResult", request.get("clientVerResult"));
        appHead.put("trusteeInfo", request.get("trusteeInfo"));
        HashMap<String, Object> localHead = new HashMap<String, Object>();
        localHead.put("authRet", request.get("authRet"));
        localHead.put("tranCode", request.get("tranCode"));
        localHead.put("versionNo", request.get("versionNo"));
        localHead.put("tranTime", request.get("tranTime"));
        localHead.put("fileFlag", request.get("fileFlag"));
        localHead.put("tellerSeqNo", request.get("tellerSeqNo"));
        localHead.put("authTellerNo", request.get("authTellerNo"));
        localHead.put("clientType", request.get("clientType"));
        localHead.put("pwdCheckFlag", request.get("pwdCheckFlag"));
        localHead.put("commuSequNo", request.get("commuSequNo"));
        localHead.put("userid", request.get("userid"));
        localHead.put("nodeName", request.get("nodeName"));
        localHead.put("transid", request.get("transid"));
        localHead.put("cisCode", request.get("cisCode"));
        localHead.put("tradecode", request.get("tradecode"));
        localHead.put("runScript", request.get("runScript"));
        Map<String, Object> body1 = req.getBody();
        recv.put("sysHead", sysHead);
        recv.put("appHead", appHead);
        recv.put("localHead", localHead);
        recv.put("BODY", body1);
        Map<String, Object> call = this.iBspFeignClient.call(recv);
        BspResp bspResp = new BspResp();
        bspResp.setCode((String)((Map)((ArrayList)((Map)call.get("sysHead")).get("ret")).get(0)).get("retCode"));
        bspResp.setMsg((String)((Map)((ArrayList)((Map)call.get("sysHead")).get("ret")).get(0)).get("retMsg"));
        bspResp.setData(call);
        return bspResp;
    }
}

