/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.common.bsp;

import cn.com.yusys.yusp.common.annotation.TradeCommLog;
import cn.com.yusys.yusp.common.bsp.BspReq;
import cn.com.yusys.yusp.common.bsp.BspResp;
import cn.com.yusys.yusp.common.bsp.IBspFeignClient;
import cn.com.yusys.yusp.common.bsp.sec.EsbSeqNo;
import cn.com.yusys.yusp.common.bsp.sec.IdentifyUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class BspFeginServer {
    @Value(value="${esb.publicKey}")
    private String public_key;
    @Autowired
    private IBspFeignClient iBspFeignClient;

    public BspResp call(String serviceCode, String serviceScene, Map<String, Object> head, Map<String, Object> body) {
        Object tran_mode = head.get("TRAN_MODE");
        Object source_type = head.get("SOURCE_TYPE");
        Object user_lang = head.get("USER_LANG");
        Object org_sys_id = head.get("ORG_SYS_ID");
        BspReq req = new BspReq(serviceCode, serviceScene);
        Map<String, Object> header = req.getHeader();
        header.put("CONSUMER_ID", "NMGS");
        header.put("BRANCH_ID", "9350501013");
        header.put("USER_ID", "903583");
        header.put("ORG_SYS_ID", StringUtils.isEmpty((Object)org_sys_id) ? "100017" : org_sys_id);
        header.put("TRAN_MODE", StringUtils.isEmpty((Object)tran_mode) ? "ONLINE" : tran_mode);
        header.put("SOURCE_TYPE", StringUtils.isEmpty((Object)source_type) ? "0101" : source_type);
        header.put("USER_LANG", StringUtils.isEmpty((Object)user_lang) ? "CHINESE" : user_lang);
        if (head != null) {
            header.putAll(head);
        }
        req.setHeader(header);
        if (body == null) {
            body = new HashMap<String, Object>();
        }
        req.setBody(body);
        return null;
    }

    @TradeCommLog
    public BspResp call(BspReq req) {
        String yyyyMMddSSmmssSSS = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()).toString();
        String yyyyMMdd = yyyyMMddSSmmssSSS.substring(0, 8);
        String HHmmssSSS = yyyyMMddSSmmssSSS.substring(8, 17);
        String encrypt = IdentifyUtil.encrypt(yyyyMMddSSmmssSSS, this.public_key);
        Map<String, Object> request = req.getHeader();
        HashMap<String, Object> recv = new HashMap<String, Object>();
        HashMap<String, Object> SYS_HEAD = new HashMap<String, Object>();
        SYS_HEAD.put("SYS_NAME", request.get("SYS_NAME"));
        SYS_HEAD.put("SERVICE_CODE", request.get("SERVICE_CODE"));
        SYS_HEAD.put("SERVICE_SCENE", request.get("SERVICE_SCENE"));
        SYS_HEAD.put("CONSUMER_ID", request.get("CONSUMER_ID"));
        SYS_HEAD.put("TRAN_DATE", yyyyMMdd);
        SYS_HEAD.put("TRAN_TIMESTAMP", HHmmssSSS);
        SYS_HEAD.put("BRANCH_ID", request.get("BRANCH_ID"));
        SYS_HEAD.put("USER_ID", request.get("USER_ID"));
        SYS_HEAD.put("AUTH_FLAG", request.get("AUTH_FLAG"));
        Object consumer_seq_no = request.get("CONSUMER_SEQ_NO");
        SYS_HEAD.put("CONSUMER_SEQ_NO", consumer_seq_no == null || "".equals(consumer_seq_no) ? EsbSeqNo.createComsumerSeqNo() : consumer_seq_no);
        Object global_seq_no = request.get("GLOBAL_SEQ_NO");
        SYS_HEAD.put("GLOBAL_SEQ_NO", global_seq_no == null || "".equals(global_seq_no) ? EsbSeqNo.createGlobaSeqNo() : global_seq_no);
        SYS_HEAD.put("MAC_CHECK_VAL", encrypt);
        Object org_sys_id = request.get("ORG_SYS_ID");
        SYS_HEAD.put("ORG_SYS_ID", StringUtils.isEmpty((Object)org_sys_id) ? "100017" : org_sys_id);
        Object tran_mode = request.get("TRAN_MODE");
        SYS_HEAD.put("TRAN_MODE", StringUtils.isEmpty((Object)tran_mode) ? "ONLINE" : tran_mode);
        Object source_type = request.get("SOURCE_TYPE");
        SYS_HEAD.put("SOURCE_TYPE", StringUtils.isEmpty((Object)source_type) ? "0101" : source_type);
        SYS_HEAD.put("SERVER_ID", request.get("SERVER_ID"));
        SYS_HEAD.put("WS_ID", request.get("WS_ID"));
        Object user_lang = request.get("USER_LANG");
        SYS_HEAD.put("USER_LANG", StringUtils.isEmpty((Object)user_lang) ? "CHINESE" : user_lang);
        SYS_HEAD.put("SOURCE_BRANCH_NO", request.get("SOURCE_BRANCH_NO"));
        SYS_HEAD.put("DEST_BRANCH_NO", request.get("DEST_BRANCH_NO"));
        SYS_HEAD.put("MESSAGE_TYPE", request.get("MESSAGE_TYPE"));
        SYS_HEAD.put("MESSAGE_CODE", request.get("MESSAGE_CODE"));
        SYS_HEAD.put("USER_PASSWORD", request.get("USER_PASSWORD"));
        SYS_HEAD.put("USER_LEVEL", request.get("USER_LEVEL"));
        SYS_HEAD.put("USER_TYPE", request.get("USER_TYPE"));
        SYS_HEAD.put("PROGRAM_ID", request.get("PROGRAM_ID"));
        SYS_HEAD.put("APPR_FLAG", request.get("APPR_FLAG"));
        SYS_HEAD.put("MODULE_ID", request.get("MODULE_ID"));
        SYS_HEAD.put("CONSUMER_SVR_ID", request.get("CONSUMER_SVR_ID"));
        ArrayList auth = new ArrayList();
        SYS_HEAD.put("AUTH_USER_ID_ARRAY", request.get("AUTH_USER_ID_ARRAY"));
        SYS_HEAD.put("APPR_USER_ID_ARRAY", request.get("APPR_USER_ID_ARRAY"));
        HashMap<String, Object> APP_HEAD = new HashMap<String, Object>();
        Object buss_seq_no = request.get("BUSS_SEQ_NO");
        APP_HEAD.put("BUSS_SEQ_NO", buss_seq_no == null || "".equals(buss_seq_no) ? EsbSeqNo.createComsumerSeqNo() : buss_seq_no);
        APP_HEAD.put("REVERSAL_TRAN_TYPE", request.get("REVERSAL_TRAN_TYPE"));
        APP_HEAD.put("REVERSAL_SEQ_NO", request.get("REVERSAL_SEQ_NO"));
        APP_HEAD.put("REVERSAL_BUSS_SEQ_NO", request.get("REVERSAL_BUSS_SEQ_NO"));
        APP_HEAD.put("REVERSAL_DATE", request.get("REVERSAL_DATE"));
        APP_HEAD.put("QUERY_KEY", request.get("QUERY_KEY"));
        APP_HEAD.put("PAGE_START", request.get("PAGE_START"));
        APP_HEAD.put("PAGE_END", request.get("PAGE_END"));
        APP_HEAD.put("TOTAL_ROWS", request.get("TOTAL_ROWS"));
        APP_HEAD.put("TOTAL_PAGES", request.get("TOTAL_PAGES"));
        APP_HEAD.put("FILE_NAME", request.get("FILE_NAME"));
        APP_HEAD.put("FILE_SVR_IP", request.get("FILE_SVR_IP"));
        APP_HEAD.put("FILE_SVR_PORT", request.get("FILE_SVR_PORT"));
        APP_HEAD.put("FILE_SVR_PATH", request.get("FILE_SVR_PATH"));
        APP_HEAD.put("PGUP_OR_PGDN", request.get("PGUP_OR_PGDN"));
        APP_HEAD.put("TOTAL_NUM", request.get("TOTAL_NUM"));
        APP_HEAD.put("CURRENT_NUM", request.get("CURRENT_NUM"));
        APP_HEAD.put("TOTAL_FLAG", request.get("TOTAL_FLAG"));
        APP_HEAD.put("FILE_PATH", request.get("FILE_PATH"));
        APP_HEAD.put("COMPANY", request.get("COMPANY"));
        APP_HEAD.put("CLIENT_VER_RESULT", request.get("CLIENT_VER_RESULT"));
        APP_HEAD.put("TRUSTEE_INFO", request.get("TRUSTEE_INFO"));
        HashMap<String, Object> LOCAL_HEAD = new HashMap<String, Object>();
        LOCAL_HEAD.put("AUTH_RET", request.get("AUTH_RET"));
        LOCAL_HEAD.put("TRAN_CODE", request.get("TRAN_CODE"));
        LOCAL_HEAD.put("VERSION_NO", request.get("VERSION_NO"));
        LOCAL_HEAD.put("TRAN_TIME", request.get("TRAN_TIME"));
        LOCAL_HEAD.put("FILE_FLAG", request.get("FILE_FLAG"));
        LOCAL_HEAD.put("TELLER_SEQ_NO", request.get("TELLER_SEQ_NO"));
        LOCAL_HEAD.put("AUTH_TELLER_NO", request.get("AUTH_TELLER_NO"));
        LOCAL_HEAD.put("CLIENT_TYPE", request.get("CLIENT_TYPE"));
        LOCAL_HEAD.put("PWD_CHECK_FLAG", request.get("PWD_CHECK_FLAG"));
        LOCAL_HEAD.put("COMMU_SEQU_NO", request.get("COMMU_SEQU_NO"));
        LOCAL_HEAD.put("USERID", request.get("USERID"));
        LOCAL_HEAD.put("NODE_NAME", request.get("NODE_NAME"));
        LOCAL_HEAD.put("TRANSID", request.get("TRANSID"));
        LOCAL_HEAD.put("CIS_CODE", request.get("CIS_CODE"));
        LOCAL_HEAD.put("TRADECODE", request.get("TRADECODE"));
        LOCAL_HEAD.put("RUN_SCRIPT", request.get("RUN_SCRIPT"));
        Map<String, Object> body1 = req.getBody();
        recv.put("SYS_HEAD", SYS_HEAD);
        recv.put("APP_HEAD", APP_HEAD);
        recv.put("LOCAL_HEAD", LOCAL_HEAD);
        recv.put("BODY", body1);
        Map<String, Object> call = this.iBspFeignClient.call(recv);
        BspResp bspResp = new BspResp();
        bspResp.setCode((String)((Map)((ArrayList)((Map)call.get("SYS_HEAD")).get("RET")).get(0)).get("RET_CODE"));
        bspResp.setMsg((String)((Map)((ArrayList)((Map)call.get("SYS_HEAD")).get("RET")).get(0)).get("RET_MSG"));
        bspResp.setData(call);
        return bspResp;
    }
}

