/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.router.application.service;

import cn.com.yusys.yusp.pay.router.application.dto.RtPPaychnlRspDto;
import cn.com.yusys.yusp.pay.router.application.dto.RtPRouteinfoRspDto;
import cn.com.yusys.yusp.pay.router.application.dto.UpPExpmapRspDto;
import cn.com.yusys.yusp.pay.router.application.service.RouterCorpService;
import cn.com.yusys.yusp.pay.router.application.service.RouterDataProcService;
import cn.com.yusys.yusp.pay.router.application.service.RouterFilterService;
import cn.com.yusys.yusp.pay.router.application.service.RouterInitService;
import cn.com.yusys.yusp.pay.router.application.service.RtPPaychnlService;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.payment.common.base.dto.exception.YuinException;
import cn.com.yusys.yusp.payment.common.base.util.YuinBeanUtil;
import cn.com.yusys.yusp.payment.common.component.dataformat.service.MsgFieldMapCompentService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RouterService {
    @Autowired
    private RouterInitService routerInitService;
    @Autowired
    private RouterFilterService routerFilterService;
    @Autowired
    private RouterDataProcService routerDataProcService;
    @Autowired
    private RouterCorpService routerCorpService;
    @Autowired
    private RtPPaychnlService rtPPaychnlService;
    @Autowired
    private MsgFieldMapCompentService msgFieldMapCompentService;

    public YuinResultDto router(YuinRequestDto<Map<String, Object>> yuinRequestDto) throws Exception {
        try {
            JavaDict request = this.tradeInit(yuinRequestDto);
            String paychnlcode = request.getString("paychnlcode");
            boolean isComputation = false;
            if (StringUtils.isEmpty((String)paychnlcode)) {
                isComputation = true;
            }
            JavaDict routerDict = this.routerInit(request, isComputation);
            List<RtPPaychnlRspDto> rtPPaychnlList = this.filterPaychnl(routerDict, request, isComputation);
            this.dataProc(request, routerDict);
            return this.corp(request, routerDict, rtPPaychnlList);
        }
        catch (Exception e) {
            return YuinResultDto.failure((String)"500", (String)e.getMessage());
        }
    }

    public YuinResultDto computation(YuinRequestDto<Map<String, Object>> yuinRequestDto) throws Exception {
        try {
            JavaDict request = this.tradeInit(yuinRequestDto);
            JavaDict routerDict = this.routerInit(request, true);
            List<RtPPaychnlRspDto> rtPPaychnlList = this.filterPaychnl(routerDict, request, true);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("routeprodcode", routerDict.get("routeprodcode"));
            result.put("routeList", routerDict.get("routeList"));
            result.put("routePaychnlList", rtPPaychnlList);
            return YuinResultDto.sucess(result);
        }
        catch (Exception e) {
            return YuinResultDto.failure((String)"500", (String)e.getMessage());
        }
    }

    public YuinResultDto routerCorp(YuinRequestDto<Map<String, Object>> yuinRequestDto) throws Exception {
        try {
            JavaDict request = this.tradeInit(yuinRequestDto);
            String paychnlcode = request.getString("paychnlcode");
            if (StringUtils.isBlank((String)paychnlcode)) {
                return YuinResultDto.failure((String)"500", (String)"\u53ef\u7528\u652f\u4ed8\u901a\u9053\u4e0d\u80fd\u4e3a\u7a7a");
            }
            JavaDict routerDict = this.routerInit(request, false);
            List<RtPPaychnlRspDto> rtPPaychnlList = this.filterPaychnl(routerDict, request, false);
            this.dataProc(request, routerDict);
            return this.corp(request, routerDict, rtPPaychnlList);
        }
        catch (Exception e) {
            return YuinResultDto.failure((String)"500", (String)e.getMessage());
        }
    }

    public YuinResultDto initPaychnl(YuinRequestDto<Map<String, Object>> yuinRequestDto) throws Exception {
        try {
            JavaDict request = this.tradeInit(yuinRequestDto);
            JavaDict routerDict = this.routerInit(request, true);
            request.set("paychnlcode", routerDict.get("initPaychnl"));
            List<RtPPaychnlRspDto> rtPPaychnlList = this.filterPaychnl(routerDict, request, false);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("routeprodcode", routerDict.get("routeprodcode"));
            result.put("initPaychnl", routerDict.get("initPaychnl"));
            result.put("initPaychnlList", rtPPaychnlList);
            return YuinResultDto.sucess(result);
        }
        catch (Exception e) {
            return YuinResultDto.failure((String)"500", (String)e.getMessage());
        }
    }

    public YuinResultDto check(YuinRequestDto<Map<String, Object>> yuinRequestDto) throws Exception {
        try {
            JavaDict request = this.tradeInit(yuinRequestDto);
            if (StringUtils.isBlank((String)request.getString("checkPaychnlCode"))) {
                throw new YuinException("\u68c0\u67e5\u901a\u9053\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            JavaDict routerDict = this.routerInit(request, true);
            routerDict.set("initPaychnl", (Object)request.getString("checkPaychnlCode"));
            List<RtPPaychnlRspDto> rtPPaychnlList = this.filterPaychnl(routerDict, request, true);
            return YuinResultDto.sucess(rtPPaychnlList);
        }
        catch (Exception e) {
            return YuinResultDto.failure((String)"500", (String)e.getMessage());
        }
    }

    public JavaDict tradeInit(YuinRequestDto<Map<String, Object>> yuinRequestDto) throws Exception {
        JavaDict request = new JavaDict();
        Map requestMap = YuinBeanUtil.convertRequest(yuinRequestDto);
        request.setMap(requestMap);
        YuinResult result = this.msgFieldMapCompentService.B_Fld_MsgMap(request, request, request.get("sysid").toString(), request.get("appid").toString(), request.get("tradecode").toString(), "CHL->ROT", "0", "PUB");
        if (!result.isSuccess()) {
            throw new YuinException(String.format("\u63a5\u6536\u6e20\u9053\u62a5\u6587\u5b57\u6bb5\u6620\u5c04\u5931\u8d25\uff1a%s", result.getErrorMsg()));
        }
        request.set("requestdto", yuinRequestDto);
        return request;
    }

    public JavaDict routerInit(JavaDict request, boolean isComputation) throws Exception {
        JavaDict routerDict = new JavaDict();
        Map<String, Object> initMap = this.routerInitService.initMap(request);
        routerDict.setMap(initMap);
        String routeprodcode = this.routerInitService.getRouteprodcode(routerDict);
        routerDict.set("routeprodcode", (Object)routeprodcode);
        if (isComputation) {
            RtPRouteinfoRspDto rtPRouteinfoRspDto = this.routerInitService.getRouteInfo(routeprodcode);
            routerDict.set("initPaychnl", (Object)rtPRouteinfoRspDto.getPaychnllist());
            routerDict.set("filtermethod", (Object)rtPRouteinfoRspDto.getFiltermethod());
            routerDict.set("ordermethod", (Object)rtPRouteinfoRspDto.getOrdermethod());
        }
        return routerDict;
    }

    public List<RtPPaychnlRspDto> filterPaychnl(JavaDict routerDict, JavaDict request, boolean isComputation) throws Exception {
        List<RtPPaychnlRspDto> rtPPaychnlRspDtoList;
        if (isComputation) {
            String paychnlcodes = this.routerFilterService.filterByBankno(routerDict);
            rtPPaychnlRspDtoList = this.routerFilterService.listPaychnl(paychnlcodes);
            this.routerFilterService.filterDimension(routerDict, rtPPaychnlRspDtoList);
        } else {
            rtPPaychnlRspDtoList = this.rtPPaychnlService.listPaychnlSort(request.getString("paychnlcode"));
            routerDict.set("routeList", (Object)request.getString("paychnlcode"));
        }
        return rtPPaychnlRspDtoList;
    }

    public void dataProc(JavaDict request, JavaDict routerDict) {
        this.routerDataProcService.rtTranjnlSave(request, routerDict);
    }

    public YuinResultDto corp(JavaDict request, JavaDict routerDict, List<RtPPaychnlRspDto> rtPPaychnlList) throws Exception {
        Map<String, UpPExpmapRspDto> expmap = this.routerCorpService.listExpmap(request, routerDict);
        return this.routerCorpService.corp(request, routerDict, expmap, rtPPaychnlList);
    }
}

