/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.router.application.service;

import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.pay.router.application.dto.RtMFailrouteinfoReqDto;
import cn.com.yusys.yusp.pay.router.application.dto.RtPPaychnlRspDto;
import cn.com.yusys.yusp.pay.router.application.dto.UpPExpmapReqDto;
import cn.com.yusys.yusp.pay.router.application.dto.UpPExpmapRspDto;
import cn.com.yusys.yusp.pay.router.application.service.RouterDataProcService;
import cn.com.yusys.yusp.pay.router.application.service.RtMFailrouteinfoService;
import cn.com.yusys.yusp.pay.router.application.service.UpPExpmapService;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestHead;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResult;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.assembly.JavaDict;
import cn.com.yusys.yusp.payment.common.base.dto.exception.YuinException;
import cn.com.yusys.yusp.payment.common.component.dataformat.service.MsgFieldMapCompentService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class RouterCorpService {
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private UpPExpmapService upPExpmapService;
    @Autowired
    private RtMFailrouteinfoService rtMFailrouteinfoService;
    @Autowired
    private RouterDataProcService routerDataProcService;
    @Resource
    private MsgFieldMapCompentService msgFieldMapCompentService;

    public Map<String, UpPExpmapRspDto> listExpmap(JavaDict request, JavaDict routerDict) {
        String chnltradecode = request.getString("tradecode");
        String routeprodcode = routerDict.getString("routeprodcode");
        if (StringUtils.isBlank((String)chnltradecode)) {
            throw new YuinException("\u63a5\u5165\u63a5\u53e3\u4ee3\u7801tradecode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((String)routeprodcode)) {
            routeprodcode = "0";
        }
        UpPExpmapReqDto upPExpmapReqDto = new UpPExpmapReqDto();
        upPExpmapReqDto.setChnltradecode(chnltradecode);
        upPExpmapReqDto.setRouteprodcode(routeprodcode);
        upPExpmapReqDto.setDisabled("0");
        List<UpPExpmapRspDto> upPExpmapRspDtoList = this.upPExpmapService.list(upPExpmapReqDto);
        if (CollectionUtils.isEmpty(upPExpmapRspDtoList)) {
            throw new YuinException(String.format("\u63a5\u5165\u63a5\u53e3\u4ee3\u7801\u3010%s\u3011\u65e0\u53ef\u7528\u63a5\u51fa\u63a5\u53e3\u914d\u7f6e\uff01", chnltradecode));
        }
        HashMap<String, UpPExpmapRspDto> map = new HashMap<String, UpPExpmapRspDto>();
        for (UpPExpmapRspDto upPExpmapRspDto : upPExpmapRspDtoList) {
            map.put(upPExpmapRspDto.getPaychnlcode(), upPExpmapRspDto);
        }
        return map;
    }

    public YuinResultDto corp(JavaDict request, JavaDict routerDict, Map<String, UpPExpmapRspDto> expmap, List<RtPPaychnlRspDto> rtPPaychnlList) throws Exception {
        ArrayList<String> failremoteList = new ArrayList<String>();
        RtMFailrouteinfoReqDto rtMFailrouteinfoReqDto = new RtMFailrouteinfoReqDto();
        rtMFailrouteinfoReqDto.setChnlcode(request.getString("chnlcode"));
        rtMFailrouteinfoReqDto.setChnldate(request.getString("chnldate"));
        rtMFailrouteinfoReqDto.setChnlseqno(request.getString("chnlseqno"));
        if (null != routerDict) {
            rtMFailrouteinfoReqDto.setRoutelist(routerDict.getString("routeList"));
        } else {
            rtMFailrouteinfoReqDto.setRoutelist(request.getString("paychnlcode"));
        }
        YuinResultDto resultDto = null;
        boolean result = false;
        for (RtPPaychnlRspDto rtPPaychnlRspDto : rtPPaychnlList) {
            UpPExpmapRspDto upPExpmapRspDto = expmap.get(rtPPaychnlRspDto.getPaychnlcode());
            String serverip = rtPPaychnlRspDto.getServerip();
            String serverport = rtPPaychnlRspDto.getServerport();
            String expurl = upPExpmapRspDto.getExpurl();
            if (StringUtils.isEmpty((String)serverip) || StringUtils.isEmpty((String)expurl)) {
                throw new YuinException("\u63a5\u51fa\u670d\u52a1ip\u548c\u63a5\u53e3\u8def\u5f84\u672a\u914d\u7f6e");
            }
            String requestUrl = StringUtils.isNotEmpty((String)serverport) ? String.format("http://%s:%s%s", serverip, serverport, expurl) : String.format("http://%s%s", serverip, expurl);
            JavaDict requestHeadData = new JavaDict();
            JavaDict requestBodyData = new JavaDict();
            this.paychnlReqMap(request, expmap.get(rtPPaychnlRspDto.getPaychnlcode()), requestHeadData, requestBodyData);
            YuinRequestDto requestDto = (YuinRequestDto)BeanUtils.beanCopy((Object)request.get("requestdto"), YuinRequestDto.class);
            YuinRequestHead head = requestDto.getSysHead();
            requestDto.setSysHead((YuinRequestHead)BeanUtils.mapToBean((Map)requestHeadData.get(), (Object)head));
            ((Map)requestDto.getBody()).putAll(requestBodyData.get());
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity requestEntity = new HttpEntity((Object)requestDto, (MultiValueMap)httpHeaders);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(requestUrl, (Object)requestEntity, YuinResultDto.class, new Object[0]);
            if (null != responseEntity && ((YuinResultDto)responseEntity.getBody()).isSuccess()) {
                this.routerDataProcService.rtTranjnlUpdateSuccess(request, upPExpmapRspDto, StringUtils.join(failremoteList, (String)","));
                result = true;
                resultDto = (YuinResultDto)responseEntity.getBody();
                break;
            }
            rtMFailrouteinfoReqDto.setRemotecode(rtPPaychnlRspDto.getPaychnlcode());
            if (null == responseEntity) {
                rtMFailrouteinfoReqDto.setErrcode("500");
                rtMFailrouteinfoReqDto.setErrmsg("\u901a\u9053\u8fd4\u56de\u5f02\u5e38\u3010null\u3011");
            } else {
                try {
                    rtMFailrouteinfoReqDto.setErrcode(((YuinResultDto)responseEntity.getBody()).getHead().getResponseCode());
                    rtMFailrouteinfoReqDto.setErrmsg(((YuinResultDto)responseEntity.getBody()).getHead().getResponseMsg());
                }
                catch (Exception e) {
                    throw new YuinException("\u652f\u4ed8\u901a\u9053\u54cd\u5e94\u4fe1\u606f\u683c\u5f0f\u5f02\u5e38\uff01");
                }
            }
            this.rtMFailrouteinfoService.save(rtMFailrouteinfoReqDto);
            failremoteList.add(rtPPaychnlRspDto.getPaychnlcode());
            if ("RT9999".equals(rtMFailrouteinfoReqDto.getErrcode())) continue;
            break;
        }
        if (!result) {
            this.routerDataProcService.rtTranjnlUpdateFail(request, StringUtils.join(failremoteList, (String)","));
            throw new YuinException("\u652f\u4ed8\u901a\u9053\u901a\u8baf\u5931\u8d25\uff01");
        }
        return resultDto;
    }

    public void paychnlReqMap(JavaDict request, UpPExpmapRspDto upPExpmapRspDto, JavaDict requestHeadData, JavaDict requestBodyData) {
        YuinResult result = this.msgFieldMapCompentService.B_Fld_MsgMapHD(request, requestHeadData, requestBodyData, request.get("sysid").toString(), request.get("appid").toString(), upPExpmapRspDto.getExptradecode(), "ROT->PAY", "0", upPExpmapRspDto.getPaychnlcode());
        if (!result.isSuccess()) {
            throw new YuinException("\u8def\u7531\u63a5\u51fa\u62a5\u6587\u6620\u5c04\u5931\u8d25\uff01");
        }
    }
}

