/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.domain.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Arrays;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpUtils {
    public static final String SYST_UNIX = "UNIX";
    public static final String SYST_UNIX_TRIM_LEADING = "UNIX_LTRIM";
    public static final String SYST_VMS = "VMS";
    public static final String SYST_NT = "WINDOWS";
    public static final String SYST_OS2 = "OS/2";
    public static final String SYST_OS400 = "OS/400";
    public static final String SYST_AS400 = "AS/400";
    public static final String SYST_MVS = "MVS";
    public static final String SYST_L8 = "TYPE: L8";
    public static final String SYST_NETWARE = "NETWARE";
    public static final String SYST_MACOS_PETER = "MACOS PETER";
    private static final int DEFAULT_TIMEOUT = 60000;
    private static final int CONN_TIMEOUT = 60000;
    private static final Logger log = LoggerFactory.getLogger(FtpUtils.class);
    private String host;
    private int port = 21;
    private String username;
    private String password;
    private final FTPClient ftp = new FTPClient();

    public FtpUtils(String host, int port, String username, String password) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        FTPClientConfig conf = new FTPClientConfig(SYST_UNIX);
        conf.setServerLanguageCode("zh");
        this.ftp.setControlEncoding("GBK");
        this.ftp.configure(conf);
    }

    private boolean connectFtp() {
        boolean flag = false;
        try {
            long startLogin = System.currentTimeMillis();
            this.ftp.connect(this.host, this.port);
            log.info("\u8fde\u63a5\uff1a" + this.host + ":" + this.port);
            this.ftp.login(this.username, this.password);
            log.info("\u767b\u5f55:" + this.username + this.password);
            int reply = this.ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                this.ftp.disconnect();
                log.info("\u767b\u9646\u5931\u8d25");
                return false;
            }
            flag = true;
            long endLogin = System.currentTimeMillis();
            log.info("\u767b\u5f55\u6210\u529f\uff0c\u767b\u5f55\u8017\u65f6:" + (endLogin - startLogin) + "ms");
            log.info("\u5f00\u542f\u88ab\u52a8\u6a21\u5f0f");
            this.ftp.enterLocalPassiveMode();
            this.ftp.setFileType(2);
            this.ftp.setFileTransferMode(2);
        }
        catch (IOException e) {
            log.error("\u8fde\u63a5\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5730\u5740\u548c\u7aef\u53e3", (Throwable)e);
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean logOut() {
        long logOutTime = System.currentTimeMillis();
        boolean flag = false;
        try {
            if (this.ftp != null) {
                flag = this.ftp.logout();
            }
        }
        catch (IOException e) {
            log.error("\u767b\u51fa\u5f02\u5e38", (Throwable)e);
        }
        finally {
            try {
                this.ftp.disconnect();
            }
            catch (IOException e) {
                log.error("disconnect\u5f02\u5e38", (Throwable)e);
            }
        }
        long endLogOutTime = System.currentTimeMillis();
        log.info("\u767b\u51fa\u8017\u65f6:" + (endLogOutTime - logOutTime) + "ms");
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uploadFile(String path, String filename, InputStream inputStream) {
        boolean flag = false;
        if (this.connectFtp()) {
            try {
                log.info("Remote system is " + this.ftp.getSystemType());
                if (!this.makeDirectory(path)) {
                    log.info("\u521b\u5efa\u76ee\u5f55\u3010" + path + "\u3011\u5931\u8d25");
                    boolean bl = false;
                    return bl;
                }
                this.ftp.changeWorkingDirectory(path);
                this.ftp.enterLocalPassiveMode();
                this.ftp.setFileType(2);
                flag = this.ftp.storeFile(filename, inputStream);
                if (flag) {
                    log.info("\u4e0a\u4f20\u6210\u529f");
                } else {
                    log.info("\u4e0a\u4f20\u5931\u8d25");
                }
            }
            catch (SocketException e) {
                log.error("Socket\u5f02\u5e38", (Throwable)e);
            }
            catch (IOException e) {
                log.error("io\u5f02\u5e38", (Throwable)e);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    log.error("io\u5f02\u5e38", (Throwable)e);
                }
                this.logOut();
            }
        }
        return flag;
    }

    private boolean makeDirectory(String path) throws IOException {
        String[] paths = FtpUtils.getEntirelyPath(path);
        for (int j = 0; j < paths.length; ++j) {
            if (this.ftp.changeWorkingDirectory(paths[j]) || this.ftp.makeDirectory(paths[j])) continue;
            log.info("\u521b\u5efa\u76ee\u5f55" + paths[j] + "\u5931\u8d25");
            return false;
        }
        return true;
    }

    private static String[] getEntirelyPath(String path) {
        String[] pathArray = path.split("/");
        String[] paths = new String[pathArray.length];
        int j = 0;
        StringBuilder p = new StringBuilder();
        for (int i = 0; i < pathArray.length; ++i) {
            paths[j] = p.append(pathArray[i]).append("/").toString();
            ++j;
        }
        return paths;
    }

    public boolean uploadFile(String path, String filename, String sourcePath) {
        boolean flag = false;
        File file = new File(sourcePath);
        if (file.exists() && file.isFile()) {
            try {
                FileInputStream fis = new FileInputStream(file);
                flag = this.uploadFile(path, filename, fis);
            }
            catch (FileNotFoundException e) {
                log.error("File\u5f02\u5e38", (Throwable)e);
            }
        } else {
            log.error("\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u8005\u8be5\u6587\u4ef6\u662f\u6587\u4ef6\u5939");
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadFile(String downloadPath, String remotePath, String[] remoteFilenames) {
        log.info(String.format("\u4e0b\u8f7d\u6587\u4ef6 %s->>%s", remotePath, downloadPath));
        boolean downloadFlag = false;
        if (this.connectFtp()) {
            long startDownloadTime;
            block11: {
                startDownloadTime = System.currentTimeMillis();
                try {
                    if (!this.ftp.changeWorkingDirectory(remotePath)) break block11;
                    log.info("\u5f53\u524d\u76ee\u5f55:" + this.ftp.printWorkingDirectory());
                    long singleDownTime = 0L;
                    long writeFileTime = 0L;
                    long startMatchTime = System.currentTimeMillis();
                    for (String remoteFilename : remoteFilenames) {
                        long startDownloadFile = System.currentTimeMillis();
                        InputStream inputStream = this.ftp.retrieveFileStream(remoteFilename);
                        long endDownloadFile = System.currentTimeMillis();
                        log.info("\u4e0b\u8f7d\u6587\u4ef6" + remoteFilename + "\u8017\u65f6:" + (endDownloadFile - startDownloadFile) + "ms");
                        singleDownTime = endDownloadFile - startDownloadFile;
                        if (inputStream == null) {
                            log.info("\u65e0\u6cd5\u4e0b\u8f7d\u6587\u4ef6:" + remoteFilename);
                            continue;
                        }
                        log.info("\u4e0b\u8f7d\u7684\u6587\u4ef6\u662f:" + remoteFilename);
                        long startWriteFileTolocal = System.currentTimeMillis();
                        FileOutputStream output = new FileOutputStream(new File(downloadPath + remoteFilename));
                        byte[] bytes = new byte[1024];
                        int i = -1;
                        try {
                            while ((i = inputStream.read(bytes)) != -1) {
                                ((OutputStream)output).write(bytes, 0, i);
                            }
                            output.flush();
                            downloadFlag = true;
                        }
                        catch (IOException e) {
                            log.error("IO\u5f02\u5e38", (Throwable)e);
                        }
                        finally {
                            inputStream.close();
                            this.ftp.completePendingCommand();
                            ((OutputStream)output).close();
                        }
                        long endWriteFileTolocal = System.currentTimeMillis();
                        writeFileTime += endWriteFileTolocal - startWriteFileTolocal;
                    }
                    long endMatchTime = System.currentTimeMillis();
                    log.info("\u6587\u4ef6\u5339\u914d\u8017\u65f6:" + (endMatchTime - startMatchTime - singleDownTime - writeFileTime) + "ms");
                    log.info("\u5199\u5165\u6587\u4ef6\u8017\u65f6:" + writeFileTime + "ms");
                }
                catch (IOException e) {
                    log.error("\u5207\u6362\u5de5\u4f5c\u76ee\u5f55\u62a5\u9519!", (Throwable)e);
                }
            }
            long endDownloadTime = System.currentTimeMillis();
            log.info("\u4e0b\u8f7d\u6240\u6709\u6587\u4ef6\u52a0\u5339\u914d\u8017\u65f6:" + (endDownloadTime - startDownloadTime) + "ms");
            this.logOut();
        }
        return downloadFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FTPFile[] listFiles(String path) throws IOException {
        if (this.connectFtp()) {
            try {
                log.info("Remote system is " + this.ftp.getSystemType());
                log.info("\u67e5\u770b\u8def\u5f84:" + path);
                FTPFile[] ftpFiles = this.ftp.listFiles(path);
                StringBuilder fielname = new StringBuilder();
                Arrays.stream(ftpFiles).forEach(vo -> {
                    fielname.append(vo.getName());
                    fielname.append(System.getProperty("line.separator"));
                });
                log.info("\u76ee\u5f55\u5305\u542b:" + fielname.toString());
                FTPFile[] fTPFileArray = ftpFiles;
                return fTPFileArray;
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2ftp\u76ee\u5f55\u5f02\u5e38", (Throwable)e);
            }
            finally {
                this.logOut();
            }
        }
        return new FTPFile[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FTPFile[] listFiles(String pathA, String pathB) throws IOException {
        if (this.connectFtp()) {
            try {
                log.info("Remote system is " + this.ftp.getSystemType());
                log.info("\u67e5\u770b\u8def\u5f84:" + pathA);
                FTPFile[] fileA = this.ftp.listFiles(pathA);
                FTPFile[] fileB = this.ftp.listFiles(pathB);
                FTPFile[] totalFiles = new FTPFile[fileA.length + fileB.length];
                System.arraycopy(fileA, 0, totalFiles, 0, fileA.length);
                System.arraycopy(fileB, 0, totalFiles, fileA.length, fileB.length);
                FTPFile[] fTPFileArray = totalFiles;
                return fTPFileArray;
            }
            catch (Exception e) {
                log.error("\u67e5\u8be2ftp\u76ee\u5f55\u5f02\u5e38", (Throwable)e);
            }
            finally {
                this.logOut();
            }
        }
        return new FTPFile[0];
    }
}

