/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.domain.service;

import cn.com.yusys.yusp.commons.sequence.util.SequenceUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.commons.util.date.DateFormatEnum;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDBankaccbookRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDCorpaccbookRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDIndicatorruleRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsSSysparamRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsTBankbaljnlRepo;
import cn.com.yusys.yusp.pay.position.domain.service.DPS001DomainService;
import cn.com.yusys.yusp.pay.position.domain.service.PsBankWarnJnlDomainService;
import cn.com.yusys.yusp.pay.position.domain.service.PsDBankaccbookDomainService;
import cn.com.yusys.yusp.pay.position.domain.util.CommonUtil;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDBankaccbookVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDCorpaccbookVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDIndicatorruleAndPosVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsTBankbaljnlVo;
import cn.com.yusys.yusp.pay.position.domain.vo.esb.CommonRspVo;
import cn.com.yusys.yusp.pay.position.domain.vo.esb.DPS001RspVo;
import cn.com.yusys.yusp.pay.position.domain.vo.service.BankWarnJnlFormVo;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class PsTBankbaljnlThreadDomainService {
    private static final Logger log = LoggerFactory.getLogger(PsDBankaccbookDomainService.class);
    @Autowired
    private PsDBankaccbookRepo psDBankaccbookRepo;
    @Autowired
    private PsDCorpaccbookRepo psDCorpaccbookRepo;
    @Autowired
    private PsDIndicatorruleRepo psDIndicatorruleRepo;
    @Autowired
    private DPS001DomainService dps001DomainService;
    @Autowired
    private PsBankWarnJnlDomainService psBankWarnJnlDomainService;
    @Autowired
    private PsTBankbaljnlRepo psTBankbaljnlRepo;
    @Autowired
    private PsSSysparamRepo psSSysparamRepo;
    private static final int cpuThread = Runtime.getRuntime().availableProcessors() * 2;
    private String date;
    private String time;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execTask() {
        int threadNumValue;
        PsDBankaccbookVo psDBankaccbookVo = new PsDBankaccbookVo();
        psDBankaccbookVo.setStatus("1");
        List<PsDBankaccbookVo> bankaccbookVos = this.psDBankaccbookRepo.getAllByBean(psDBankaccbookVo);
        log.info(String.format("\u83b7\u53d6\u5230\u884c\u5185\u5934\u5bf8\u8d26\u6237%s \u6761", bankaccbookVos.size()));
        ArrayList<String> notAcctTypes = new ArrayList<String>(Arrays.asList("05", "06"));
        List bankaccbookVosNew = bankaccbookVos.stream().filter(vo -> !notAcctTypes.contains(vo.getAcctype())).collect(Collectors.toList());
        log.info(String.format("\u5f85\u5904\u7406\u884c\u5185\u5934\u5bf8\u8d26\u6237%s \u6761", bankaccbookVosNew.size()));
        PsDCorpaccbookVo psDCorpaccbookVo = new PsDCorpaccbookVo();
        psDCorpaccbookVo.setStatus("1");
        List<PsDCorpaccbookVo> psDCorpaccbookVos = this.psDCorpaccbookRepo.getAllByBean(psDCorpaccbookVo);
        List<PsDIndicatorruleAndPosVo> pos = this.psDIndicatorruleRepo.getPsDIndicatorruleAndPosPo();
        String batno = SequenceUtils.getSequence((String)"workseqid");
        this.date = DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT);
        this.time = DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.TIME_COMPACT);
        int n = threadNumValue = StringUtils.isBlank((CharSequence)this.psSSysparamRepo.getValueById("PS", "PS", "threadnum")) ? 0 : Integer.parseInt(this.psSSysparamRepo.getValueById("PS", "PS", "threadNum"));
        int threadNum = threadNumValue > cpuThread ? cpuThread : (threadNumValue == 0 ? 1 : threadNumValue);
        int num = bankaccbookVosNew.size() / threadNum;
        log.info(String.format("\u6bcf\u6279\u5904\u7406\u6570\u636e%s=\u603b\u6570%s/%s\u7ebf\u7a0b", num, bankaccbookVosNew.size(), threadNum));
        List split = CommonUtil.split(bankaccbookVosNew, num);
        ExecutorService threadPool = Executors.newFixedThreadPool(++threadNum);
        CountDownLatch threadLatchs = new CountDownLatch(threadNum);
        try {
            for (List list : split) {
                if (CollectionUtils.isEmpty(list)) continue;
                threadPool.submit(() -> this.proBankDate(list, threadLatchs, pos, batno));
            }
            threadPool.submit(() -> this.proCorpDate(psDCorpaccbookVos, threadLatchs, pos, batno));
        }
        catch (Exception e) {
            log.info("\u6279\u91cf\u6570\u636e\u53d1\u8d77\u6838\u5fc3\u8bf7\u6c42\u5904\u7406\u5931\u8d25");
            e.printStackTrace();
        }
        finally {
            threadPool.shutdown();
        }
        while (!threadPool.isTerminated()) {
        }
    }

    private void saveDate(List<PsTBankbaljnlVo> psTBankbaljnlVos, List<PsDBankaccbookVo> psDBankaccbookVos, List<PsDCorpaccbookVo> psDCorpaccbookVos, List<BankWarnJnlFormVo> bankWarnJnlFormVos) {
        if (CollectionUtils.nonEmpty(psTBankbaljnlVos)) {
            this.psTBankbaljnlRepo.insertList(psTBankbaljnlVos);
        }
        if (CollectionUtils.nonEmpty(psDBankaccbookVos)) {
            this.psDBankaccbookRepo.doBatchUpdateLal(psDBankaccbookVos);
        }
        if (CollectionUtils.nonEmpty(psDCorpaccbookVos)) {
            this.psDCorpaccbookRepo.doBatchUpdateLal(psDCorpaccbookVos);
        }
        try {
            if (CollectionUtils.nonEmpty(bankWarnJnlFormVos)) {
                bankWarnJnlFormVos.forEach(vo -> {
                    log.info("\u8fdb\u884c\u9884\u8b66\uff1a{}", (Object)bankWarnJnlFormVos.toString());
                    this.psBankWarnJnlDomainService.invokeBankWarnJnlHandler((BankWarnJnlFormVo)vo);
                });
            }
        }
        catch (Exception e) {
            log.info("\u9884\u8b66\u5931\u8d25\uff1a{}", (Object)bankWarnJnlFormVos.toString());
        }
    }

    private void proBankDate(List<PsDBankaccbookVo> list, CountDownLatch threadLatchs, List<PsDIndicatorruleAndPosVo> pos, String batno) {
        ArrayList<PsTBankbaljnlVo> psTBankbaljnlVos = new ArrayList<PsTBankbaljnlVo>(13);
        ArrayList<PsDBankaccbookVo> psDBankaccbookVos = new ArrayList<PsDBankaccbookVo>(list.size());
        ArrayList<BankWarnJnlFormVo> bankWarnJnlFormVos = new ArrayList<BankWarnJnlFormVo>(13);
        log.info(String.format("\u5b50\u7ebf\u7a0b%s\u5f00\u59cb\u5904\u7406\u884c\u5185\u5934\u5bf8\u8d26\u6237\u6570\u636e\u5171\u8ba1%s", Thread.currentThread().getName(), list.size()));
        int num = 1;
        int count = list.size();
        for (PsDBankaccbookVo psDBankaccbookVo1 : list) {
            log.info(String.format("\u5b50\u7ebf\u7a0b%s-\u5934\u5bf8\u8d26\u53f7%s-\u53d1\u8d77\u8bf7\u6c42 %s/%s", Thread.currentThread().getName(), psDBankaccbookVo1.getPostaccno(), num, count));
            ResponseEntity<String> responseEntity = null;
            try {
                responseEntity = this.dps001DomainService.dps001(psDBankaccbookVo1.getPostaccno());
            }
            catch (UnknownHostException e) {
                log.info(String.format("\u5b50\u7ebf\u7a0b%s-\u5934\u5bf8\u8d26\u53f7%s-\u8bf7\u6c42\u5f02\u5e38  %s/%s", Thread.currentThread().getName(), psDBankaccbookVo1.getPostaccno(), num, count));
                ++num;
                e.printStackTrace();
                continue;
            }
            String body = (String)responseEntity.getBody();
            if (HttpStatus.OK != responseEntity.getStatusCode() || StringUtils.isBlank((CharSequence)body)) {
                log.info(String.format("\u5b50\u7ebf\u7a0b%s-\u5934\u5bf8\u8d26\u53f7%s-\u5185\u8054\u5e94\u7b54\u5931\u8d25 %s/%s", Thread.currentThread().getName(), psDBankaccbookVo1.getPostaccno(), num, count));
                ++num;
                continue;
            }
            CommonRspVo commonRspVo = Optional.ofNullable(JSON.parseObject((String)body, (TypeReference)new TypeReference<CommonRspVo<DPS001RspVo>>(){}, (Feature[])new Feature[0])).orElse(new CommonRspVo());
            if (!"000000".equals(((DPS001RspVo)commonRspVo.getRecv()).getRetCd())) {
                log.info(String.format("\u5b50\u7ebf\u7a0b%s-\u5934\u5bf8\u8d26\u53f7%s-\u6838\u5fc3\u5e94\u7b54\u5931\u8d25  %s/%s", Thread.currentThread().getName(), psDBankaccbookVo1.getPostaccno(), num, count));
                ++num;
                continue;
            }
            log.info(String.format("\u5b50\u7ebf\u7a0b%s-\u5934\u5bf8\u8d26\u53f7%s\u5e94\u7b54\u6210\u529f\u5f00\u59cb\u6570\u636e\u5904\u7406 %s/%s", Thread.currentThread().getName(), psDBankaccbookVo1.getPostaccno(), num, count));
            String postaccno = ((DPS001RspVo)commonRspVo.getRecv()).getBody().getAcctNbr();
            BigDecimal todayLal = ((DPS001RspVo)commonRspVo.getRecv()).getBody().getBal();
            BigDecimal lasbal = ((DPS001RspVo)commonRspVo.getRecv()).getBody().getLastBlce();
            this.creatBankJnlVo(batno, postaccno, todayLal, lasbal, psTBankbaljnlVos);
            PsDBankaccbookVo vo1 = new PsDBankaccbookVo();
            vo1.setPostaccno(postaccno);
            vo1.setClearbrno(psDBankaccbookVo1.getClearbrno());
            vo1.setTodaybal(todayLal);
            vo1.setLastbal(lasbal);
            vo1.setModifier("taskjob");
            vo1.setModifytime(DateUtils.getCurrDateTimeStr());
            psDBankaccbookVos.add(vo1);
            List<PsDIndicatorruleAndPosVo> pos1 = pos.stream().filter(vo3 -> postaccno.equals(vo3.getPostaccno())).collect(Collectors.toList());
            if (CollectionUtils.nonEmpty(pos1)) {
                pos1.forEach(voc -> {
                    BankWarnJnlFormVo vo;
                    if ("04001".equals(voc.getIndicatorcode()) && todayLal.compareTo(voc.getIndicatorval()) >= 0) {
                        vo = new BankWarnJnlFormVo(psDBankaccbookVo1.getClearbrno(), voc.getPostaccno(), String.valueOf(todayLal));
                        bankWarnJnlFormVos.add(vo);
                    }
                    if ("04002".equals(voc.getIndicatorcode()) && todayLal.compareTo(voc.getIndicatorval()) <= 0) {
                        vo = new BankWarnJnlFormVo(psDBankaccbookVo1.getClearbrno(), voc.getPostaccno(), String.valueOf(todayLal));
                        bankWarnJnlFormVos.add(vo);
                    }
                });
            }
            log.info(String.format("\u5b50\u7ebf\u7a0b%s-\u5934\u5bf8\u8d26\u53f7%s \u6570\u636e\u5904\u7406\u5b8c\u6210 %s/%s", Thread.currentThread().getName(), psDBankaccbookVo1.getPostaccno(), num, count));
            ++num;
        }
        this.saveDate(psTBankbaljnlVos, psDBankaccbookVos, null, bankWarnJnlFormVos);
        log.info(String.format("---------\u5b50\u7ebf\u7a0b%s\u6267\u884c\u5b8c\u6bd5", Thread.currentThread().getName()));
    }

    private void proCorpDate(List<PsDCorpaccbookVo> list, CountDownLatch threadLatchs, List<PsDIndicatorruleAndPosVo> pos, String batno) {
        ArrayList<PsTBankbaljnlVo> psTBankbaljnlVos = new ArrayList<PsTBankbaljnlVo>(13);
        ArrayList<PsDCorpaccbookVo> psDCorpaccbookVos = new ArrayList<PsDCorpaccbookVo>(list.size());
        ArrayList<BankWarnJnlFormVo> bankWarnJnlFormVos = new ArrayList<BankWarnJnlFormVo>(13);
        log.info(String.format("\u5b50\u7ebf\u7a0b%s\u5f00\u59cb\u5904\u7406\u4e09\u65b9\u5934\u5bf8\u8d26\u6237\u6570\u636e\u5171\u8ba1%s", Thread.currentThread().getName(), list.size()));
        int num = 1;
        int count = list.size();
        for (PsDCorpaccbookVo psDCorpaccbookVo : list) {
            log.info(String.format("\u5b50\u7ebf\u7a0b%s-\u4e09\u65b9\u5934\u5bf8\u8d26\u53f7%s\u53d1\u8d77\u8bf7\u6c42 %s/%s", Thread.currentThread().getName(), psDCorpaccbookVo.getPostaccno(), num, count));
            ResponseEntity<String> responseEntity = null;
            try {
                responseEntity = this.dps001DomainService.dps001(psDCorpaccbookVo.getPostaccno());
            }
            catch (UnknownHostException e) {
                log.info(String.format("\u5b50\u7ebf\u7a0b%s-\u4e09\u65b9\u5934\u5bf8\u8d26\u53f7%s\u8bf7\u6c42\u5f02\u5e38 %s/%s", Thread.currentThread().getName(), psDCorpaccbookVo.getPostaccno(), num, count));
                ++num;
                e.printStackTrace();
                continue;
            }
            String body = (String)responseEntity.getBody();
            if (HttpStatus.OK != responseEntity.getStatusCode() || StringUtils.isBlank((CharSequence)body)) {
                log.info(String.format("\u5b50\u7ebf\u7a0b%s-\u4e09\u65b9\u5934\u5bf8\u8d26\u53f7%s\u5185\u8054\u5e94\u7b54\u5931\u8d25 %s/%s", Thread.currentThread().getName(), psDCorpaccbookVo.getPostaccno(), num, count));
                ++num;
                continue;
            }
            CommonRspVo commonRspVo = Optional.ofNullable(JSON.parseObject((String)body, (TypeReference)new TypeReference<CommonRspVo<DPS001RspVo>>(){}, (Feature[])new Feature[0])).orElse(new CommonRspVo());
            if (!"000000".equals(((DPS001RspVo)commonRspVo.getRecv()).getRetCd())) {
                log.info(String.format("\u5b50\u7ebf\u7a0b%s-\u4e09\u65b9\u5934\u5bf8\u8d26\u53f7%s-\u6838\u5fc3\u5e94\u7b54\u5931\u8d25- %s/%s", Thread.currentThread().getName(), psDCorpaccbookVo.getPostaccno(), num, count));
                ++num;
                continue;
            }
            log.info(String.format("\u5b50\u7ebf\u7a0b%s-\u4e09\u65b9\u5934\u5bf8\u8d26\u53f7%s-\u8bf7\u6c42\u6210\u529f\u5f00\u59cb\u5904\u7406\u6570\u636e- %s/%s", Thread.currentThread().getName(), psDCorpaccbookVo.getPostaccno(), num, count));
            String postaccno = ((DPS001RspVo)commonRspVo.getRecv()).getBody().getAcctNbr();
            BigDecimal todayLal = ((DPS001RspVo)commonRspVo.getRecv()).getBody().getBal();
            BigDecimal lasbal = ((DPS001RspVo)commonRspVo.getRecv()).getBody().getLastBlce();
            PsDCorpaccbookVo vo2 = new PsDCorpaccbookVo();
            vo2.setPostaccno(postaccno);
            vo2.setClearbrno(psDCorpaccbookVo.getClearbrno());
            vo2.setBanktodaybal(todayLal);
            vo2.setBanklastbal(lasbal);
            vo2.setModifier("taskjob");
            vo2.setModifytime(DateUtils.getCurrDateTimeStr());
            psDCorpaccbookVos.add(vo2);
            this.creatBankJnlVo(batno, postaccno, todayLal, lasbal, psTBankbaljnlVos);
            List<PsDIndicatorruleAndPosVo> pos1 = pos.stream().filter(vo3 -> postaccno.equals(vo3.getPostaccno())).collect(Collectors.toList());
            if (CollectionUtils.nonEmpty(pos1)) {
                pos1.forEach(voc -> {
                    BankWarnJnlFormVo vo;
                    if ("04001".equals(voc.getIndicatorcode()) && todayLal.compareTo(voc.getIndicatorval()) >= 0) {
                        vo = new BankWarnJnlFormVo(psDCorpaccbookVo.getClearbrno(), voc.getPostaccno(), String.valueOf(todayLal));
                        bankWarnJnlFormVos.add(vo);
                    }
                    if ("04002".equals(voc.getIndicatorcode()) && todayLal.compareTo(voc.getIndicatorval()) <= 0) {
                        vo = new BankWarnJnlFormVo(psDCorpaccbookVo.getClearbrno(), voc.getPostaccno(), String.valueOf(todayLal));
                        bankWarnJnlFormVos.add(vo);
                    }
                });
            }
            log.info(String.format("\u5b50\u7ebf\u7a0b%s-\u4e09\u65b9\u5934\u5bf8\u8d26\u53f7%s-\u5904\u7406\u6570\u636e\u5b8c\u6210- %s/%s", Thread.currentThread().getName(), psDCorpaccbookVo.getPostaccno(), num, count));
            ++num;
        }
        this.saveDate(psTBankbaljnlVos, null, psDCorpaccbookVos, bankWarnJnlFormVos);
        log.info(String.format("---------\u5b50\u7ebf\u7a0b%s\u6267\u884c\u5b8c\u6bd5", Thread.currentThread().getName()));
    }

    private void creatBankJnlVo(String batno, String postaccno, BigDecimal todayLal, BigDecimal lasbal, List<PsTBankbaljnlVo> psTBankbaljnlVos) {
        PsTBankbaljnlVo vo = new PsTBankbaljnlVo();
        vo.setAppid("PS");
        vo.setSysid("PS");
        vo.setWorkseqid(SequenceUtils.getSequence((String)"workseqid"));
        vo.setWorkdate(this.date);
        vo.setWorktime(this.time);
        vo.setPostaccno(postaccno);
        vo.setTodaybal(todayLal);
        vo.setLastbal(lasbal);
        vo.setBatno(batno);
        psTBankbaljnlVos.add(vo);
    }
}

