/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.domain.service;

import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.commons.util.date.DateFormatEnum;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.commons.util.io.FileUtils;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDBankaccbookRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDCorpaccbookRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsTBankbaljnlRepo;
import cn.com.yusys.yusp.pay.position.domain.service.PsCorpWarnJnlDomainService;
import cn.com.yusys.yusp.pay.position.domain.service.PsTBankbaljnlThreadDomainService;
import cn.com.yusys.yusp.pay.position.domain.util.CommonUtil;
import cn.com.yusys.yusp.pay.position.domain.util.FtpUtils;
import cn.com.yusys.yusp.pay.position.domain.util.PSEsbConfigurationMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDBankaccbookVo;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.net.ftp.FTPFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PsTBankbaljnlDomainService {
    private static final Logger log = LoggerFactory.getLogger(PsTBankbaljnlDomainService.class);
    @Autowired
    private PsDBankaccbookRepo psDBankaccbookRepo;
    @Autowired
    private PsDCorpaccbookRepo psDCorpaccbookRepo;
    @Autowired
    private PsTBankbaljnlRepo psTBankbaljnlRepo;
    @Autowired
    private PsCorpWarnJnlDomainService psCorpWarnJnlDomainService;
    @Autowired
    private PSEsbConfigurationMsg psEsbConfigurationMsg;
    @Autowired
    private PsTBankbaljnlThreadDomainService psTBankbaljnlThreadDomainService;

    public void TaskSynchronousCore() throws IOException, InterruptedException {
        log.info("PS01003\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u6267\u884c");
        long start = System.currentTimeMillis();
        this.psTBankbaljnlThreadDomainService.execTask();
        long end = System.currentTimeMillis();
        log.info("PS01003\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5b8c\u6210 ,\u5171\u82b1\u8d39\u65f6\u95f4\uff1a{}\u79d2", (Object)((end - start) / 1000L));
    }

    public void TaskSynchronousBigData() throws Exception {
        log.info("PS01004\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u6267\u884c");
        String date = DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT);
        String filePath = CommonUtil.getAbsolutePath(this.psEsbConfigurationMsg.getFtpFile()).concat("/").concat(date).concat("/").concat("OR");
        String fileName = this.psEsbConfigurationMsg.getOrDownFileName();
        File file = new File(filePath + "/" + fileName);
        if (file.exists()) {
            log.info("PS01004\u4eca\u65e5\u5df2\u7ecf\u6267\u884c\u65e0\u9700\u6267\u884c");
            return;
        }
        if (!this.getFileFromBigDate(filePath)) {
            log.info("\u4e0b\u8f7d\u5927\u6570\u636e\u6587\u4ef6\u5230\u672c\u5730\u5931\u8d25");
            return;
        }
        List strings = FileUtils.readAllLines((String)filePath.concat("/").concat(this.psEsbConfigurationMsg.getOrDownFileName()), (String)"UTF-8");
        Assert.notEmpty((Collection)strings, (String)"\u83b7\u53d6\u5230\u7684\u5927\u6570\u636e\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a");
        Map<String, List<PsDBankaccbookVo>> map = this.proceBigData(strings);
        if (CollectionUtils.nonEmpty((Collection)map.get("PS_D_BANKACCBOOK_UPDATE"))) {
            this.psDBankaccbookRepo.doBatchUpdateBigData(map.get("PS_D_BANKACCBOOK_UPDATE"));
        }
        if (CollectionUtils.nonEmpty((Collection)map.get("PS_D_BANKACCBOOK_INSERT"))) {
            this.psDBankaccbookRepo.doBatchInsertBigData(map.get("PS_D_BANKACCBOOK_INSERT"));
        }
    }

    private boolean getFileFromBigDate(String filePath) throws Exception {
        Files.createDirectories(Paths.get(filePath, new String[0]), new FileAttribute[0]);
        String path = this.psEsbConfigurationMsg.getOrfilepath().concat("/").concat(DateUtils.getYesterday((String)DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT), (String)"yyyyMMdd"));
        FtpUtils ftpUtils = new FtpUtils(this.psEsbConfigurationMsg.getOrip(), 21, this.psEsbConfigurationMsg.getOrftpuser(), this.psEsbConfigurationMsg.getOrftppass());
        FTPFile[] ftpFiles = ftpUtils.listFiles(path);
        if (Arrays.stream(ftpFiles).anyMatch(vo -> this.psEsbConfigurationMsg.getOrCtrlFileName().equals(vo.getName()))) {
            return ftpUtils.downloadFile(filePath + "/", path, new String[]{this.psEsbConfigurationMsg.getOrDownFileName()});
        }
        log.info("\u5927\u6570\u636e\u6682\u672a\u751f\u6210\u6587\u4ef6");
        return false;
    }

    private Map<String, List<PsDBankaccbookVo>> proceBigData(List<String> strings) {
        ArrayList<PsDBankaccbookVo> psDBankaccbookVosUpdate = new ArrayList<PsDBankaccbookVo>(strings.size());
        ArrayList<PsDBankaccbookVo> psDBankaccbookVosInsert = new ArrayList<PsDBankaccbookVo>(strings.size());
        PsDBankaccbookVo psDBankaccbookVo = new PsDBankaccbookVo();
        psDBankaccbookVo.setAcctype("05");
        List<PsDBankaccbookVo> vos = this.psDBankaccbookRepo.getAllByBean(psDBankaccbookVo);
        List<PsDBankaccbookVo> posorgtypeVos = this.psDBankaccbookRepo.getPosorgtype();
        log.info("\u5f00\u59cb\u83b7\u53d6\u5230\u7684\u5927\u6570\u636e\u6587\u4ef6\u6570\u636e\u5408\u8ba1:" + strings.size());
        for (String str : strings) {
            PsDBankaccbookVo vo1;
            byte[] bytes = str.getBytes();
            if (bytes[bytes.length - 1] != this.psEsbConfigurationMsg.getOrEndAsciiPlit()) continue;
            byte[] bytesNew = new byte[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                byte aByte = bytes[i];
                if (aByte == this.psEsbConfigurationMsg.getOrAsciiPlit()) {
                    bytesNew[i] = 124;
                    continue;
                }
                if (aByte == this.psEsbConfigurationMsg.getOrEndAsciiPlit()) break;
                bytesNew[i] = aByte;
            }
            String strNew = new String(bytesNew);
            log.info("\u5904\u7406\u540e\u6570\u636e:" + strNew);
            String[] split = strNew.split("\\|");
            String clearbrno = split[1].trim();
            BigDecimal amout = new BigDecimal(split[2].trim());
            if (vos.stream().filter(vo -> vo.getClearbrno().equals(clearbrno)).count() > 0L) {
                vo1 = new PsDBankaccbookVo();
                vo1.setClearbrno(clearbrno);
                vo1.setLastbal(amout);
                vo1.setModifier("taskjob");
                vo1.setModifytime(DateUtils.getCurrDateTimeStr());
                vo1.setAcctype("05");
                psDBankaccbookVosUpdate.add(vo1);
                continue;
            }
            vo1 = new PsDBankaccbookVo();
            vo1.setAppid("PS");
            vo1.setSysid("PS");
            vo1.setClearbrno(clearbrno);
            vo1.setPostaccno(clearbrno);
            vo1.setPosname("\u4e0a\u65e5\u5404\u9879\u5b58\u6b3e\u5408\u8ba1");
            Optional<PsDBankaccbookVo> optional = posorgtypeVos.stream().filter(vo -> clearbrno.equals(vo.getClearbrno())).findFirst();
            String Posorgtype = StringUtils.isBlank((CharSequence)optional.get().getPosorgtype()) ? "04" : optional.get().getPosorgtype();
            vo1.setPosorgtype(Posorgtype);
            vo1.setAcctype("05");
            vo1.setStatus("1");
            vo1.setLastbal(amout);
            vo1.setQueryflag("03");
            vo1.setCreator("taskjob");
            vo1.setCreatetime(DateUtils.getCurrDateTimeStr());
            psDBankaccbookVosInsert.add(vo1);
        }
        HashMap<String, List<PsDBankaccbookVo>> map = new HashMap<String, List<PsDBankaccbookVo>>(2);
        map.put("PS_D_BANKACCBOOK_UPDATE", psDBankaccbookVosUpdate);
        map.put("PS_D_BANKACCBOOK_INSERT", psDBankaccbookVosInsert);
        log.info(String.format("\u5f85\u66f4\u65b0\u5927\u6570\u636e\u4f59\u989d\u673a\u6784%s\u6761-\u5f85\u65b0\u589e\u5927\u6570\u636e\u4f59\u989d\u673a\u6784%s\u6761", psDBankaccbookVosUpdate.size(), psDBankaccbookVosInsert.size()));
        return map;
    }
}

