/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.domain.service;

import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDIndicatorruleRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsMHvtranjnlRepo;
import cn.com.yusys.yusp.pay.position.domain.util.CommonUtil;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDIndicatorruleVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsMHvtranjnlVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsMPaytranjnlVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PsHvTranJnlDomainService {
    private static final Logger log = LoggerFactory.getLogger(PsHvTranJnlDomainService.class);
    @Autowired
    private PsDIndicatorruleRepo psDIndicatorruleRepo;
    @Autowired
    private PsMHvtranjnlRepo psMHvtranjnlRepo;

    public void invokeHvTranJnlHandler(PsMPaytranjnlVo paytranjnlVo) {
        String brNo = paytranjnlVo.getBrno();
        String chnlcode = paytranjnlVo.getChnlcode();
        BigDecimal amt = paytranjnlVo.getAmt();
        log.info("\u6536\u5230\u652f\u4ed8\u6d41\u6c34\u8bb0\u5f55\u901a\u77e5,chnlcode=" + chnlcode);
        ArrayList<String> codeList = new ArrayList<String>();
        codeList.add("04005");
        List<PsDIndicatorruleVo> indicatorruleVoList = this.psDIndicatorruleRepo.getIndicatorRuleInfo(brNo, codeList);
        if (CollectionUtils.isEmpty(indicatorruleVoList)) {
            log.info(brNo + "\u672a\u914d\u7f6e\u6307\u6807\u9650\u989d,\u5ffd\u7565\u901a\u77e5");
            return;
        }
        PsDIndicatorruleVo indicatorruleVo = indicatorruleVoList.get(0);
        String monitorFlag = indicatorruleVo.getMonitorflag();
        BigDecimal limitAmt = indicatorruleVo.getIndicatorval();
        if ("1".equals(monitorFlag) && amt.compareTo(limitAmt) == 1) {
            PsMHvtranjnlVo vo = new PsMHvtranjnlVo();
            vo.setAcctype(paytranjnlVo.getAcctype());
            vo.setAmt(amt);
            vo.setAppid("PS");
            vo.setBrno(paytranjnlVo.getBrno());
            vo.setBusitype(paytranjnlVo.getBusitype());
            vo.setChnlcode(paytranjnlVo.getAcctype());
            vo.setCorppway(paytranjnlVo.getCorppway());
            vo.setCurcode(paytranjnlVo.getCurcode());
            vo.setCvsamt(amt);
            vo.setDcflag(paytranjnlVo.getDcflag());
            vo.setMbflag(paytranjnlVo.getMbflag());
            vo.setPayeeaccno(paytranjnlVo.getPayeeaccno());
            vo.setPayeename(paytranjnlVo.getPayeename());
            vo.setPayeraccno(paytranjnlVo.getPayeraccno());
            vo.setPayername(paytranjnlVo.getPayername());
            vo.setPmtdrt(CommonUtil.getPaymentDirection(vo.getMbflag(), vo.getDcflag()));
            vo.setPurposermk(paytranjnlVo.getPurpose());
            vo.setRecvbankno(paytranjnlVo.getRecvbankno());
            vo.setSendbankno(paytranjnlVo.getSendbankno());
            vo.setSysid("PS");
            vo.setTrancode(paytranjnlVo.getTradecode());
            vo.setWorkdate(paytranjnlVo.getWorkdate());
            vo.setWorkseqid(paytranjnlVo.getWorkseqid());
            vo.setWorktime(paytranjnlVo.getWorktime());
            this.psMHvtranjnlRepo.save(vo);
        }
    }
}

