/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.domain.service;

import cn.com.yusys.yusp.commons.sequence.util.SequenceUtils;
import cn.com.yusys.yusp.commons.util.date.DateFormatEnum;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.pay.position.domain.util.CommonUtil;
import cn.com.yusys.yusp.pay.position.domain.util.PSEsbConfigurationMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.esb.EsbReqMsgVo;
import cn.com.yusys.yusp.pay.position.domain.vo.esb.HostCbsstdReqVo;
import cn.com.yusys.yusp.pay.position.domain.vo.esb.SVS310ReqBody;
import cn.com.yusys.yusp.pay.position.domain.vo.esb.SVS310ReqVo;
import cn.com.yusys.yusp.payment.common.base.dto.ReqCommInfo;
import com.alibaba.fastjson.JSON;
import java.net.UnknownHostException;
import java.util.Map;
import net.sf.cglib.beans.BeanMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class SVS310DomainService {
    private static final Logger log = LoggerFactory.getLogger(SVS310DomainService.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private PSEsbConfigurationMsg psEsbConfigurationMsg;

    public ResponseEntity<String> svs310502(String filepath, String filename) throws UnknownHostException {
        ReqCommInfo reqCommInfo = this.createHostReq502CommInfo(filepath, filename);
        log.info(String.format("SVS310-502\u751f\u6210\u62a5\u6587\u6210\u529f%s", JSON.toJSONString((Object)reqCommInfo)));
        String url = this.psEsbConfigurationMsg.getUrl();
        log.info(String.format("SVS310-502\u53d1\u8d77\u8bf7\u6c42\uff1a\u8bf7\u6c42\u8def\u5f84%s ", url));
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)reqCommInfo, String.class, new Object[0]);
        log.info(String.format("SVS310-502\u5e94\u7b54\u62a5\u6587%s ", JSON.toJSONString((Object)responseEntity)));
        return responseEntity;
    }

    public ResponseEntity<String> svs310591(String filePath310, String filName) throws UnknownHostException {
        ReqCommInfo reqCommInfo = this.createHostReq591CommInfo(filePath310, filName);
        log.info(String.format("SVS310-591\u751f\u6210\u62a5\u6587\u6210\u529f%s", JSON.toJSONString((Object)reqCommInfo)));
        String url = this.psEsbConfigurationMsg.getUrl();
        log.info(String.format("SVS310-591\u53d1\u8d77\u8bf7\u6c42\uff1a\u8bf7\u6c42\u8def\u5f84%s ", url));
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)reqCommInfo, String.class, new Object[0]);
        log.info(String.format("SVS310-591\u5e94\u7b54\u62a5\u6587%s ", JSON.toJSONString((Object)responseEntity)));
        return responseEntity;
    }

    private ReqCommInfo createHostReq502CommInfo(String filepath, String filename) throws UnknownHostException {
        log.info("SVS310-502\u751f\u6210\u62a5\u6587\u5f00\u59cb---");
        ReqCommInfo reqCommInfo = new ReqCommInfo();
        reqCommInfo.setSysid("FXPS");
        reqCommInfo.setAppid("FXPS");
        reqCommInfo.setHostcommid("FXPS");
        EsbReqMsgVo esbReqMsgVo = new EsbReqMsgVo();
        esbReqMsgVo.setMsgCd("CBS.00SVS3100.01");
        esbReqMsgVo.setSeqNb(SequenceUtils.getSequence((String)"esbseqid"));
        log.info(String.format("seqNb\uff1a%s", esbReqMsgVo.getSeqNb()));
        esbReqMsgVo.setSndAppCd(this.psEsbConfigurationMsg.getAppcd());
        esbReqMsgVo.setSndDt(DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT));
        esbReqMsgVo.setSndTm(DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.TIME_COMPACT));
        esbReqMsgVo.setCallTyp("SYN");
        esbReqMsgVo.setRcvAppCd("CBS");
        HostCbsstdReqVo hostCbsstdreqVo = new HostCbsstdReqVo();
        String time = DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.TIME).replace(':', '.');
        String date = DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DEFAULT);
        String seqid = SequenceUtils.getSequence((String)"hostseqid");
        log.info(String.format("hostseqid\uff1a%s", seqid));
        hostCbsstdreqVo.setInfTp("RQ");
        hostCbsstdreqVo.setSvcCd("SVS310");
        hostCbsstdreqVo.setBsnTxDt(date);
        hostCbsstdreqVo.setSysDt(date);
        hostCbsstdreqVo.setSysTm(time);
        hostCbsstdreqVo.setBrNbr("01101");
        hostCbsstdreqVo.setSecFlg("0");
        hostCbsstdreqVo.setTlrNbr("888888");
        hostCbsstdreqVo.setTxFlg("0");
        hostCbsstdreqVo.setTxSeqNbr(seqid);
        hostCbsstdreqVo.setAuthInfFlg("0");
        hostCbsstdreqVo.setInptWordFlg("0");
        hostCbsstdreqVo.setSignInfFlg("0");
        hostCbsstdreqVo.setChkTlrNbr("000000    ");
        hostCbsstdreqVo.setBranchTmlNbr("          ");
        hostCbsstdreqVo.setUpldFldNmLen("0000");
        hostCbsstdreqVo.setSgnFld("00000000000000000000000000000000000000000000000000000000000");
        hostCbsstdreqVo.setCnlCd(this.psEsbConfigurationMsg.getAppcd());
        hostCbsstdreqVo.setEqmtTpCd("AB");
        hostCbsstdreqVo.setPtTxCd("SVS310");
        hostCbsstdreqVo.setPtTxDt(date);
        hostCbsstdreqVo.setPtTxTm(time);
        hostCbsstdreqVo.setPtSeqNbr(seqid);
        hostCbsstdreqVo.setExprTxCd("SVS310");
        hostCbsstdreqVo.setExprDt(date);
        hostCbsstdreqVo.setExprTm(time);
        hostCbsstdreqVo.setExprSeqNbr(seqid);
        hostCbsstdreqVo.setReqIP(CommonUtil.getLinuxLocalIp());
        hostCbsstdreqVo.setTmlNbr("0000000000");
        hostCbsstdreqVo.setSvcInptCtrlTp("10101000000000000000");
        SVS310ReqBody svs310ReqBody = new SVS310ReqBody();
        svs310ReqBody.setFileTp("502");
        svs310ReqBody.setBsnDt("1900-01-01");
        svs310ReqBody.setEndDt(date);
        svs310ReqBody.setTxCd("SVS310");
        svs310ReqBody.setTlrNbr("888888");
        svs310ReqBody.setCtrlTp("00000000000000000000");
        svs310ReqBody.setRmtIp(CommonUtil.getLinuxLocalIp());
        svs310ReqBody.setRmtUserNm(this.psEsbConfigurationMsg.getFtpUser());
        svs310ReqBody.setRmtUserPwd(this.psEsbConfigurationMsg.getFtpPass());
        svs310ReqBody.setRmtCtlg(filepath);
        svs310ReqBody.setFileName(filename);
        svs310ReqBody.setSprtr(this.psEsbConfigurationMsg.getPlit());
        SVS310ReqVo svs310ReqVo = new SVS310ReqVo();
        svs310ReqVo.setMsg(esbReqMsgVo);
        svs310ReqVo.setCBSSTDREQ(hostCbsstdreqVo);
        svs310ReqVo.setRequest(svs310ReqBody);
        BeanMap sender = BeanMap.create((Object)svs310ReqVo);
        reqCommInfo.setSender((Map)sender);
        return reqCommInfo;
    }

    private ReqCommInfo createHostReq591CommInfo(String filePath310, String filName) throws UnknownHostException {
        log.info("SVS310-91\u751f\u6210\u62a5\u6587\u5f00\u59cb---");
        ReqCommInfo reqCommInfo = new ReqCommInfo();
        reqCommInfo.setSysid("FXPS");
        reqCommInfo.setAppid("FXPS");
        reqCommInfo.setHostcommid("FXPS");
        EsbReqMsgVo esbReqMsgVo = new EsbReqMsgVo();
        esbReqMsgVo.setMsgCd("CBS.00SVS3100.01");
        esbReqMsgVo.setSeqNb(SequenceUtils.getSequence((String)"esbseqid"));
        log.info(String.format("seqNb\uff1a%s", esbReqMsgVo.getSeqNb()));
        esbReqMsgVo.setSndAppCd(this.psEsbConfigurationMsg.getAppcd());
        esbReqMsgVo.setSndDt(DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT));
        esbReqMsgVo.setSndTm(DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.TIME_COMPACT));
        esbReqMsgVo.setCallTyp("SYN");
        esbReqMsgVo.setRcvAppCd("CBS");
        HostCbsstdReqVo hostCbsstdreqVo = new HostCbsstdReqVo();
        String time = DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.TIME).replace(':', '.');
        String date = DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DEFAULT);
        String seqid = SequenceUtils.getSequence((String)"hostseqid");
        log.info(String.format("hostseqid\uff1a%s", seqid));
        hostCbsstdreqVo.setInfTp("RQ");
        hostCbsstdreqVo.setSvcCd("SVS310");
        hostCbsstdreqVo.setBsnTxDt(date);
        hostCbsstdreqVo.setSysDt(date);
        hostCbsstdreqVo.setSysTm(time);
        hostCbsstdreqVo.setBrNbr("01101");
        hostCbsstdreqVo.setSecFlg("0");
        hostCbsstdreqVo.setTlrNbr("888888");
        hostCbsstdreqVo.setTxFlg("0");
        hostCbsstdreqVo.setTxSeqNbr(seqid);
        hostCbsstdreqVo.setAuthInfFlg("0");
        hostCbsstdreqVo.setInptWordFlg("0");
        hostCbsstdreqVo.setSignInfFlg("0");
        hostCbsstdreqVo.setChkTlrNbr("000000    ");
        hostCbsstdreqVo.setBranchTmlNbr("          ");
        hostCbsstdreqVo.setUpldFldNmLen("0000");
        hostCbsstdreqVo.setSgnFld("00000000000000000000000000000000000000000000000000000000000");
        hostCbsstdreqVo.setCnlCd(this.psEsbConfigurationMsg.getAppcd());
        hostCbsstdreqVo.setEqmtTpCd("AB");
        hostCbsstdreqVo.setPtTxCd("SVS310");
        hostCbsstdreqVo.setPtTxDt(date);
        hostCbsstdreqVo.setPtTxTm(time);
        hostCbsstdreqVo.setPtSeqNbr(seqid);
        hostCbsstdreqVo.setExprTxCd("SVS310");
        hostCbsstdreqVo.setExprDt(date);
        hostCbsstdreqVo.setExprTm(time);
        hostCbsstdreqVo.setExprSeqNbr(seqid);
        hostCbsstdreqVo.setReqIP(CommonUtil.getLinuxLocalIp());
        hostCbsstdreqVo.setTmlNbr("0000000000");
        hostCbsstdreqVo.setSvcInptCtrlTp("10101000000000000000");
        SVS310ReqBody svs310ReqBody = new SVS310ReqBody();
        svs310ReqBody.setFileTp("591");
        svs310ReqBody.setBsnDt(date);
        svs310ReqBody.setEndDt(date);
        svs310ReqBody.setTxCd("SVS310");
        svs310ReqBody.setTlrNbr("888888");
        svs310ReqBody.setCtrlTp("00000000000000000000");
        svs310ReqBody.setRmtIp(CommonUtil.getLinuxLocalIp());
        svs310ReqBody.setRmtUserNm(this.psEsbConfigurationMsg.getFtpUser());
        svs310ReqBody.setRmtUserPwd(this.psEsbConfigurationMsg.getFtpPass());
        svs310ReqBody.setRmtCtlg(filePath310);
        svs310ReqBody.setFileName(filName);
        svs310ReqBody.setSprtr(this.psEsbConfigurationMsg.getPlit());
        SVS310ReqVo svs310ReqVo = new SVS310ReqVo();
        svs310ReqVo.setMsg(esbReqMsgVo);
        svs310ReqVo.setCBSSTDREQ(hostCbsstdreqVo);
        svs310ReqVo.setRequest(svs310ReqBody);
        BeanMap sender = BeanMap.create((Object)svs310ReqVo);
        reqCommInfo.setSender((Map)sender);
        return reqCommInfo;
    }
}

