/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.domain.service;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDBranchadmRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDZonemanagementRepo;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.PsCustomDictVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDictQuqryVo;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PsCustomDictDomainService {
    private static final Logger log = LoggerFactory.getLogger(PsCustomDictDomainService.class);
    @Autowired
    private PsDBranchadmRepo psDBranchadmRepo;
    @Autowired
    private PsDZonemanagementRepo psDZonemanagementRepo;

    public IPage<PsCustomDictVo> getBranchadmDict(PsCustomDictVo psCustomDictVo) {
        IPage<PsCustomDictVo> ps10000DetRspDtos = null;
        this.createCusWhereSql(psCustomDictVo);
        switch (StringUtils.isBlank((CharSequence)psCustomDictVo.getDictcode()) ? "9999" : psCustomDictVo.getDictcode()) {
            case "branchDict": {
                ps10000DetRspDtos = this.psDBranchadmRepo.getBranchadmDict(psCustomDictVo);
                break;
            }
            case "zoneDict": {
                ps10000DetRspDtos = this.psDZonemanagementRepo.getZoneDict(psCustomDictVo);
                break;
            }
            default: {
                throw new BizBaseException(PSErrorMsg.PS000001.getErrCode(), "\u5b57\u5178\u7f16\u7801\u65e0\u6548" + PSErrorMsg.PS000007.getErrMsg(), new Object[0]);
            }
        }
        return ps10000DetRspDtos;
    }

    private void createCusWhereSql(PsCustomDictVo psCustomDictVo) {
        List<PsDictQuqryVo> list = psCustomDictVo.getList();
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(" ");
        for (int i = 0; i < list.size(); ++i) {
            PsDictQuqryVo vo = (PsDictQuqryVo)BeanUtils.beanCopy((Object)list.get(i), PsDictQuqryVo.class);
            if (CollectionUtils.isEmpty(vo.getQryvalues())) continue;
            if (i == 0) {
                stringBuilder.append(vo.getQrycolum()).append(" ").append(this.createSqlWithIn(vo.getQryvalues()));
                continue;
            }
            stringBuilder.append(" and ").append(vo.getQrycolum()).append(" ").append(this.createSqlWithIn(vo.getQryvalues()));
        }
        psCustomDictVo.setCusSql(stringBuilder.toString());
    }

    private String createSqlWithIn(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder("in (");
        for (int j = 0; j < list.size(); ++j) {
            stringBuilder.append("'").append(list.get(j)).append("',");
        }
        stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

