/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.domain.util;

import cn.com.yusys.yusp.commons.util.NumberUtils;
import cn.com.yusys.yusp.commons.util.date.DateFormatEnum;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PSDateUtil {
    private static final Logger log = LoggerFactory.getLogger(PSDateUtil.class);

    public static boolean isSecondDateIsGreaterThanFirstDate(String firstDate, String secondDate) {
        boolean isGreater = false;
        if (DateUtils.getDaysByTwoDates((String)firstDate, (String)secondDate, (String)DateUtils.PATTERN_DATE_COMPACT) > 0) {
            isGreater = true;
        }
        return isGreater;
    }

    public static boolean isSecondDateIsEqualOrGreaterThanFirstDate(String firstDate, String secondDate) {
        boolean isGreater = false;
        if (DateUtils.getDaysByTwoDates((String)firstDate, (String)secondDate, (String)DateUtils.PATTERN_DATE_COMPACT) > 0) {
            isGreater = true;
        }
        return isGreater;
    }

    public static String getYesterdayDate() {
        String yestodayDate = "";
        try {
            String currentDate = DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT);
            yestodayDate = DateUtils.getYesterday((String)currentDate, (String)DateFormatEnum.DATE_COMPACT.getValue());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return yestodayDate;
    }

    public static String getPastDate(int amount) {
        String currentDate = DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT);
        return DateUtils.addDay((String)currentDate, (String)DateFormatEnum.DATE_COMPACT.getValue(), (int)amount);
    }

    public static String getPreviousMonthDay(String currentDate) {
        return DateUtils.addMonth((String)currentDate, (String)DateFormatEnum.DATE_COMPACT.getValue(), (int)-1);
    }

    public static String getPreviousMonth() {
        String currentDate = DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT);
        String previousMonthDay = PSDateUtil.getPreviousMonthDay(currentDate);
        return previousMonthDay.substring(0, 6);
    }

    public static String getMonthLastDate(String year, String month) {
        if (month.length() < 2) {
            month = "0" + month;
        }
        int totalDays = DateUtils.getMonthTotalDays((int)Integer.parseInt(year), (int)Integer.parseInt(month));
        return year + month + String.valueOf(totalDays);
    }

    public static String getDaysBetweenTwoDate(String startDate, String endDate) {
        return String.valueOf(DateUtils.getDaysByTwoDates((String)startDate, (String)endDate, (String)DateFormatEnum.DATE_COMPACT.getValue()) + 1);
    }

    public static String getCurrentDate() {
        return DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT);
    }

    public static String getCurrentTime() {
        return DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.TIME_COMPACT);
    }

    public static List<String> getWeekDay(int year) {
        ArrayList<String> dateList = new ArrayList<String>();
        SimpleDateFormat sid = new SimpleDateFormat("yyyyMMdd");
        GregorianCalendar calendar = new GregorianCalendar(year, 0, 1);
        int i = 1;
        while (calendar.get(1) < year + 1) {
            calendar.set(3, i++);
            calendar.set(7, 1);
            if (calendar.get(1) == year) {
                dateList.add(sid.format(calendar.getTime()));
            }
            calendar.set(7, 7);
            if (calendar.get(1) != year) continue;
            dateList.add(sid.format(calendar.getTime()));
        }
        return dateList;
    }

    public static void main(String[] args) {
        log.info(PSDateUtil.isSecondDateIsGreaterThanFirstDate("20221018", "20221019") + "");
        log.info(PSDateUtil.isSecondDateIsGreaterThanFirstDate("20221019", "20221018") + "");
        log.info(PSDateUtil.isSecondDateIsGreaterThanFirstDate("20221018", "20221018") + "");
        log.info(PSDateUtil.isSecondDateIsEqualOrGreaterThanFirstDate("20221019", "20221018") + "");
        log.info(PSDateUtil.isSecondDateIsEqualOrGreaterThanFirstDate("20221018", "20221019") + "");
        log.info(PSDateUtil.getYesterdayDate());
        log.info(PSDateUtil.getPastDate(-1));
        log.info(PSDateUtil.getPastDate(-15));
        BigDecimal a = NumberUtils.round((BigDecimal)NumberUtils.divide((BigDecimal)new BigDecimal("2"), (BigDecimal)new BigDecimal("3")), (int)4);
        log.info(a.toString());
        log.info(NumberUtils.sub((BigDecimal[])new BigDecimal[]{BigDecimal.ONE, a}).toString());
        log.info(PSDateUtil.getPreviousMonthDay("20200331"));
        log.info(PSDateUtil.getPreviousMonth());
        log.info(DateUtils.getMonthTotalDays((int)2020, (int)Integer.parseInt("02")) + "");
        log.info(DateUtils.getMonthTotalDays((int)2020, (int)Integer.parseInt("09")) + "");
        log.info(PSDateUtil.getMonthLastDate("2019", "02"));
        log.info(PSDateUtil.getMonthLastDate("2020", "02"));
        log.info(PSDateUtil.getMonthLastDate("2020", "09"));
        log.info(PSDateUtil.getDaysBetweenTwoDate("20221001", "20221002"));
        log.info(PSDateUtil.getCurrentTime());
    }
}

