/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.domain.util;

import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtil {
    private static final Logger log = LoggerFactory.getLogger(CommonUtil.class);
    private static final String LOCAL_USER = "user.home";

    public static String getPaymentDirection(String mbFlag, String dcFlag) {
        String direction = "";
        if ("1".equals(mbFlag)) {
            if ("1".equals(dcFlag)) {
                direction = "01";
            } else if ("2".equals(dcFlag)) {
                direction = "02";
            }
        } else if ("2".equals(mbFlag)) {
            if ("1".equals(dcFlag)) {
                direction = "02";
            } else if ("2".equals(dcFlag)) {
                direction = "01";
            }
        }
        return direction;
    }

    public static String getAbsolutePath(String fiilPath) {
        return System.getProperty(LOCAL_USER).concat(fiilPath);
    }

    public static <T> List<List<T>> split(List<T> resList, int subListLength) {
        if (CollectionUtils.isEmpty(resList) || subListLength <= 0) {
            return Lists.newArrayList();
        }
        ArrayList ret = Lists.newArrayList();
        int size = resList.size();
        if (size <= subListLength) {
            ret.add(resList);
        } else {
            int pre = size / subListLength;
            int last = size % subListLength;
            for (int i = 0; i < pre; ++i) {
                ArrayList itemList = Lists.newArrayList();
                for (int j = 0; j < subListLength; ++j) {
                    itemList.add(resList.get(i * subListLength + j));
                }
                ret.add(itemList);
            }
            if (last > 0) {
                ArrayList itemList = Lists.newArrayList();
                for (int i = 0; i < last; ++i) {
                    itemList.add(resList.get(pre * subListLength + i));
                }
                ret.add(itemList);
            }
        }
        return ret;
    }

    public static String getLinuxLocalIp() {
        String ip = "";
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                String name = intf.getName();
                if (name.contains("docker") || name.contains("lo")) continue;
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    String ipaddress;
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || (ipaddress = inetAddress.getHostAddress()).contains("::") || ipaddress.contains("0:0:") || ipaddress.contains("fe80")) continue;
                    ip = ipaddress;
                }
            }
        }
        catch (SocketException ex) {
            log.error("\u83b7\u53d6ip\u5730\u5740\u5f02\u5e38");
            ip = "127.0.0.1";
            ex.printStackTrace();
        }
        return ip;
    }
}

