/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.domain.service;

import cn.com.yusys.yusp.commons.sequence.util.SequenceUtils;
import cn.com.yusys.yusp.commons.util.date.DateFormatEnum;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDMaillistRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDMessagetemplateRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsMMessagetobesentRepo;
import cn.com.yusys.yusp.pay.position.domain.service.SMS001DomainService;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDMaillistVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDMessagetemplateVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsMMessagetobesentVo;
import cn.com.yusys.yusp.pay.position.domain.vo.esb.SMS001ReqBody;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PsSMSDomainService {
    private static final Logger log = LoggerFactory.getLogger(PsSMSDomainService.class);
    @Autowired
    private PsMMessagetobesentRepo psMMessagetobesentRepo;
    @Autowired
    private PsDMessagetemplateRepo psDMessagetemplateRepo;
    @Autowired
    private PsDMaillistRepo psDMaillistRepo;
    @Autowired
    private SMS001DomainService sms001DomainService;
    public static final String VC_MSG_CODE = "MSG000000";
    public static final int VERIFICATION_CODE_NUM = 4;
    private static final String SMS001_MSGTYPE = "A01";
    private static final String SMS001_CDNM = "01101";

    public boolean sendSms(String msgcode, Map<String, String> params, String mobilephone) {
        String content = this.getContent(msgcode, params);
        return this.sendSms(content, mobilephone);
    }

    public boolean sendSms(String content, String mobilephone) {
        ArrayList<SMS001ReqBody> sms001ReqBodyList = new ArrayList<SMS001ReqBody>();
        SMS001ReqBody sms001ReqBody = new SMS001ReqBody();
        sms001ReqBody.setContent(content);
        sms001ReqBody.setDestNO(mobilephone);
        sms001ReqBody.setMsgType(SMS001_MSGTYPE);
        sms001ReqBody.setExpectedTime(DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.TIME));
        sms001ReqBody.setExpiresTime(DateUtils.formatDate((Date)DateUtils.add((Date)DateUtils.getCurrDate(), (int)12, (int)1), (String)DateFormatEnum.TIME.getValue()));
        sms001ReqBody.setCardnm(SMS001_CDNM);
        sms001ReqBody.setSender("admin");
        sms001ReqBodyList.add(sms001ReqBody);
        try {
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return false;
        }
    }

    public boolean sendSmsByTable(String msgcode, Map<String, String> params, String mobilephone) {
        String content = this.getContent(msgcode, params);
        PsMMessagetobesentVo psMMessagetobesentVo = new PsMMessagetobesentVo();
        psMMessagetobesentVo.setAppid("PS");
        psMMessagetobesentVo.setSysid("PS");
        psMMessagetobesentVo.setLinkmobile(mobilephone);
        psMMessagetobesentVo.setMsgcode(msgcode);
        psMMessagetobesentVo.setMsgcontent(content);
        psMMessagetobesentVo.setMsgtype("1");
        psMMessagetobesentVo.setStatus("0");
        psMMessagetobesentVo.setWorkdate(DateUtils.formatDate((String)DateUtils.PATTERN_DATE_COMPACT));
        psMMessagetobesentVo.setWorkseqid(SequenceUtils.getSequence((String)"msgid"));
        psMMessagetobesentVo.setCreatetime(DateUtils.getCurrDateTimeStr());
        this.psMMessagetobesentRepo.doInsert(psMMessagetobesentVo);
        return true;
    }

    public boolean sendSmsByGroup(String msgcode, Map<String, String> params, String groupcode) {
        if (StringUtils.isBlank((CharSequence)groupcode)) {
            return false;
        }
        PsDMaillistVo psDMaillistVo = new PsDMaillistVo();
        psDMaillistVo.setGroupcode(groupcode);
        List<PsDMaillistVo> maillistPoList = this.psDMaillistRepo.doQueryList(psDMaillistVo);
        ArrayList<PsMMessagetobesentVo> psMMessagetobesentVoList = new ArrayList<PsMMessagetobesentVo>();
        for (PsDMaillistVo ps : maillistPoList) {
            String content = this.getContent(msgcode, params);
            PsMMessagetobesentVo psMMessagetobesentVo = new PsMMessagetobesentVo();
            psMMessagetobesentVo.setAppid("PS");
            psMMessagetobesentVo.setSysid("PS");
            psMMessagetobesentVo.setLinkmobile(ps.getLinkmobile());
            psMMessagetobesentVo.setMsgcode(msgcode);
            psMMessagetobesentVo.setMsgcontent(content);
            psMMessagetobesentVo.setMsgtype("1");
            psMMessagetobesentVo.setStatus("0");
            psMMessagetobesentVo.setWorkdate(DateUtils.formatDate((String)DateUtils.PATTERN_DATE_COMPACT));
            psMMessagetobesentVo.setWorkseqid(SequenceUtils.getSequence((String)"msgid"));
            psMMessagetobesentVo.setCreatetime(DateUtils.getCurrDateTimeStr());
            psMMessagetobesentVoList.add(psMMessagetobesentVo);
        }
        this.psMMessagetobesentRepo.doInsertAll(psMMessagetobesentVoList);
        return true;
    }

    public String sendSmsVerificationCode(String mobilephone) {
        HashMap<String, String> params = new HashMap<String, String>();
        String code = String.valueOf(this.getVerificationCode());
        params.put("VerificationCode", code);
        return this.sendSms(VC_MSG_CODE, params, mobilephone) ? code : "";
    }

    public long getVerificationCode(int num) {
        return (long)((new SecureRandom().nextDouble() * 9.0 + 1.0) * Math.pow(10.0, num - 1));
    }

    public long getVerificationCode() {
        return this.getVerificationCode(4);
    }

    private String getContent(String msgcode, Map<String, String> params) {
        PsDMessagetemplateVo psDMessagetemplateVo = this.psDMessagetemplateRepo.getMessagetemplate(msgcode);
        String templateContent = psDMessagetemplateVo.getMsgcontent();
        for (String key : params.keySet()) {
            templateContent = templateContent.replaceAll("#" + key, params.get(key));
        }
        return templateContent;
    }
}

