/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.domain.repo;

import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.pay.position.dao.mapper.PsDBranchadmMapper;
import cn.com.yusys.yusp.pay.position.dao.po.PsCustomDictPo;
import cn.com.yusys.yusp.pay.position.dao.po.PsDBranchadmPo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsCustomDictVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDBranchadmQueryVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDBranchadmTreeVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDBranchadmVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PsDBranchadmRepo {
    @Autowired
    private PsDBranchadmMapper psDBranchadmMapper;

    public List<PsDBranchadmVo> getOrgInfoByOrgZoneBrno(List<String> orgTypeList, List<String> orgZoneList, List<String> brnoList) {
        List psDBranchadmPos = this.psDBranchadmMapper.getOrgInfoByOrgZoneBrno(orgTypeList, orgZoneList, brnoList);
        return psDBranchadmPos.stream().map(po -> (PsDBranchadmVo)BeanUtils.beanCopy((Object)po, PsDBranchadmVo.class)).collect(Collectors.toList());
    }

    public IPage<PsDBranchadmVo> getBranchList(Long pageNum, Long size, List<String> brNoList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (ObjectUtils.isNotEmpty(brNoList)) {
            queryWrapper.in((Object)"brno", brNoList);
        }
        queryWrapper.orderByAsc((Object)"brno");
        IPage page = this.psDBranchadmMapper.selectPage((IPage)new Page(pageNum.longValue(), size.longValue()), (Wrapper)queryWrapper);
        return page.convert(po -> (PsDBranchadmVo)BeanUtils.beanCopy((Object)po, PsDBranchadmVo.class));
    }

    public PsDBranchadmVo getBranchInfoByBrNo(String brNo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((String)brNo)) {
            queryWrapper.eq((Object)"brno", (Object)brNo);
        }
        PsDBranchadmPo po = (PsDBranchadmPo)this.psDBranchadmMapper.selectOne((Wrapper)queryWrapper);
        return (PsDBranchadmVo)BeanUtils.beanCopy((Object)po, PsDBranchadmVo.class);
    }

    public boolean isTopBranch(String brNo) {
        boolean isTopBranch = false;
        PsDBranchadmVo vo = this.getBranchInfoByBrNo(brNo);
        if (ObjectUtils.isNotEmpty((Object)vo) && "11".equals(vo.getOrgtype())) {
            isTopBranch = true;
        }
        return isTopBranch;
    }

    public IPage<PsDBranchadmVo> queryPage(PsDBranchadmQueryVo queryVo) {
        PsDBranchadmPo psDBranchadmPo = (PsDBranchadmPo)BeanUtils.beanCopy((Object)((Object)queryVo), PsDBranchadmPo.class);
        QueryWrapper queryWrapper = new QueryWrapper((Object)psDBranchadmPo);
        IPage page = this.psDBranchadmMapper.selectPage((IPage)new Page(queryVo.getPage().longValue(), queryVo.getSize().longValue()), (Wrapper)queryWrapper);
        return page.convert(po -> (PsDBranchadmVo)BeanUtils.beanCopy((Object)po, PsDBranchadmVo.class));
    }

    public PsDBranchadmVo getById(String id) {
        PsDBranchadmPo psDBranchadmPo = (PsDBranchadmPo)this.psDBranchadmMapper.selectById((Serializable)((Object)id));
        PsDBranchadmVo psDBranchadmVo = (PsDBranchadmVo)BeanUtils.beanCopy((Object)psDBranchadmPo, PsDBranchadmVo.class);
        return psDBranchadmVo;
    }

    public void save(PsDBranchadmVo psDBranchadmVo) {
        this.psDBranchadmMapper.insert(BeanUtils.beanCopy((Object)psDBranchadmVo, PsDBranchadmPo.class));
    }

    public void updateById(PsDBranchadmVo psDBranchadmVo) {
        this.psDBranchadmMapper.updateById(BeanUtils.beanCopy((Object)psDBranchadmVo, PsDBranchadmPo.class));
    }

    public void removeByIds(List<String> ids) {
        this.psDBranchadmMapper.deleteBatchIds(ids);
    }

    public IPage<PsCustomDictVo> getBranchadmDict(PsCustomDictVo psCustomDictVo) {
        PsCustomDictPo psCustomDictPo = (PsCustomDictPo)BeanUtils.beanCopy((Object)((Object)psCustomDictVo), PsCustomDictPo.class);
        IPage page = this.psDBranchadmMapper.getBranchadmDict(new Page(psCustomDictVo.getPage().longValue(), psCustomDictVo.getSize().longValue()), psCustomDictPo);
        return page.convert(po -> (PsCustomDictVo)((Object)((Object)BeanUtils.beanCopy((Object)po, PsCustomDictVo.class))));
    }

    public List<String> getBrnoTreeInfoByBrno(String brno) {
        List psDBranchadmPos = new ArrayList(13);
        String fatherOrgType = this.getBranchInfoByBrNo(brno).getOrgtype();
        if ("51".equals(fatherOrgType)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.select(new String[]{"brno", "brname", "superbrno"});
            queryWrapper.eq((Object)"clearbrno", (Object)brno);
            queryWrapper.notIn((Object)"orgtype ", new Object[]{"40", "41", "60"});
            psDBranchadmPos = this.psDBranchadmMapper.selectList((Wrapper)queryWrapper);
            return psDBranchadmPos.stream().map(PsDBranchadmPo::getBrno).collect(Collectors.toList());
        }
        if ("01101".equals(brno)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.select(new String[]{"brno", "brname", "superbrno"});
            psDBranchadmPos = this.psDBranchadmMapper.selectList((Wrapper)queryWrapper);
            return psDBranchadmPos.stream().map(PsDBranchadmPo::getBrno).collect(Collectors.toList());
        }
        psDBranchadmPos = this.psDBranchadmMapper.getBrnoTreeInfoByBrno(brno);
        psDBranchadmPos.addAll(this.psDBranchadmMapper.getBrnoTownTreeInfoByBrno(brno));
        return psDBranchadmPos.stream().map(PsDBranchadmPo::getBrno).collect(Collectors.toList());
    }

    public List<PsDBranchadmTreeVo> getOrgTreeInfoByOrgZoneBrno(List<String> orgTypeList, List<String> orgZoneList, List<String> brnoList) {
        return this.psDBranchadmMapper.getOrgTreeInfoByOrgZoneBrno(orgTypeList, orgZoneList, brnoList).stream().map(vo -> (PsDBranchadmTreeVo)BeanUtils.beanCopy((Object)vo, PsDBranchadmTreeVo.class)).collect(Collectors.toList());
    }

    private List<PsDBranchadmTreeVo> getChildrens(PsDBranchadmTreeVo par, List<PsDBranchadmTreeVo> all) {
        List<PsDBranchadmTreeVo> psDBranchadmTreeVos = all.stream().filter(item -> item.getSuperbrno().equals(par.getBrno()) && !item.getBrno().equals(par.getBrno())).map(treeVo -> {
            treeVo.setSonlist(this.getChildrens((PsDBranchadmTreeVo)treeVo, all));
            return treeVo;
        }).collect(Collectors.toList());
        return psDBranchadmTreeVos;
    }

    public void deleteAll() {
        this.psDBranchadmMapper.deleteAll();
    }

    public void insertList(List<PsDBranchadmVo> psDBranchadmVos) {
        this.psDBranchadmMapper.insertList(psDBranchadmVos.stream().map(vo -> (PsDBranchadmPo)BeanUtils.beanCopy((Object)vo, PsDBranchadmPo.class)).collect(Collectors.toList()));
    }

    public int juageSuperBrno(String fatherBrno, String sonBrno, String orgType) {
        if ("51".equals(orgType)) {
            return this.psDBranchadmMapper.juageSuperBrnoSecial(fatherBrno, sonBrno);
        }
        return this.psDBranchadmMapper.juageSuperBrno(fatherBrno, sonBrno) + this.psDBranchadmMapper.juageSuperBrnoTown(fatherBrno, sonBrno);
    }

    public List<PsDBranchadmVo> getBranchList93() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"orgtype", (Object)"51");
        queryWrapper.orderByAsc((Object)"brno");
        List poList = this.psDBranchadmMapper.selectList((Wrapper)queryWrapper);
        List voList = CollectionUtils.addToList((Collection[])new Collection[]{BeanUtils.beansCopy((Collection)poList, PsDBranchadmVo.class)});
        return voList;
    }

    public List<String> getBranchNoList93() {
        ArrayList<String> list = new ArrayList<String>();
        List<PsDBranchadmVo> voList = this.getBranchList93();
        for (PsDBranchadmVo vo : voList) {
            list.add(vo.getBrno());
        }
        return list;
    }

    public boolean isBranchCanOperate(String brNo) {
        boolean isCan = false;
        PsDBranchadmVo vo = this.getBranchInfoByBrNo(brNo);
        if (ObjectUtils.isNotEmpty((Object)vo) && ("11".equals(vo.getOrgtype()) || "41".equals(vo.getOrgtype()) || "51".equals(vo.getOrgtype()))) {
            isCan = true;
        }
        return isCan;
    }
}

