/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.domain.service;

import cn.com.yusys.yusp.commons.sequence.util.SequenceUtils;
import cn.com.yusys.yusp.commons.util.date.DateFormatEnum;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.pay.position.domain.util.PSEsbConfigurationMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.esb.EsbReqMsgVo;
import cn.com.yusys.yusp.pay.position.domain.vo.esb.SMS001ReqBody;
import cn.com.yusys.yusp.pay.position.domain.vo.esb.SMS001ReqHead;
import cn.com.yusys.yusp.pay.position.domain.vo.esb.SMS001ReqVo;
import cn.com.yusys.yusp.payment.common.base.dto.ReqCommInfo;
import com.alibaba.fastjson.JSON;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import net.sf.cglib.beans.BeanMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class SMS001DomainService {
    private static final Logger log = LoggerFactory.getLogger(SMS001DomainService.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private PSEsbConfigurationMsg psEsbConfigurationMsg;

    public ResponseEntity<String> sms001(List<SMS001ReqBody> body) throws UnknownHostException {
        ReqCommInfo reqCommInfo = this.createSmsReqCommInfo(body);
        log.info(String.format("SMS001\u751f\u6210\u62a5\u6587\u6210\u529f%s", JSON.toJSONString((Object)reqCommInfo)));
        String url = this.psEsbConfigurationMsg.getUrl();
        log.info(String.format("SMS001\u53d1\u8d77\u8bf7\u6c42\uff1a\u8bf7\u6c42\u8def\u5f84%s ", url));
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)reqCommInfo, String.class, new Object[0]);
        log.info(String.format("SMS001\u5e94\u7b54\u62a5\u6587%s ", JSON.toJSONString((Object)responseEntity)));
        return responseEntity;
    }

    private ReqCommInfo createSmsReqCommInfo(List<SMS001ReqBody> body) {
        log.info("SMS001-191\u751f\u6210\u62a5\u6587\u5f00\u59cb---");
        ReqCommInfo reqCommInfo = new ReqCommInfo();
        reqCommInfo.setSysid("FXPS");
        reqCommInfo.setAppid("FXPS");
        reqCommInfo.setHostcommid("FXPS");
        EsbReqMsgVo esbReqMsgVo = new EsbReqMsgVo();
        esbReqMsgVo.setMsgCd("SMS.000000010.01");
        esbReqMsgVo.setSeqNb(SequenceUtils.getSequence((String)"esbseqid"));
        log.info(String.format("seqNb\uff1a%s", esbReqMsgVo.getSeqNb()));
        esbReqMsgVo.setSndAppCd(this.psEsbConfigurationMsg.getAppcd());
        esbReqMsgVo.setSndDt(DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT));
        esbReqMsgVo.setSndTm(DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.TIME).replace(':', '.'));
        esbReqMsgVo.setCallTyp("SYN");
        esbReqMsgVo.setRcvAppCd("SMS");
        SMS001ReqHead sms001ReqHead = new SMS001ReqHead();
        sms001ReqHead.setFuncode("SMS001");
        sms001ReqHead.setApplication(this.psEsbConfigurationMsg.getAppcd());
        sms001ReqHead.setServiceSN(String.valueOf(System.currentTimeMillis()));
        sms001ReqHead.setServiceTime(DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATETIME_COMPACT));
        sms001ReqHead.setVersion("2.0");
        SMS001ReqVo sms001ReqVo = new SMS001ReqVo();
        sms001ReqVo.setMsg(esbReqMsgVo);
        sms001ReqVo.setHead(sms001ReqHead);
        sms001ReqVo.setBody(body);
        BeanMap sender = BeanMap.create((Object)sms001ReqVo);
        reqCommInfo.setSender((Map)sender);
        return reqCommInfo;
    }
}

