/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.domain.service;

import cn.com.yusys.yusp.commons.sequence.util.SequenceUtils;
import cn.com.yusys.yusp.commons.util.date.DateFormatEnum;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.pay.position.domain.repo.PsBPostpredbookRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDCorpaccbookRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsMPaytranjnlRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsMPostcaljnlRepo;
import cn.com.yusys.yusp.pay.position.domain.service.PsCorpWarnJnlDomainService;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDCorpaccbookVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsMPaytranjnlVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsMPostcaljnlVo;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class PsMPostcaljnlDomainService {
    @Autowired
    private PsMPostcaljnlRepo psMPostcaljnlRepo;
    @Autowired
    private PsDCorpaccbookRepo psDCorpaccbookRepo;
    @Autowired
    private PsBPostpredbookRepo psBPostpredbookRepo;
    @Autowired
    private PsMPaytranjnlRepo psMPaytranjnlRepo;
    @Autowired
    private PsCorpWarnJnlDomainService psCorpWarnJnlDomainService;
    private static final Logger log = LoggerFactory.getLogger(PsMPostcaljnlDomainService.class);

    @Async
    public void budGet(BigDecimal tagvale) {
        log.info(String.format("%s \u6267\u884c\u5f02\u6b65\u5934\u5bf8\u5321\u7b97", DateUtils.getCurrDateTimeStr()));
        PsDCorpaccbookVo psDCorpaccbookVo = new PsDCorpaccbookVo();
        psDCorpaccbookVo.setClearbrno("01101");
        psDCorpaccbookVo.setStatus("1");
        List<PsDCorpaccbookVo> accList = this.psDCorpaccbookRepo.getAllByBean(psDCorpaccbookVo);
        for (PsDCorpaccbookVo pscorpAccVo : accList) {
            if ("01".equals(pscorpAccVo.getPostype())) continue;
            PsMPostcaljnlVo psMPostcaljnlVo = new PsMPostcaljnlVo();
            psMPostcaljnlVo.setSysid("PS");
            psMPostcaljnlVo.setAppid("PS");
            psMPostcaljnlVo.setPostaccno(pscorpAccVo.getPostaccno());
            psMPostcaljnlVo.setPostname(pscorpAccVo.getPosname());
            psMPostcaljnlVo.setBrno(pscorpAccVo.getClearbrno());
            psMPostcaljnlVo.setCurcode(pscorpAccVo.getCurcode());
            psMPostcaljnlVo.setWorkdate(DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT));
            LocalTime time = LocalTime.now();
            DateTimeFormatter formater = DateTimeFormatter.ofPattern("HHmmss");
            psMPostcaljnlVo.setWorktime(time.format(formater));
            psMPostcaljnlVo.setSeqno(SequenceUtils.getSequence((String)"bankseqno"));
            psMPostcaljnlVo.setTagprovamt(tagvale);
            psMPostcaljnlVo.setLastprovamt(pscorpAccVo.getBanklastbal());
            psMPostcaljnlVo.setProvamt(pscorpAccVo.getBanktodaybal());
            PsMPaytranjnlVo psMPaytranjnlVo = new PsMPaytranjnlVo();
            psMPaytranjnlVo.setPredflag("0");
            psMPaytranjnlVo.setWorkdate(DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT));
            psMPaytranjnlVo.setBusitype("05");
            psMPaytranjnlVo.setChnlcode("HVPS");
            BigDecimal unHapSum = this.psMPaytranjnlRepo.queryCalSum(psMPaytranjnlVo);
            if ("02".equals(pscorpAccVo.getPostype())) {
                Map<String, BigDecimal> myMap = this.psBPostpredbookRepo.postCalQuery(psMPostcaljnlVo.getWorkdate());
                psMPostcaljnlVo.setPredhapamt(myMap.get("jlrPost").subtract(myMap.get("jlrWrto")));
                psMPostcaljnlVo.setPredunhapamt(myMap.get("jlrWrto"));
                psMPostcaljnlVo.setUnpredamt(myMap.get("jlrUnhap").add(unHapSum));
            } else {
                psMPostcaljnlVo.setPredhapamt(new BigDecimal("0"));
                psMPostcaljnlVo.setPredunhapamt(new BigDecimal("0"));
                psMPostcaljnlVo.setUnpredamt(unHapSum);
            }
            psMPostcaljnlVo.setTotalnetamt(psMPostcaljnlVo.getPredhapamt().add(psMPostcaljnlVo.getPredunhapamt()).add(psMPostcaljnlVo.getUnpredamt()));
            psMPostcaljnlVo.setTodayamtgap(psMPostcaljnlVo.getLastprovamt().add(psMPostcaljnlVo.getTotalnetamt()).subtract(psMPostcaljnlVo.getTagprovamt()));
            Map<String, BigDecimal> netMap = this.psMPaytranjnlRepo.getnetSum(psMPaytranjnlVo);
            psMPostcaljnlVo.setActualcramt(netMap.get("lrUnHapSum"));
            psMPostcaljnlVo.setActualdramt(netMap.get("lcUnHapSum"));
            psMPostcaljnlVo.setActualntamt(psMPostcaljnlVo.getActualcramt().subtract(psMPostcaljnlVo.getActualdramt()));
            psMPostcaljnlVo.setPostbal(psMPostcaljnlVo.getLastprovamt().add(psMPostcaljnlVo.getActualntamt()).subtract(psMPostcaljnlVo.getTagprovamt()));
            this.psMPostcaljnlRepo.save(psMPostcaljnlVo);
            this.psCorpWarnJnlDomainService.invokeCorpWarnJnlHandlerWithCalculate(psMPostcaljnlVo);
        }
        log.info("\u5f02\u6b65\u5321\u7b97\u4efb\u52a1\u6267\u884c\u7ed3\u675f");
    }
}

