/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.domain.service;

import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.commons.util.date.DateFormatEnum;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.commons.util.io.FileUtils;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDBranchadmRepo;
import cn.com.yusys.yusp.pay.position.domain.service.SVS310DomainService;
import cn.com.yusys.yusp.pay.position.domain.util.CommonUtil;
import cn.com.yusys.yusp.pay.position.domain.util.PSEsbConfigurationMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDBranchadmTreeVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDBranchadmVo;
import cn.com.yusys.yusp.pay.position.domain.vo.esb.CommonRspVo;
import cn.com.yusys.yusp.pay.position.domain.vo.esb.SVS310RspVo;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PsDBranchadmDomainService {
    private static final Logger log = LoggerFactory.getLogger(PsDBranchadmDomainService.class);
    @Autowired
    private PsDBranchadmRepo psDBranchadmRepo;
    @Autowired
    private SVS310DomainService svs310DomainService;
    @Autowired
    private PSEsbConfigurationMsg psEsbConfigurationMsg;

    public List<PsDBranchadmTreeVo> getOrgTreeInfoByOrgZoneBrno(List<String> orgtypeList, List<String> zonecodeList, List<String> brnoList) {
        List<PsDBranchadmTreeVo> infoAll = this.psDBranchadmRepo.getOrgTreeInfoByOrgZoneBrno(null, null, null);
        List<PsDBranchadmTreeVo> infoParam = this.psDBranchadmRepo.getOrgTreeInfoByOrgZoneBrno(orgtypeList, zonecodeList, brnoList);
        if (CollectionUtils.nonEmpty(infoParam)) {
            return infoParam.stream().map(vo -> {
                vo.setSonlist(this.getSon((PsDBranchadmTreeVo)vo, infoAll));
                return vo;
            }).collect(Collectors.toList());
        }
        return infoAll.stream().filter(vo -> StringUtils.isBlank((CharSequence)vo.getSuperbrno())).map(vo -> {
            vo.setSonlist(this.getSon((PsDBranchadmTreeVo)vo, infoAll));
            return vo;
        }).collect(Collectors.toList());
    }

    private List<PsDBranchadmTreeVo> getSon(PsDBranchadmTreeVo vo, List<PsDBranchadmTreeVo> infoAll) {
        List<PsDBranchadmTreeVo> psDBranchadmTreeVos = infoAll.stream().filter(item -> item.getSuperbrno().equals(vo.getBrno())).map(treeVo -> {
            treeVo.setSonlist(this.getSon((PsDBranchadmTreeVo)treeVo, infoAll));
            return treeVo;
        }).collect(Collectors.toList());
        return psDBranchadmTreeVos;
    }

    public void TaskSynchronousCoreBranchadm() throws IOException {
        log.info("PS10201\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u6267\u884c");
        String files = this.sendReqToCore();
        if (StringUtils.isBlank((CharSequence)files)) {
            log.info("\u672a\u83b7\u53d6\u5230\u6838\u5fc3\u673a\u6784\u6570\u636e");
            return;
        }
        List strings = FileUtils.readAllLines((String)files, (String)"GBK");
        Assert.notEmpty((Collection)strings, (String)"\u6838\u5fc3\u8fd4\u56de\u6570\u636e\u6570\u636e\u4e3a\u7a7a");
        List<PsDBranchadmVo> psDBranchadmVos = this.proceCoreBranchadm(strings);
        if (CollectionUtils.nonEmpty(psDBranchadmVos)) {
            this.psDBranchadmRepo.deleteAll();
            this.psDBranchadmRepo.insertList(psDBranchadmVos);
        }
    }

    private String sendReqToCore() throws IOException {
        String filePath = CommonUtil.getAbsolutePath(this.psEsbConfigurationMsg.getFtpFile()).concat("/").concat(DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT)) + "/SVS310";
        Files.createDirectories(Paths.get(filePath, new String[0]), new FileAttribute[0]);
        String filename = DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATETIME_COMPACT) + ".txt";
        log.info(String.format("SVS310-502\u5f85\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f%s", filePath + filename));
        String corpFilePath = DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT).concat("/SVS310");
        ResponseEntity<String> responseEntity = this.svs310DomainService.svs310502(corpFilePath, filename);
        String body = (String)responseEntity.getBody();
        if (HttpStatus.OK != responseEntity.getStatusCode() || StringUtils.isBlank((CharSequence)body)) {
            log.info(String.format("SVS310-\u8bf7\u6c42\u6838\u5fc3\u901a\u4fe1\u5931\u8d25", new Object[0]));
            return "";
        }
        CommonRspVo commonRspVo = Optional.ofNullable(JSON.parseObject((String)body, (TypeReference)new TypeReference<CommonRspVo<SVS310RspVo>>(){}, (Feature[])new Feature[0])).orElse(new CommonRspVo());
        if ("000000".equals(((SVS310RspVo)commonRspVo.getRecv()).getRetCd())) {
            return filePath.concat("/" + filename);
        }
        log.info(String.format("SVS310-502ESB\u8fd4\u56de\u5931\u8d25-\u72b6\u6001%s", ((SVS310RspVo)commonRspVo.getRecv()).getRetCd()));
        return "";
    }

    private List<PsDBranchadmVo> proceCoreBranchadm(List<String> strings) {
        ArrayList<PsDBranchadmVo> psDBranchadmVos = new ArrayList<PsDBranchadmVo>(strings.size());
        strings.stream().forEach(s -> {
            String[] split = s.split(this.psEsbConfigurationMsg.getEscapePlit());
            PsDBranchadmVo vo = new PsDBranchadmVo();
            vo.setBrno(split[0].trim());
            vo.setOrgtype(split[3].trim());
            vo.setBrname(split[29].trim());
            vo.setBrnames(split[1].trim());
            vo.setSuperbrno(split[9].trim());
            vo.setClearbrno(split[10].trim());
            vo.setBraddress(split[30].trim());
            vo.setCreator("taskjob");
            vo.setCreatetime(DateUtils.getCurrDateTimeStr());
            psDBranchadmVos.add(vo);
        });
        return psDBranchadmVos;
    }

    public Boolean juageSuperBrno(String fatherBrno, String sonBrno) {
        if ("01101".equals(fatherBrno)) {
            return true;
        }
        String fatherOrgType = this.psDBranchadmRepo.getBranchInfoByBrNo(fatherBrno).getOrgtype();
        int num = this.psDBranchadmRepo.juageSuperBrno(fatherBrno, sonBrno, fatherOrgType);
        return num >= 1;
    }
}

