/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.service;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.pay.position.application.dto.ps09001.Ps09001ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps09001.Ps09001RspDtlDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps09001.Ps09001RspDto;
import cn.com.yusys.yusp.pay.position.dao.po.PsBPostpredbookPo;
import cn.com.yusys.yusp.pay.position.dao.po.PsMWrtoffinlPo;
import cn.com.yusys.yusp.pay.position.domain.entity.PsBranchAccountDo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsBPostpredbookRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDBranchadmRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsMWrtoffinlRepo;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.PsBPostpredbookQueryVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsMWrtoffinlVo;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestHead;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PS09001Service {
    private static final Logger log = LoggerFactory.getLogger(PS09001Service.class);
    @Autowired
    private PsDBranchadmRepo psDBranchadmRepo;
    @Autowired
    private PsBPostpredbookRepo psBPostpredbookRepo;
    @Autowired
    private PsMWrtoffinlRepo psMWrtoffinlRepo;

    public YuinResultDto<Ps09001RspDto> ps09001(YuinRequestDto<Ps09001ReqDto> yuinRequestDto) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        YuinRequestHead header = yuinRequestDto.getSysHead();
        Ps09001ReqDto ps09001ReqDto = (Ps09001ReqDto)yuinRequestDto.getBody();
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode("200");
        head.setResponseMsg("\u901a\u8baf\u6210\u529f");
        yuinResultDto.setHead(head);
        String headerBrNo = header.getBrno();
        String brType = ps09001ReqDto.getBrType();
        String brNo = ps09001ReqDto.getBrNo();
        PsBranchAccountDo branchAccountDo = new PsBranchAccountDo();
        branchAccountDo.checkBrTypeValue(brType);
        List<String> queryBrNoList = new ArrayList<String>();
        if ("01".equals(brType)) {
            queryBrNoList.add(headerBrNo);
        } else if ("02".equals(brType)) {
            queryBrNoList = this.psDBranchadmRepo.getBrnoTreeInfoByBrno(headerBrNo);
        } else if ("03".equals(brType)) {
            if (StringUtils.isBlank((String)brNo)) {
                throw new BizBaseException(PSErrorMsg.PS000008.getErrCode(), "\u673a\u6784\u53f7" + PSErrorMsg.PS000008.getErrMsg(), new Object[0]);
            }
            queryBrNoList.add(brNo);
        }
        boolean isTopBranch = this.psDBranchadmRepo.isTopBranch(headerBrNo);
        if (isTopBranch) {
            PsBPostpredbookQueryVo psBPostpredbookQueryVo = new PsBPostpredbookQueryVo();
            psBPostpredbookQueryVo.setPage(Long.valueOf(Long.parseLong(String.valueOf(header.getPageNum()))));
            psBPostpredbookQueryVo.setSize(Long.valueOf(Long.parseLong(String.valueOf(header.getPageSize()))));
            psBPostpredbookQueryVo.setStartdate(ps09001ReqDto.getStartDate());
            psBPostpredbookQueryVo.setEnddate(ps09001ReqDto.getEndDate());
            IPage pageObj = this.psBPostpredbookRepo.queryPage(psBPostpredbookQueryVo);
            ArrayList<Ps09001RspDtlDto> dtlDtos = new ArrayList<Ps09001RspDtlDto>();
            for (PsBPostpredbookPo psBPostpredbookPo : pageObj.getRecords()) {
                Ps09001RspDtlDto ps09001RspDtlDto = new Ps09001RspDtlDto();
                ps09001RspDtlDto.setStartDate(ps09001ReqDto.getStartDate());
                ps09001RspDtlDto.setEndDate(ps09001ReqDto.getEndDate());
                ps09001RspDtlDto.setTellerNo("");
                ps09001RspDtlDto.setAccNo("");
                ps09001RspDtlDto.setAccName("");
                ps09001RspDtlDto.setBrNo(psBPostpredbookPo.getBrno());
                ps09001RspDtlDto.setPredAmt(psBPostpredbookPo.getAmtAll());
                PsMWrtoffinlVo psMWrtoffinlVo = new PsMWrtoffinlVo();
                psMWrtoffinlVo.setBrno(psBPostpredbookPo.getBrno());
                psMWrtoffinlVo.setStartdate(ps09001ReqDto.getStartDate());
                psMWrtoffinlVo.setEnddate(ps09001ReqDto.getEndDate());
                List byPredNo = this.psMWrtoffinlRepo.getByPredNo(psMWrtoffinlVo);
                if (byPredNo.size() == 0) {
                    ps09001RspDtlDto.setAmt("0");
                    ps09001RspDtlDto.setPredDeviRate("0");
                    ps09001RspDtlDto.setDeviAmt("0");
                    dtlDtos.add(ps09001RspDtlDto);
                    continue;
                }
                BigDecimal wrto_amt = ((PsMWrtoffinlPo)byPredNo.get(0)).getWrtoffamtAll();
                ps09001RspDtlDto.setAmt(wrto_amt.toString());
                ps09001RspDtlDto.setPredDeviRate(String.valueOf(wrto_amt.divide(new BigDecimal(ps09001RspDtlDto.getPredAmt()), 2, 4)));
                ps09001RspDtlDto.setDeviAmt(String.valueOf(wrto_amt.subtract(new BigDecimal(ps09001RspDtlDto.getPredAmt()))));
                dtlDtos.add(ps09001RspDtlDto);
            }
            Ps09001RspDto ps09001RspDto = new Ps09001RspDto("1", head.getResponseCode(), head.getResponseMsg());
            head.setTotalSize(pageObj.getTotal());
            ps09001RspDto.setList(dtlDtos);
            yuinResultDto.setBody((Object)ps09001RspDto);
        } else {
            PsBPostpredbookQueryVo psBPostpredbookQueryVo = new PsBPostpredbookQueryVo();
            psBPostpredbookQueryVo.setPage(Long.valueOf(Long.parseLong(String.valueOf(header.getPageNum()))));
            psBPostpredbookQueryVo.setSize(Long.valueOf(Long.parseLong(String.valueOf(header.getPageSize()))));
            psBPostpredbookQueryVo.setStartdate(ps09001ReqDto.getStartDate());
            psBPostpredbookQueryVo.setEnddate(ps09001ReqDto.getEndDate());
            psBPostpredbookQueryVo.setBrnotype(ps09001ReqDto.getBrType());
            psBPostpredbookQueryVo.setBrnoList(queryBrNoList);
            psBPostpredbookQueryVo.setAccname(ps09001ReqDto.getAccName());
            psBPostpredbookQueryVo.setAccno(ps09001ReqDto.getAccNo());
            IPage pageObj = this.psBPostpredbookRepo.queryPage(psBPostpredbookQueryVo);
            ArrayList<Ps09001RspDtlDto> dtlDtos = new ArrayList<Ps09001RspDtlDto>();
            for (PsBPostpredbookPo psBPostpredbookPo : pageObj.getRecords()) {
                Ps09001RspDtlDto ps09001RspDtlDto = new Ps09001RspDtlDto();
                ps09001RspDtlDto.setTellerNo(psBPostpredbookPo.getPredtellerno());
                ps09001RspDtlDto.setAccNo(psBPostpredbookPo.getAccno());
                ps09001RspDtlDto.setAccName(psBPostpredbookPo.getAccname());
                ps09001RspDtlDto.setBrNo(psBPostpredbookPo.getBrno());
                if (StringUtils.isNotBlank((String)ps09001ReqDto.getAccName()) || StringUtils.isNotBlank((String)ps09001ReqDto.getAccNo())) {
                    ps09001RspDtlDto.setPredAmt(String.valueOf(psBPostpredbookPo.getAmt()));
                } else {
                    ps09001RspDtlDto.setPredAmt(psBPostpredbookPo.getAmtAll());
                }
                PsMWrtoffinlVo psMWrtoffinlVo = new PsMWrtoffinlVo();
                psMWrtoffinlVo.setBrno(psBPostpredbookPo.getBrno());
                psMWrtoffinlVo.setStartdate(ps09001ReqDto.getStartDate());
                psMWrtoffinlVo.setEnddate(ps09001ReqDto.getEndDate());
                psMWrtoffinlVo.setAccno(psBPostpredbookPo.getAccno());
                List byPredNo = this.psMWrtoffinlRepo.getByPredNo(psMWrtoffinlVo);
                if (byPredNo.size() == 0) {
                    ps09001RspDtlDto.setAmt("0");
                    ps09001RspDtlDto.setPredDeviRate("0");
                    ps09001RspDtlDto.setDeviAmt("0");
                    dtlDtos.add(ps09001RspDtlDto);
                    continue;
                }
                BigDecimal wrto_amt = ((PsMWrtoffinlPo)byPredNo.get(0)).getWrtoffamtAll();
                ps09001RspDtlDto.setAmt(wrto_amt.toString());
                ps09001RspDtlDto.setPredDeviRate(String.valueOf(wrto_amt.divide(new BigDecimal(ps09001RspDtlDto.getPredAmt()), 2, 4)));
                ps09001RspDtlDto.setDeviAmt(String.valueOf(wrto_amt.subtract(new BigDecimal(ps09001RspDtlDto.getPredAmt()))));
                dtlDtos.add(ps09001RspDtlDto);
            }
            Ps09001RspDto ps09001RspDto = new Ps09001RspDto("1", head.getResponseCode(), head.getResponseMsg());
            head.setTotalSize(pageObj.getTotal());
            ps09001RspDto.setList(dtlDtos);
            yuinResultDto.setBody((Object)ps09001RspDto);
        }
        return yuinResultDto;
    }
}

