/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.service;

import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.pay.position.application.dto.Ps07001.Ps07001ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.Ps07001.Ps07001RspDto;
import cn.com.yusys.yusp.pay.position.application.dto.Ps07001.Ps07001RspDtoTemp;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDBranchadmRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDControlruleRepo;
import cn.com.yusys.yusp.pay.position.domain.service.PsDBranchadmDomainService;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDBranchadmVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDControlruleVo;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestHead;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PS07001Service {
    private static final Logger log = LoggerFactory.getLogger(PS07001Service.class);
    @Autowired
    private PsDControlruleRepo psDControlruleRepo;
    @Autowired
    private PsDBranchadmRepo psDBranchadmRepo;
    @Autowired
    private PsDBranchadmDomainService psDBranchadmDomainService;

    public YuinResultDto<Ps07001RspDto> controlRuleHandle(YuinRequestDto<Ps07001ReqDto> yuinRequestDto) {
        YuinRequestDto request = new YuinRequestDto();
        request.setSysHead(yuinRequestDto.getSysHead());
        Ps07001ReqDto ps07001ReqDto = (Ps07001ReqDto)yuinRequestDto.getBody();
        request.setBody(BeanUtils.beanCopy((Object)yuinRequestDto.getBody(), PsDControlruleVo.class));
        YuinResultDto yuinResultDto = new YuinResultDto();
        YuinResultHead resultHead = new YuinResultHead();
        resultHead.setResponseCode("200");
        resultHead.setResponseMsg("\u901a\u8baf\u6210\u529f");
        yuinResultDto.setHead(resultHead);
        Optional<Object> optional = Optional.ofNullable(request.getBody());
        PsDControlruleVo psDControlruleVo = (PsDControlruleVo)optional.get();
        psDControlruleVo.setPage(Long.valueOf(request.getSysHead().getPageNum().intValue()));
        psDControlruleVo.setSize(Long.valueOf(request.getSysHead().getPageSize().intValue()));
        psDControlruleVo.setAppid(request.getSysHead().getAppid());
        psDControlruleVo.setSysid(request.getSysHead().getSysid());
        try {
            switch (StringUtils.isBlank((CharSequence)psDControlruleVo.getFuncType()) ? "9999" : psDControlruleVo.getFuncType()) {
                case "1": {
                    yuinResultDto.setBody((Object)this.doInsert(psDControlruleVo, request.getSysHead()));
                    break;
                }
                case "2": {
                    yuinResultDto.setBody((Object)this.doUpdate(psDControlruleVo, request.getSysHead()));
                    break;
                }
                case "3": {
                    yuinResultDto.setBody((Object)this.doDelete(psDControlruleVo));
                    break;
                }
                case "4": {
                    yuinResultDto.setBody((Object)this.doQuery(psDControlruleVo, resultHead, ps07001ReqDto, request.getSysHead()));
                    break;
                }
                default: {
                    yuinResultDto.setBody((Object)new Ps07001RspDto("0", PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000002.getErrMsg()));
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info(e.toString());
            yuinResultDto.setBody((Object)new Ps07001RspDto("0", PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg()));
        }
        return yuinResultDto;
    }

    private Ps07001RspDto doQuery(PsDControlruleVo psDControlruleVo, YuinResultHead resultHead, Ps07001ReqDto ps07001ReqDto, YuinRequestHead requestHead) {
        boolean isSuperBrno;
        ArrayList<String> orgTypeList = new ArrayList<String>();
        orgTypeList.add(ps07001ReqDto.getBranchType());
        String fatherBrno = requestHead.getBrno();
        String qryBrno = ps07001ReqDto.getBrNo();
        if (StringUtils.isNotBlank((CharSequence)qryBrno) && !(isSuperBrno = this.psDBranchadmDomainService.juageSuperBrno(fatherBrno, qryBrno).booleanValue())) {
            return new Ps07001RspDto("0", PSErrorMsg.PS000007.getErrCode(), PSErrorMsg.PS000007.getErrMsg() + "\u8f93\u5165\u7684\u673a\u6784\u53f7\u5fc5\u987b\u4e3a\u8f96\u5185\u673a\u6784");
        }
        ArrayList<String> brnoList = new ArrayList<String>();
        brnoList.add(qryBrno);
        List brnoBranchList = this.psDBranchadmRepo.getOrgInfoByOrgZoneBrno(orgTypeList, null, brnoList);
        ArrayList<String> queryBrnoList = new ArrayList<String>();
        for (PsDBranchadmVo vo2 : brnoBranchList) {
            queryBrnoList.add(vo2.getBrno());
        }
        psDControlruleVo.setQueryBrnoList(queryBrnoList);
        IPage rspDtoIPage = this.psDControlruleRepo.doQuery(psDControlruleVo).convert(vo -> (Ps07001RspDtoTemp)BeanUtils.beanCopy((Object)vo, Ps07001RspDtoTemp.class));
        resultHead.setTotalSize(rspDtoIPage.getTotal());
        Ps07001RspDto ps07001RspDto = new Ps07001RspDto("1", "", "");
        ps07001RspDto.setList(rspDtoIPage.getRecords());
        return ps07001RspDto;
    }

    private Ps07001RspDto doDelete(PsDControlruleVo psDControlruleVo) {
        if (StringUtils.isBlank((CharSequence)psDControlruleVo.getContcode())) {
            return new Ps07001RspDto("0", PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000004.getErrMsg() + "\u8bf7\u68c0\u67e5\u53c2\u6570\u4e0d\u53ef\u7f3a\u5c11\u5220\u9664\u4e3b\u952e:indicatorcode-\u6307\u6807\u7f16\u53f7");
        }
        this.psDControlruleRepo.doDelete(psDControlruleVo);
        return new Ps07001RspDto("1", "", "");
    }

    private Ps07001RspDto doUpdate(PsDControlruleVo psDControlruleVo, YuinRequestHead requestHead) {
        if (StringUtils.isBlank((CharSequence)psDControlruleVo.getContcode())) {
            return new Ps07001RspDto("0", PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000004.getErrMsg() + "\u8bf7\u68c0\u67e5\u53c2\u6570\u4e0d\u53ef\u7f3a\u5c11\u5220\u9664\u4e3b\u952e:indicatorcode-\u6307\u6807\u7f16\u53f7");
        }
        psDControlruleVo.setModifytime(DateUtils.getCurrDateTimeStr());
        psDControlruleVo.setModifier(requestHead.getTellerno());
        this.psDControlruleRepo.doUpdate(psDControlruleVo);
        return new Ps07001RspDto("1", "", "");
    }

    private Ps07001RspDto doInsert(PsDControlruleVo psDControlruleVo, YuinRequestHead requestHead) {
        if (StringUtils.isBlank((CharSequence)psDControlruleVo.getContcode())) {
            return new Ps07001RspDto("0", PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000004.getErrMsg() + "\u8bf7\u68c0\u67e5\u53c2\u6570\u4e0d\u53ef\u7f3a\u5c11\u5220\u9664\u4e3b\u952e:indicatorcode-\u6307\u6807\u7f16\u53f7");
        }
        psDControlruleVo.setBrno(requestHead.getBrno());
        psDControlruleVo.setTellerno(requestHead.getTellerno());
        psDControlruleVo.setCreatetime(DateUtils.getCurrDateTimeStr());
        psDControlruleVo.setCreator(requestHead.getTellerno());
        this.psDControlruleRepo.doInsert(psDControlruleVo);
        return new Ps07001RspDto("1", "", "");
    }
}

