/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.service;

import cn.com.yusys.yusp.commons.util.NumberUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.pay.position.domain.repo.PsMPaytranjnlRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsRBrpaytranRepo;
import cn.com.yusys.yusp.pay.position.domain.util.PSDateUtil;
import cn.com.yusys.yusp.pay.position.domain.vo.PsMPaytranjnlSummaryVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsRBrpaytranVo;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PS05003Service {
    private static final Logger log = LoggerFactory.getLogger(PS05003Service.class);
    @Autowired
    private PsMPaytranjnlRepo psMPaytranjnlRepo;
    @Autowired
    private PsRBrpaytranRepo psRBrpaytranRepo;

    public void taskExecution() {
        String yesterday = PSDateUtil.getYesterdayDate();
        List voList = this.psMPaytranjnlRepo.getEveryBranchInOutFlowAmtSum(yesterday);
        PsRBrpaytranVo brpaytranVo = null;
        for (PsMPaytranjnlSummaryVo vo : voList) {
            PsRBrpaytranVo psRBrpaytranVo = this.psRBrpaytranRepo.getRBrpaytranInfo(vo.getBrno(), yesterday);
            if (CollectionUtils.nonNull((Object)psRBrpaytranVo)) continue;
            brpaytranVo = new PsRBrpaytranVo();
            brpaytranVo.setBrno(vo.getBrno());
            brpaytranVo.setCramt(vo.getInamt());
            brpaytranVo.setDramt(vo.getOutamt());
            brpaytranVo.setHvcramt(vo.getHvinamt());
            brpaytranVo.setHvdramt(vo.getHvoutamt());
            brpaytranVo.setHvnetamt(NumberUtils.sub((BigDecimal[])new BigDecimal[]{vo.getHvinamt(), vo.getHvoutamt()}));
            brpaytranVo.setNetamt(NumberUtils.sub((BigDecimal[])new BigDecimal[]{vo.getInamt(), vo.getOutamt()}));
            brpaytranVo.setWorkdate(yesterday);
            this.psRBrpaytranRepo.save(brpaytranVo);
        }
    }
}

