/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.service;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.util.NumberUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps04006.Ps04006ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps04006.Ps04006RspDtlDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps04006.Ps04006RspDto;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDBranchadmRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsMCorpwarnjnlRepo;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.PsMCorpwarnjnlQueryVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsMCorpwarnjnlVo;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestHead;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PS04006Service {
    private static final Logger log = LoggerFactory.getLogger(PS04006Service.class);
    @Autowired
    private PsMCorpwarnjnlRepo psMCorpwarnjnlRepo;
    @Autowired
    private PsDBranchadmRepo psDBranchadmRepo;

    public YuinResultDto<Ps04006RspDto> ps04006(YuinRequestDto<Ps04006ReqDto> yuinRequestDto) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode("200");
        head.setResponseMsg("\u901a\u8baf\u6210\u529f");
        yuinResultDto.setHead(head);
        Ps04006RspDto rspBodyDto = new Ps04006RspDto();
        YuinRequestHead header = yuinRequestDto.getSysHead();
        String headerBrNo = header.getBrno();
        if (!this.psDBranchadmRepo.isBranchCanOperate(headerBrNo)) {
            throw new BizBaseException(PSErrorMsg.PS030001.getErrCode(), PSErrorMsg.PS030001.getErrMsg(), new Object[0]);
        }
        Ps04006ReqDto requestDtoBody = (Ps04006ReqDto)yuinRequestDto.getBody();
        String postType = requestDtoBody.getPostType();
        boolean isTopBranch = this.psDBranchadmRepo.isTopBranch(headerBrNo);
        if (!isTopBranch) {
            throw new BizBaseException(PSErrorMsg.PS030001.getErrCode(), PSErrorMsg.PS030001.getErrMsg(), new Object[0]);
        }
        PsMCorpwarnjnlQueryVo queryVo = new PsMCorpwarnjnlQueryVo();
        queryVo.setPage(Long.valueOf(Long.parseLong(String.valueOf(header.getPageNum()))));
        queryVo.setSize(Long.valueOf(Long.parseLong(String.valueOf(header.getPageSize()))));
        queryVo.setStartDate(requestDtoBody.getStartDate());
        queryVo.setEndDate(requestDtoBody.getEndDate());
        queryVo.setPostType(postType);
        IPage pageObj = this.psMCorpwarnjnlRepo.getList(queryVo);
        ArrayList<Ps04006RspDtlDto> dtlDtoList = new ArrayList<Ps04006RspDtlDto>();
        Ps04006RspDtlDto dtlDto = null;
        for (PsMCorpwarnjnlVo vo : pageObj.getRecords()) {
            dtlDto = new Ps04006RspDtlDto();
            dtlDto.setPosName(vo.getPostname());
            dtlDto.setPostAccNo(vo.getPostaccno());
            dtlDto.setPosTypeName(vo.getPostname());
            dtlDto.setWorkDate(vo.getWorkdate());
            dtlDto.setWorkTime(vo.getWorktime());
            dtlDto.setPosAccAmt(NumberUtils.nullDefaultZero((Number)vo.getPostbal()).toString());
            dtlDto.setLimitAmt(NumberUtils.nullDefaultZero((Number)vo.getLimitamt()).toString());
            dtlDto.setWarnAmt(NumberUtils.nullDefaultZero((Number)vo.getWarnamt()).toString());
            if ("01".equals(vo.getWarntype())) {
                dtlDto.setWarnTypeName("\u5934\u5bf8\u5321\u7b97");
            } else if ("02".equals(vo.getWarntype())) {
                dtlDto.setWarnTypeName("\u5b9e\u65f6\u76d1\u6d4b");
            }
            BigDecimal bal = vo.getPostbal();
            BigDecimal limitAmt = vo.getLimitamt();
            BigDecimal warnAmt = vo.getWarnamt();
            if (bal.compareTo(limitAmt) >= 0) {
                dtlDto.setColor("01");
            }
            if (bal.compareTo(warnAmt) <= 0) {
                dtlDto.setColor("02");
            }
            dtlDtoList.add(dtlDto);
        }
        head.setTotalSize(pageObj.getTotal());
        rspBodyDto.setList(dtlDtoList);
        rspBodyDto.setStatus("1");
        rspBodyDto.setErrcode(head.getResponseCode());
        rspBodyDto.setErrmsg(head.getResponseMsg());
        yuinResultDto.setBody((Object)rspBodyDto);
        return yuinResultDto;
    }
}

