/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.service;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.util.NumberUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps04005.Ps04005ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps04005.Ps04005RspDtlDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps04005.Ps04005RspDto;
import cn.com.yusys.yusp.pay.position.domain.entity.PsBranchAccountDo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDBranchadmRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsMBankwarnjnlRepo;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.PsMBankwarnjnlQueryVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsMBankwarnjnlVo;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestHead;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PS04005Service {
    private static final Logger log = LoggerFactory.getLogger(PS04005Service.class);
    @Autowired
    private PsMBankwarnjnlRepo psMBankwarnjnlRepo;
    @Autowired
    private PsDBranchadmRepo psDBranchadmRepo;

    public YuinResultDto<Ps04005RspDto> ps04005(YuinRequestDto<Ps04005ReqDto> yuinRequestDto) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode("200");
        head.setResponseMsg("\u901a\u8baf\u6210\u529f");
        yuinResultDto.setHead(head);
        Ps04005RspDto rspBodyDto = new Ps04005RspDto();
        YuinRequestHead header = yuinRequestDto.getSysHead();
        Ps04005ReqDto requestDtoBody = (Ps04005ReqDto)yuinRequestDto.getBody();
        String headerBrNo = header.getBrno();
        if (!this.psDBranchadmRepo.isBranchCanOperate(headerBrNo)) {
            throw new BizBaseException(PSErrorMsg.PS030001.getErrCode(), PSErrorMsg.PS030001.getErrMsg(), new Object[0]);
        }
        String brType = requestDtoBody.getBrType();
        String brNo = requestDtoBody.getBrNo();
        PsBranchAccountDo branchAccountDo = new PsBranchAccountDo();
        branchAccountDo.checkBrTypeValue(brType);
        boolean isTopBranch = this.psDBranchadmRepo.isTopBranch(headerBrNo);
        List<String> queryBrNoList = new ArrayList<String>();
        if ("01".equals(brType)) {
            queryBrNoList.add(headerBrNo);
        } else if ("02".equals(brType)) {
            if (isTopBranch) {
                queryBrNoList = this.psDBranchadmRepo.getBranchNoList93();
            }
        } else if ("03".equals(brType)) {
            if (StringUtils.isBlank((String)brNo)) {
                throw new BizBaseException(PSErrorMsg.PS000008.getErrCode(), "\u673a\u6784\u53f7" + PSErrorMsg.PS000008.getErrMsg(), new Object[0]);
            }
            if (isTopBranch) {
                queryBrNoList.add(brNo);
            }
        }
        ArrayList<Ps04005RspDtlDto> dtlDtoList = new ArrayList<Ps04005RspDtlDto>();
        long totalSize = 0L;
        if (CollectionUtils.nonEmpty(queryBrNoList)) {
            PsMBankwarnjnlQueryVo queryVo = new PsMBankwarnjnlQueryVo();
            queryVo.setPage(Long.valueOf(Long.parseLong(String.valueOf(header.getPageNum()))));
            queryVo.setSize(Long.valueOf(Long.parseLong(String.valueOf(header.getPageSize()))));
            queryVo.setStartDate(requestDtoBody.getStartDate());
            queryVo.setEndDate(requestDtoBody.getEndDate());
            queryVo.setBrNoList(queryBrNoList);
            IPage pageObj = this.psMBankwarnjnlRepo.getList(queryVo);
            Ps04005RspDtlDto dtlDto = null;
            for (PsMBankwarnjnlVo vo : pageObj.getRecords()) {
                dtlDto = new Ps04005RspDtlDto();
                dtlDto.setBrName(vo.getClearbrname());
                dtlDto.setBrNo(vo.getClearbrno());
                dtlDto.setLimitAmt(NumberUtils.nullDefaultZero((Number)vo.getLimitamt()).toString());
                dtlDto.setPosAccAmt(NumberUtils.nullDefaultZero((Number)vo.getPostbal()).toString());
                dtlDto.setWarnAmt(NumberUtils.nullDefaultZero((Number)vo.getWarnamt()).toString());
                dtlDto.setWorkDate(vo.getWorkdate());
                dtlDto.setWorkTime(vo.getWorktime());
                BigDecimal bal = vo.getPostbal();
                BigDecimal limitAmt = vo.getLimitamt();
                BigDecimal warnAmt = vo.getWarnamt();
                if (bal.compareTo(limitAmt) >= 0) {
                    dtlDto.setColor("01");
                }
                if (bal.compareTo(warnAmt) <= 0) {
                    dtlDto.setColor("02");
                }
                dtlDtoList.add(dtlDto);
            }
            totalSize = pageObj.getTotal();
        }
        head.setTotalSize(totalSize);
        rspBodyDto.setList(dtlDtoList);
        rspBodyDto.setStatus("1");
        rspBodyDto.setErrcode(head.getResponseCode());
        rspBodyDto.setErrmsg(head.getResponseMsg());
        yuinResultDto.setBody((Object)rspBodyDto);
        return yuinResultDto;
    }
}

