/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.service;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.util.NumberUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps04004.Ps04004ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps04004.Ps04004RspDtlDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps04004.Ps04004RspDto;
import cn.com.yusys.yusp.pay.position.domain.entity.PsBranchAccountDo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDBranchadmRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsMHvtranjnlRepo;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.PsMHvtranjnlQueryVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsMHvtranjnlVo;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestHead;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PS04004Service {
    private static final Logger log = LoggerFactory.getLogger(PS04004Service.class);
    @Autowired
    private PsMHvtranjnlRepo psMHvtranjnlRepo;
    @Autowired
    private PsDBranchadmRepo psDBranchadmRepo;

    public YuinResultDto<Ps04004RspDto> ps04004(YuinRequestDto<Ps04004ReqDto> yuinRequestDto) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode("200");
        head.setResponseMsg("\u901a\u8baf\u6210\u529f");
        yuinResultDto.setHead(head);
        Ps04004RspDto rspBodyDto = new Ps04004RspDto();
        YuinRequestHead header = yuinRequestDto.getSysHead();
        Ps04004ReqDto requestDtoBody = (Ps04004ReqDto)yuinRequestDto.getBody();
        String headerBrNo = header.getBrno();
        if (!this.psDBranchadmRepo.isBranchCanOperate(headerBrNo)) {
            throw new BizBaseException(PSErrorMsg.PS030001.getErrCode(), PSErrorMsg.PS030001.getErrMsg(), new Object[0]);
        }
        String brType = requestDtoBody.getBrType();
        String brNo = requestDtoBody.getBrNo();
        PsBranchAccountDo branchAccountDo = new PsBranchAccountDo();
        branchAccountDo.checkBrTypeValue(brType);
        boolean isTopBranch = this.psDBranchadmRepo.isTopBranch(headerBrNo);
        List<String> queryBrNoList = new ArrayList<String>();
        if ("01".equals(brType)) {
            queryBrNoList.add(headerBrNo);
        } else if ("02".equals(brType)) {
            if (isTopBranch) {
                queryBrNoList = this.psDBranchadmRepo.getBranchNoList93();
            }
        } else if ("03".equals(brType)) {
            if (StringUtils.isBlank((String)brNo)) {
                throw new BizBaseException(PSErrorMsg.PS000008.getErrCode(), "\u673a\u6784\u53f7" + PSErrorMsg.PS000008.getErrMsg(), new Object[0]);
            }
            if (isTopBranch) {
                queryBrNoList.add(brNo);
            }
        }
        ArrayList<Ps04004RspDtlDto> dtlDtoList = new ArrayList<Ps04004RspDtlDto>();
        long totalSize = 0L;
        if (CollectionUtils.nonEmpty(queryBrNoList)) {
            PsMHvtranjnlQueryVo queryVo = new PsMHvtranjnlQueryVo();
            queryVo.setPage(Long.valueOf(Long.parseLong(String.valueOf(header.getPageNum()))));
            queryVo.setSize(Long.valueOf(Long.parseLong(String.valueOf(header.getPageSize()))));
            queryVo.setStartDate(requestDtoBody.getStartDate());
            queryVo.setEndDate(requestDtoBody.getEndDate());
            queryVo.setBrNoList(queryBrNoList);
            queryVo.setMaxAmt(requestDtoBody.getMaxAmt());
            queryVo.setMinAmt(requestDtoBody.getMinAmt());
            IPage pageObj = this.psMHvtranjnlRepo.getList(queryVo);
            Ps04004RspDtlDto dtlDto = null;
            for (PsMHvtranjnlVo vo : pageObj.getRecords()) {
                dtlDto = new Ps04004RspDtlDto();
                dtlDto.setAmt(NumberUtils.nullDefaultZero((Number)vo.getAmt()).toString());
                dtlDto.setBrchBrName("\u673a\u6784");
                dtlDto.setBrchBrNo(vo.getBrno());
                dtlDto.setBrName("\u673a\u6784");
                dtlDto.setBrNo(vo.getBrno());
                dtlDto.setBusiTypeName("\u6c47\u5151");
                dtlDto.setChnlName("\u67dc\u9762");
                dtlDto.setCurCodeName("\u4eba\u6c11\u5e01");
                dtlDto.setCvsAmt(NumberUtils.nullDefaultZero((Number)vo.getCvsamt()).toString());
                dtlDto.setMbFlagName("\u5f80\u8d26");
                dtlDto.setOppoBankName("\u5de5\u5546\u94f6\u884c");
                dtlDto.setOppoBankNo(vo.getSendbankno());
                dtlDto.setPayChnlName("\u8d85\u7f51");
                dtlDto.setPayeeAccNo(vo.getPayeeaccno());
                dtlDto.setPayeeName(vo.getPayeename());
                dtlDto.setPayerAccNo(vo.getPayeraccno());
                dtlDto.setPayerName(vo.getPayername());
                dtlDto.setPurpose(vo.getPurposermk());
                dtlDto.setPmtdrtName("\u6d41\u51fa");
                dtlDto.setWorkDate(vo.getWorkdate());
                dtlDto.setWorkSeqId(vo.getWorkseqid());
                dtlDto.setWorkTime(vo.getWorktime());
                dtlDtoList.add(dtlDto);
            }
            totalSize = pageObj.getTotal();
        }
        head.setTotalSize(totalSize);
        rspBodyDto.setList(dtlDtoList);
        rspBodyDto.setStatus("1");
        rspBodyDto.setErrcode(head.getResponseCode());
        rspBodyDto.setErrmsg(head.getResponseMsg());
        yuinResultDto.setBody((Object)rspBodyDto);
        return yuinResultDto;
    }
}

