/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.service;

import cn.com.yusys.yusp.commons.sequence.util.SequenceUtils;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.date.DateFormatEnum;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps03001.Ps03001DtelRspDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps03001.Ps03001ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps03001.Ps03001RspDto;
import cn.com.yusys.yusp.pay.position.domain.repo.PsBPostpredbookRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDBranchadmRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDIndicatorruleRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsSSysparamRepo;
import cn.com.yusys.yusp.pay.position.domain.service.PsDBranchadmDomainService;
import cn.com.yusys.yusp.pay.position.domain.util.PSDateUtil;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.PsBPostpredbookQueryVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsBPostpredbookVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDBranchadmVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDIndicatorruleVo;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PS03001Service {
    @Autowired
    private PsBPostpredbookRepo ps03001Repo;
    @Autowired
    private PsDBranchadmRepo psDBranchadmRepo;
    @Autowired
    private PsSSysparamRepo psSSysparamRepo;
    @Autowired
    private PsDBranchadmDomainService psDBranchadmDomainService;
    @Autowired
    private PsDIndicatorruleRepo psDIndicatorruleRepo;
    private static final Logger log = LoggerFactory.getLogger(PS03001Service.class);

    public YuinResultDto ps03001(YuinRequestDto<Ps03001ReqDto> yuinRequestDto) {
        Ps03001ReqDto ps03001ReqDto = (Ps03001ReqDto)yuinRequestDto.getBody();
        String funcType = ps03001ReqDto.getFunctype();
        String tellerNo = yuinRequestDto.getSysHead().getTellerno();
        String tellername = yuinRequestDto.getSysHead().getTellername();
        String brNo = yuinRequestDto.getSysHead().getBrno();
        YuinRequestDto request = new YuinRequestDto();
        request.setSysHead(yuinRequestDto.getSysHead());
        request.setBody(BeanUtils.beanCopy((Object)ps03001ReqDto, PsBPostpredbookVo.class));
        PsBPostpredbookQueryVo queryVo = (PsBPostpredbookQueryVo)BeanUtils.beanCopy((Object)yuinRequestDto.getBody(), PsBPostpredbookQueryVo.class);
        queryVo.setPage(Long.valueOf(yuinRequestDto.getSysHead().getPageNum().intValue()));
        queryVo.setSize(Long.valueOf(yuinRequestDto.getSysHead().getPageSize().intValue()));
        YuinResultDto resultDto = new YuinResultDto();
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode("200");
        head.setResponseMsg("\u901a\u8baf\u6210\u529f");
        resultDto.setHead(head);
        try {
            switch (funcType) {
                case "1": {
                    resultDto.setBody((Object)this.doUpdate((PsBPostpredbookVo)request.getBody(), "1", tellerNo, brNo));
                    break;
                }
                case "2": {
                    resultDto.setBody((Object)this.doUpdate((PsBPostpredbookVo)request.getBody(), "2", tellerNo, brNo));
                    break;
                }
                case "3": {
                    resultDto.setBody((Object)this.doUpdate((PsBPostpredbookVo)request.getBody(), "3", tellerNo, brNo));
                    break;
                }
                case "4": {
                    resultDto.setBody((Object)this.doUpdate((PsBPostpredbookVo)request.getBody(), "4", tellerNo, brNo));
                    break;
                }
                case "5": {
                    resultDto.setBody((Object)this.doUpdate((PsBPostpredbookVo)request.getBody(), "5", tellerNo, brNo));
                    break;
                }
                case "6": {
                    resultDto.setBody((Object)this.doInset((PsBPostpredbookVo)request.getBody(), tellerNo, brNo, tellername));
                    break;
                }
                case "7": {
                    resultDto.setBody((Object)this.doQuery(queryVo, tellerNo, brNo, head));
                    break;
                }
                case "8": {
                    resultDto.setBody((Object)this.doDelete((PsBPostpredbookVo)request.getBody(), tellerNo, brNo));
                    break;
                }
                default: {
                    resultDto.setBody((Object)new Ps03001RspDto("0", PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000002.getErrMsg()));
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info(e.toString());
            resultDto.setBody((Object)new Ps03001RspDto("0", PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg()));
        }
        if (!"1".equals(((Ps03001RspDto)resultDto.getBody()).getStatus())) {
            head.setResponseCode(((Ps03001RspDto)resultDto.getBody()).getErrcode());
            head.setResponseMsg(((Ps03001RspDto)resultDto.getBody()).getErrmsg());
        }
        return resultDto;
    }

    private Ps03001RspDto doUpdate(PsBPostpredbookVo dataVo, String funcType, String tellerNo, String brNo) {
        PsDBranchadmVo psDBranchadmVo;
        String currentDate = DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT);
        if (currentDate.equals(dataVo.getPreddate())) {
            dataVo.setPredmode("2");
        }
        if ("1".equals(funcType)) {
            if (!brNo.equals(dataVo.getBrno())) {
                return new Ps03001RspDto("0", PSErrorMsg.PS030001.getErrCode(), PSErrorMsg.PS030001.getErrMsg());
            }
            if (!("01".equals(dataVo.getPredstatus()) || "02".equals(dataVo.getPredstatus()) || "03".equals(dataVo.getPredstatus()) || "04".equals(dataVo.getPredstatus()))) {
                return new Ps03001RspDto("0", PSErrorMsg.PS030002.getErrCode(), PSErrorMsg.PS030002.getErrMsg());
            }
            dataVo.setWrtoffbal(dataVo.getAmt());
            dataVo.setPredstatus("01");
            dataVo.setPredtellerno(tellerNo);
            if (PSDateUtil.isSecondDateIsGreaterThanFirstDate((String)DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT), (String)dataVo.getPreddate())) {
                dataVo.setPredmode("1");
            } else {
                dataVo.setPredmode("2");
            }
            this.ps03001Repo.doUpdate(dataVo);
        }
        if ("2".equals(funcType)) {
            if (!brNo.equals(dataVo.getBrno())) {
                return new Ps03001RspDto("0", PSErrorMsg.PS030001.getErrCode(), PSErrorMsg.PS030001.getErrMsg());
            }
            if (!("01".equals(dataVo.getPredstatus()) || "03".equals(dataVo.getPredstatus()) || "04".equals(dataVo.getPredstatus()))) {
                return new Ps03001RspDto("0", PSErrorMsg.PS030002.getErrCode(), PSErrorMsg.PS030002.getErrMsg());
            }
            dataVo.setPredstatus("02");
            dataVo.setPredtellerno(tellerNo);
            this.ps03001Repo.doUpdate(dataVo);
        }
        if ("3".equals(funcType)) {
            if (this.psDBranchadmRepo.isTopBranch(brNo)) {
                if (!"06".equals(dataVo.getPredstatus()) && !"11".equals(dataVo.getPredstatus())) {
                    return new Ps03001RspDto("0", PSErrorMsg.PS030002.getErrCode(), PSErrorMsg.PS030002.getErrMsg());
                }
                if ("06".equals(dataVo.getPredstatus())) {
                    dataVo.setPredstatus("07");
                } else {
                    dataVo.setPredstatus("04");
                }
                dataVo.setProtellerno2(tellerNo);
            } else {
                psDBranchadmVo = this.psDBranchadmRepo.getBranchInfoByBrNo(brNo);
                if (!"41".equals(psDBranchadmVo.getOrgtype())) {
                    return new Ps03001RspDto("0", PSErrorMsg.PS030001.getErrCode(), PSErrorMsg.PS030001.getErrMsg());
                }
                if (!this.psDBranchadmDomainService.juageSuperBrno(brNo, dataVo.getBrno()).booleanValue()) {
                    return new Ps03001RspDto("0", PSErrorMsg.PS030001.getErrCode(), PSErrorMsg.PS030001.getErrMsg());
                }
                if (!"02".equals(dataVo.getPredstatus()) && !"10".equals(dataVo.getPredstatus())) {
                    return new Ps03001RspDto("0", PSErrorMsg.PS030002.getErrCode(), PSErrorMsg.PS030002.getErrMsg());
                }
                String flag = this.psSSysparamRepo.getValueById("PS", "PS", "topOrgPred");
                if ("1".equals(flag)) {
                    if ("02".equals(dataVo.getPredstatus())) {
                        dataVo.setPredstatus("06");
                    } else {
                        dataVo.setPredstatus("11");
                    }
                } else if ("02".equals(dataVo.getPredstatus())) {
                    dataVo.setPredstatus("05");
                } else {
                    dataVo.setPredstatus("04");
                }
                dataVo.setProtellerno(tellerNo);
            }
            this.ps03001Repo.doUpdate(dataVo);
        }
        if ("4".equals(funcType)) {
            if (this.psDBranchadmRepo.isTopBranch(brNo)) {
                if (!"06".equals(dataVo.getPredstatus())) {
                    return new Ps03001RspDto("0", PSErrorMsg.PS030002.getErrCode(), PSErrorMsg.PS030002.getErrMsg());
                }
                dataVo.setProtellerno2(tellerNo);
            } else {
                psDBranchadmVo = this.psDBranchadmRepo.getBranchInfoByBrNo(brNo);
                if (!"41".equals(psDBranchadmVo.getOrgtype())) {
                    return new Ps03001RspDto("0", PSErrorMsg.PS030001.getErrCode(), PSErrorMsg.PS030001.getErrMsg());
                }
                if (!this.psDBranchadmDomainService.juageSuperBrno(brNo, dataVo.getBrno()).booleanValue()) {
                    return new Ps03001RspDto("0", PSErrorMsg.PS030001.getErrCode(), PSErrorMsg.PS030001.getErrMsg());
                }
                if (!"02".equals(dataVo.getPredstatus())) {
                    return new Ps03001RspDto("0", PSErrorMsg.PS030002.getErrCode(), PSErrorMsg.PS030002.getErrMsg());
                }
                dataVo.setProtellerno(tellerNo);
            }
            dataVo.setPredstatus("03");
            this.ps03001Repo.doUpdate(dataVo);
        }
        if ("5".equals(funcType)) {
            if (!brNo.equals(dataVo.getBrno())) {
                return new Ps03001RspDto("0", PSErrorMsg.PS030001.getErrCode(), PSErrorMsg.PS030001.getErrMsg());
            }
            if (!("05".equals(dataVo.getPredstatus()) || "07".equals(dataVo.getPredstatus()) || "09".equals(dataVo.getPredstatus()))) {
                return new Ps03001RspDto("0", PSErrorMsg.PS030002.getErrCode(), PSErrorMsg.PS030002.getErrMsg());
            }
            if (!"01".equals(dataVo.getWrtoffstatus())) {
                return new Ps03001RspDto("0", PSErrorMsg.PS030002.getErrCode(), PSErrorMsg.PS030002.getErrMsg());
            }
            dataVo.setPredstatus("10");
            dataVo.setPredtellerno(tellerNo);
            this.ps03001Repo.doUpdate(dataVo);
        }
        return new Ps03001RspDto("1", "", "");
    }

    private Ps03001RspDto doInset(PsBPostpredbookVo dataVo, String tellerNo, String brNo, String tellername) {
        PsDIndicatorruleVo repVo;
        List repList;
        dataVo.setWorkdate(DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT));
        String msgid = SequenceUtils.getSequence((String)"bankseqno");
        dataVo.setPredno(msgid);
        dataVo.setPredtellerno(tellerNo);
        dataVo.setPredstatus("01");
        dataVo.setWrtoffbal(dataVo.getAmt());
        dataVo.setWrtoffstatus("01");
        dataVo.setPredteller(tellername);
        if ("1".equals(dataVo.getPredkind()) && (repList = this.psDIndicatorruleRepo.getIndicatorRuleInfo(dataVo.getBrno(), Arrays.asList("04005"))).size() != 0 && (repVo = (PsDIndicatorruleVo)repList.get(0)).getIndicatorval().compareTo(dataVo.getAmt()) > 0) {
            return new Ps03001RspDto("0", PSErrorMsg.PS030005.getErrCode(), PSErrorMsg.PS030005.getErrMsg());
        }
        if ("01".equals(dataVo.getCurcode())) {
            dataVo.setCvsamt(dataVo.getAmt());
        }
        if (PSDateUtil.isSecondDateIsGreaterThanFirstDate((String)DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT), (String)dataVo.getPreddate())) {
            dataVo.setPredmode("1");
        } else {
            dataVo.setPredmode("2");
        }
        this.ps03001Repo.save(dataVo);
        return new Ps03001RspDto("1", "", "");
    }

    private Ps03001RspDto doQuery(PsBPostpredbookQueryVo dataVo, String tellerNo, String brNo, YuinResultHead head) {
        if ("01".equals(dataVo.getBrnotype()) || "02".equals(dataVo.getBrnotype())) {
            dataVo.setBrno(brNo);
        } else if (!this.psDBranchadmDomainService.juageSuperBrno(brNo, dataVo.getBrno()).booleanValue()) {
            return new Ps03001RspDto("0", PSErrorMsg.PS030001.getErrCode(), PSErrorMsg.PS030001.getErrMsg());
        }
        IPage rspDtoIPage = this.ps03001Repo.doQuery(dataVo).convert(po -> (Ps03001DtelRspDto)BeanUtils.beanCopy((Object)po, Ps03001DtelRspDto.class));
        ArrayList<Ps03001DtelRspDto> reList = new ArrayList<Ps03001DtelRspDto>();
        for (Ps03001DtelRspDto dto : rspDtoIPage.getRecords()) {
            dto.setBrnoName(this.psDBranchadmRepo.getBranchInfoByBrNo(dto.getBrno()).getBrname());
            reList.add(dto);
        }
        Ps03001RspDto ps03001RspDto = new Ps03001RspDto("1", "", "");
        ps03001RspDto.setList(rspDtoIPage.getRecords());
        head.setTotalSize(rspDtoIPage.getTotal());
        return ps03001RspDto;
    }

    private Ps03001RspDto doDelete(PsBPostpredbookVo dataVo, String tellerNo, String brNo) {
        if (!brNo.equals(dataVo.getBrno())) {
            return new Ps03001RspDto("0", PSErrorMsg.PS030001.getErrCode(), PSErrorMsg.PS030001.getErrMsg());
        }
        if (!("01".equals(dataVo.getPredstatus()) || "02".equals(dataVo.getPredstatus()) || "03".equals(dataVo.getPredstatus()) || "04".equals(dataVo.getPredstatus()))) {
            return new Ps03001RspDto("0", PSErrorMsg.PS030002.getErrCode(), PSErrorMsg.PS030002.getErrMsg());
        }
        this.ps03001Repo.doDelete(dataVo);
        return new Ps03001RspDto("1", "", "");
    }
}

