/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.resource;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.validation.util.ValidatorUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps10501.Ps10501ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps10501.Ps10501RspDto;
import cn.com.yusys.yusp.pay.position.application.service.PS10501Service;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"PS10501"})
@RestController
@RequestMapping(value={"/api/payment/ps"})
public class PS10501Resource {
    private static final Logger log = LoggerFactory.getLogger(PS10501Resource.class);
    @Autowired
    private PS10501Service ps10501Service;

    @ApiOperation(value="\u5b9e\u65f6\u6c47\u7387\u8f6c\u6362")
    @PostMapping(value={"/ps10501"})
    public YuinResultDto<Ps10501RspDto> ps10501(@RequestBody YuinRequestDto<Ps10501ReqDto> yuinRequestDto) {
        try {
            this.validateRequestDto(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        try {
            return this.ps10501Service.ps10501(yuinRequestDto);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            return this.handleException(PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg());
        }
    }

    private void validateRequestDto(YuinRequestDto<Ps10501ReqDto> yuinRequestDto) {
        try {
            ValidatorUtils.validate((Object)yuinRequestDto.getBody(), (Class[])new Class[0]);
        }
        catch (BizBaseException bizBaseException) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), bizBaseException.getCode(), new Object[0]);
        }
    }

    private YuinResultDto<Ps10501RspDto> handleException(String errCode, String errMsg) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        Ps10501RspDto rspDto = new Ps10501RspDto("0", errCode, errMsg);
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode(rspDto.getErrcode());
        head.setResponseMsg(rspDto.getErrmsg());
        head.setStatus(rspDto.getStatus());
        yuinResultDto.setHead(head);
        yuinResultDto.setBody((Object)rspDto);
        return yuinResultDto;
    }
}

