/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.resource;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.util.date.DateFormatEnum;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.commons.validation.util.ValidatorUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps09001.Ps09001ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps09001.Ps09001RspDto;
import cn.com.yusys.yusp.pay.position.application.service.PS09001Service;
import cn.com.yusys.yusp.pay.position.domain.util.PSDateUtil;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"PS09001"})
@RestController
@RequestMapping(value={"/api/payment/ps"})
public class PS09001Resource {
    @Autowired
    private PS09001Service pS09001Service;

    @ApiOperation(value="\u9884\u62a5\u504f\u79bb\u5ea6\u5206\u6790")
    @PostMapping(value={"/ps09001"})
    public YuinResultDto<Ps09001RspDto> ps09001(@RequestBody YuinRequestDto<Ps09001ReqDto> yuinRequestDto) {
        try {
            this.validateRequestDto(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        try {
            return this.pS09001Service.ps09001(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.handleException(PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg());
        }
    }

    private void validateRequestDto(YuinRequestDto<Ps09001ReqDto> requestDto) {
        try {
            ValidatorUtils.validate((Object)requestDto.getBody(), (Class[])new Class[0]);
        }
        catch (BizBaseException bizBaseException) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), bizBaseException.getCode(), new Object[0]);
        }
        String brType = ((Ps09001ReqDto)requestDto.getBody()).getBrType();
        String brNo = ((Ps09001ReqDto)requestDto.getBody()).getBrNo();
        if ("03".equals(brType) && StringUtils.isBlank((String)brNo)) {
            throw new BizBaseException(PSErrorMsg.PS000008.getErrCode(), "\u673a\u6784\u53f7" + PSErrorMsg.PS000008.getErrMsg(), new Object[0]);
        }
        String startDate = ((Ps09001ReqDto)requestDto.getBody()).getStartDate();
        String endDate = ((Ps09001ReqDto)requestDto.getBody()).getEndDate();
        String currentDate = DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT);
        if (PSDateUtil.isSecondDateIsGreaterThanFirstDate((String)currentDate, (String)startDate)) {
            throw new BizBaseException(PSErrorMsg.PS080001.getErrCode(), PSErrorMsg.PS080001.getErrMsg(), new Object[0]);
        }
        if (PSDateUtil.isSecondDateIsGreaterThanFirstDate((String)currentDate, (String)endDate)) {
            throw new BizBaseException(PSErrorMsg.PS080002.getErrCode(), PSErrorMsg.PS080002.getErrMsg(), new Object[0]);
        }
        if (PSDateUtil.isSecondDateIsGreaterThanFirstDate((String)endDate, (String)startDate)) {
            throw new BizBaseException(PSErrorMsg.PS080003.getErrCode(), PSErrorMsg.PS080003.getErrMsg(), new Object[0]);
        }
    }

    private YuinResultDto<Ps09001RspDto> handleException(String errCode, String errMsg) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        YuinResultHead head = new YuinResultHead();
        Ps09001RspDto rspDto = new Ps09001RspDto("0", errCode, errMsg);
        head.setResponseCode(rspDto.getErrcode());
        head.setResponseMsg(rspDto.getErrmsg());
        head.setStatus(rspDto.getStatus());
        yuinResultDto.setHead(head);
        yuinResultDto.setBody((Object)rspDto);
        return yuinResultDto;
    }
}

