/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.resource;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.validation.util.ValidatorUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps05002.Ps05002ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps05002.Ps05002RspDto;
import cn.com.yusys.yusp.pay.position.application.service.PS05002Service;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"PS05002"})
@RestController
public class PS05002Resource {
    @Autowired
    private PS05002Service pS05002Service;

    @ApiOperation(value="\u8282\u5047\u65e5\u6d41\u52a8\u6027\u9884\u6d4b")
    @PostMapping(value={"/api/payment/ps/ps05002"})
    public YuinResultDto<Ps05002RspDto> ps05002(@RequestBody YuinRequestDto<Ps05002ReqDto> yuinRequestDto) {
        try {
            this.validateRequestDto(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        try {
            return this.pS05002Service.ps05002(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.handleException(PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg());
        }
    }

    private void validateRequestDto(YuinRequestDto<Ps05002ReqDto> requestDto) {
        try {
            ValidatorUtils.validate((Object)requestDto.getBody(), (Class[])new Class[0]);
        }
        catch (BizBaseException bizBaseException) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), bizBaseException.getCode(), new Object[0]);
        }
    }

    private YuinResultDto<Ps05002RspDto> handleException(String errCode, String errMsg) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        YuinResultHead head = new YuinResultHead();
        yuinResultDto.setHead(head);
        Ps05002RspDto rspDto = new Ps05002RspDto("0", errCode, errMsg);
        yuinResultDto.setBody((Object)rspDto);
        head.setResponseCode(rspDto.getErrcode());
        head.setResponseMsg(rspDto.getErrmsg());
        head.setStatus(rspDto.getStatus());
        return yuinResultDto;
    }
}

