/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.resource;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.util.date.DateFormatEnum;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.commons.validation.util.ValidatorUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps04001.Ps04001ReqDtoDemo;
import cn.com.yusys.yusp.pay.position.application.dto.ps04001.Ps04001RspDto;
import cn.com.yusys.yusp.pay.position.application.service.PS04001ServiceDemo;
import cn.com.yusys.yusp.pay.position.domain.util.PSDateUtil;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"PS04001"})
@RestController
@RequestMapping(value={"/api/payment/ps"})
public class PS04001ResourceDemo {
    private static final Logger log = LoggerFactory.getLogger(PS04001ResourceDemo.class);
    @Autowired
    private PS04001ServiceDemo ps04001ServiceDemo;

    @ApiOperation(value="\u5934\u5bf8\u76d1\u6d4b\u6a21\u5757\u5404\u529f\u80fd\u7edf\u4e00\u63a5\u53e3")
    @PostMapping(value={"/ps04001demo"})
    public YuinResultDto<Ps04001RspDto> ps04001(@RequestBody YuinRequestDto<Ps04001ReqDtoDemo> yuinRequestDto) {
        try {
            this.validateRequestDto(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        try {
            return this.ps04001ServiceDemo.ps04001(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.handleException(PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg());
        }
    }

    private void validateRequestDto(YuinRequestDto<Ps04001ReqDtoDemo> requestDto) {
        try {
            ValidatorUtils.validate((Object)requestDto.getBody(), (Class[])new Class[0]);
        }
        catch (BizBaseException bizBaseException) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), bizBaseException.getCode(), new Object[0]);
        }
        String startDate = ((Ps04001ReqDtoDemo)requestDto.getBody()).getStartDate();
        String endDate = ((Ps04001ReqDtoDemo)requestDto.getBody()).getEndDate();
        String currentDate = DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT);
        if (PSDateUtil.isSecondDateIsGreaterThanFirstDate((String)currentDate, (String)startDate)) {
            throw new BizBaseException(PSErrorMsg.PS080001.getErrCode(), PSErrorMsg.PS080001.getErrMsg(), new Object[0]);
        }
        if (PSDateUtil.isSecondDateIsGreaterThanFirstDate((String)currentDate, (String)endDate)) {
            throw new BizBaseException(PSErrorMsg.PS080002.getErrCode(), PSErrorMsg.PS080002.getErrMsg(), new Object[0]);
        }
        if (PSDateUtil.isSecondDateIsGreaterThanFirstDate((String)endDate, (String)startDate)) {
            throw new BizBaseException(PSErrorMsg.PS080003.getErrCode(), PSErrorMsg.PS080003.getErrMsg(), new Object[0]);
        }
    }

    private YuinResultDto<Ps04001RspDto> handleException(String errCode, String errMsg) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        YuinResultHead head = new YuinResultHead();
        yuinResultDto.setHead(head);
        Ps04001RspDto rspDto = new Ps04001RspDto("0", errCode, errMsg);
        yuinResultDto.setBody((Object)rspDto);
        head.setResponseCode(rspDto.getErrcode());
        head.setResponseMsg(rspDto.getErrmsg());
        head.setStatus(rspDto.getStatus());
        return yuinResultDto;
    }
}

