/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.service;

import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.date.DateFormatEnum;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps08005.PS08005ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps08005.PS08005RspDtlDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps08005.PS08005RspDto;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDBranchadmRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsRBankPosDayBalRepo;
import cn.com.yusys.yusp.pay.position.domain.util.PSDateUtil;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDBranchadmVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsRBankPosDayBalQueryVo;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestHead;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PS08005Service {
    private static final Logger log = LoggerFactory.getLogger(PS08005Service.class);
    @Autowired
    private PsRBankPosDayBalRepo psRBankPosDayBalRepo;
    @Autowired
    private PsDBranchadmRepo psDBranchadmRepo;

    public YuinResultDto<PS08005RspDto> doQuery(YuinRequestDto<PS08005ReqDto> yuinRequestDto) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode("200");
        head.setResponseMsg("\u901a\u8baf\u6210\u529f");
        yuinResultDto.setHead(head);
        PS08005RspDto rspBodyDto = new PS08005RspDto();
        try {
            PS08005RspDto validateResult = this.validateRequestDto(yuinRequestDto);
            if (ObjectUtils.isNotEmpty((Object)validateResult.getErrcode())) {
                yuinResultDto.setBody((Object)validateResult);
                head.setResponseCode(validateResult.getErrcode());
                head.setResponseMsg(validateResult.getErrmsg());
                head.setStatus(validateResult.getStatus());
                return yuinResultDto;
            }
            YuinRequestHead header = yuinRequestDto.getSysHead();
            PS08005ReqDto psRBankPosDayBalReqDto = (PS08005ReqDto)yuinRequestDto.getBody();
            String startDate = psRBankPosDayBalReqDto.getStartDate();
            String stopDate = psRBankPosDayBalReqDto.getStopDate();
            List<String> orgTypeList = psRBankPosDayBalReqDto.getOrgTypeList();
            List<String> zoneList = psRBankPosDayBalReqDto.getZoneList();
            List<String> brnoList = psRBankPosDayBalReqDto.getBrnoList();
            List<Object> queryBrnoList = new ArrayList();
            if (ObjectUtils.isNotEmpty(brnoList) && brnoList.size() > 0) {
                queryBrnoList = brnoList;
            } else {
                List orgVoList = this.psDBranchadmRepo.getOrgInfoByOrgZoneBrno(orgTypeList, zoneList, null);
                for (PsDBranchadmVo vo2 : orgVoList) {
                    queryBrnoList.add(vo2.getBrno());
                }
            }
            PsRBankPosDayBalQueryVo queryVo = new PsRBankPosDayBalQueryVo();
            queryVo.setPage(Long.valueOf(Long.parseLong(String.valueOf(header.getPageNum()))));
            queryVo.setSize(Long.valueOf(Long.parseLong(String.valueOf(header.getPageSize()))));
            queryVo.setStartDate(startDate);
            queryVo.setStopDate(stopDate);
            queryVo.setBrnoList(queryBrnoList);
            IPage pageObj = this.psRBankPosDayBalRepo.queryPage(queryVo).convert(vo -> (PS08005RspDtlDto)BeanUtils.beanCopy((Object)vo, PS08005RspDtlDto.class));
            head.setTotalSize(pageObj.getTotal());
            rspBodyDto.setList(pageObj.getRecords());
            rspBodyDto.setStatus("1");
            yuinResultDto.setBody((Object)rspBodyDto);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.info(ex.toString());
            rspBodyDto.setStatus("0");
            rspBodyDto.setErrcode(PSErrorMsg.PS000001.getErrCode());
            rspBodyDto.setErrmsg(PSErrorMsg.PS000001.getErrMsg());
            yuinResultDto.setBody((Object)rspBodyDto);
        }
        return yuinResultDto;
    }

    private PS08005RspDto validateRequestDto(YuinRequestDto<PS08005ReqDto> yuinRequestDto) {
        PS08005RspDto rspDto = new PS08005RspDto();
        YuinRequestHead header = yuinRequestDto.getSysHead();
        PS08005ReqDto psRBankPosDayBalReqDto = (PS08005ReqDto)yuinRequestDto.getBody();
        String startDate = psRBankPosDayBalReqDto.getStartDate();
        String stopDate = psRBankPosDayBalReqDto.getStopDate();
        List<String> orgTypeList = psRBankPosDayBalReqDto.getOrgTypeList();
        List<String> zoneList = psRBankPosDayBalReqDto.getZoneList();
        List<String> brnoList = psRBankPosDayBalReqDto.getBrnoList();
        if (ObjectUtils.isEmpty((Object)startDate)) {
            rspDto.setStatus("0");
            rspDto.setErrcode(PSErrorMsg.PS080004.getErrCode());
            rspDto.setErrmsg(PSErrorMsg.PS080004.getErrMsg());
            return rspDto;
        }
        if (ObjectUtils.isEmpty((Object)stopDate)) {
            rspDto.setStatus("0");
            rspDto.setErrcode(PSErrorMsg.PS080005.getErrCode());
            rspDto.setErrmsg(PSErrorMsg.PS080005.getErrMsg());
            return rspDto;
        }
        String currentDate = DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT);
        if (PSDateUtil.isSecondDateIsGreaterThanFirstDate((String)currentDate, (String)startDate)) {
            rspDto.setStatus("0");
            rspDto.setErrcode(PSErrorMsg.PS080001.getErrCode());
            rspDto.setErrmsg(PSErrorMsg.PS080001.getErrMsg());
            return rspDto;
        }
        if (PSDateUtil.isSecondDateIsGreaterThanFirstDate((String)currentDate, (String)stopDate)) {
            rspDto.setStatus("0");
            rspDto.setErrcode(PSErrorMsg.PS080002.getErrCode());
            rspDto.setErrmsg(PSErrorMsg.PS080002.getErrMsg());
            return rspDto;
        }
        if (PSDateUtil.isSecondDateIsGreaterThanFirstDate((String)stopDate, (String)startDate)) {
            rspDto.setStatus("0");
            rspDto.setErrcode(PSErrorMsg.PS080003.getErrCode());
            rspDto.setErrmsg(PSErrorMsg.PS080003.getErrMsg());
            return rspDto;
        }
        return rspDto;
    }
}

