/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.resource;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.util.date.DateFormatEnum;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.commons.validation.util.ValidatorUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps05001.Ps05001ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps05001.Ps05001RspDto;
import cn.com.yusys.yusp.pay.position.application.service.PS05001Service;
import cn.com.yusys.yusp.pay.position.domain.util.PSDateUtil;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"PS05001"})
@RestController
public class PS05001Resource {
    @Autowired
    private PS05001Service pS05001Service;

    @ApiOperation(value="\u65e5\u95f4\u6d41\u52a8\u6027\u9884\u6d4b")
    @PostMapping(value={"/api/payment/ps/ps05001"})
    public YuinResultDto<Ps05001RspDto> ps05001(@RequestBody YuinRequestDto<Ps05001ReqDto> yuinRequestDto) {
        try {
            this.validateRequestDto(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        try {
            return this.pS05001Service.ps05001(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.handleException(PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg());
        }
    }

    private void validateRequestDto(YuinRequestDto<Ps05001ReqDto> requestDto) {
        try {
            ValidatorUtils.validate((Object)requestDto.getBody(), (Class[])new Class[0]);
        }
        catch (BizBaseException bizBaseException) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), bizBaseException.getCode(), new Object[0]);
        }
        String predDate = ((Ps05001ReqDto)requestDto.getBody()).getPredDate();
        String currentDate = DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT);
        if (PSDateUtil.isSecondDateIsGreaterThanFirstDate((String)predDate, (String)currentDate)) {
            throw new BizBaseException(PSErrorMsg.PS000009.getErrCode(), PSErrorMsg.PS000009.getErrMsg(), new Object[0]);
        }
    }

    private YuinResultDto<Ps05001RspDto> handleException(String errCode, String errMsg) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        YuinResultHead head = new YuinResultHead();
        yuinResultDto.setHead(head);
        Ps05001RspDto rspDto = new Ps05001RspDto("0", errCode, errMsg);
        yuinResultDto.setBody((Object)rspDto);
        head.setResponseCode(rspDto.getErrcode());
        head.setResponseMsg(rspDto.getErrmsg());
        head.setStatus(rspDto.getStatus());
        return yuinResultDto;
    }
}

