/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.resource;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.util.date.DateFormatEnum;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.commons.validation.util.ValidatorUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps04004.Ps04004ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps04004.Ps04004RspDto;
import cn.com.yusys.yusp.pay.position.application.service.PS04004Service;
import cn.com.yusys.yusp.pay.position.domain.util.PSDateUtil;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"PS04004"})
@RestController
@RequestMapping(value={"/api/payment/ps"})
public class PS04004Resource {
    @Autowired
    private PS04004Service pS04004Service;

    @ApiOperation(value="\u6700\u65b0\u5927\u989d\u4ea4\u6613")
    @PostMapping(value={"/ps04004"})
    public YuinResultDto<Ps04004RspDto> ps04004(@RequestBody YuinRequestDto<Ps04004ReqDto> yuinRequestDto) {
        try {
            this.validateRequestDto(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        try {
            return this.pS04004Service.ps04004(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.handleException(PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg());
        }
    }

    private void validateRequestDto(YuinRequestDto<Ps04004ReqDto> requestDto) {
        try {
            ValidatorUtils.validate((Object)requestDto.getBody(), (Class[])new Class[0]);
        }
        catch (BizBaseException bizBaseException) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), bizBaseException.getCode(), new Object[0]);
        }
        String brType = ((Ps04004ReqDto)requestDto.getBody()).getBrType();
        String brNo = ((Ps04004ReqDto)requestDto.getBody()).getBrNo();
        if ("03".equals(brType) && StringUtils.isBlank((String)brNo)) {
            throw new BizBaseException(PSErrorMsg.PS000008.getErrCode(), "\u673a\u6784\u53f7" + PSErrorMsg.PS000008.getErrMsg(), new Object[0]);
        }
        String startDate = ((Ps04004ReqDto)requestDto.getBody()).getStartDate();
        String endDate = ((Ps04004ReqDto)requestDto.getBody()).getEndDate();
        String currentDate = DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT);
        if (PSDateUtil.isSecondDateIsGreaterThanFirstDate((String)currentDate, (String)startDate)) {
            throw new BizBaseException(PSErrorMsg.PS080001.getErrCode(), PSErrorMsg.PS080001.getErrMsg(), new Object[0]);
        }
        if (PSDateUtil.isSecondDateIsGreaterThanFirstDate((String)currentDate, (String)endDate)) {
            throw new BizBaseException(PSErrorMsg.PS080002.getErrCode(), PSErrorMsg.PS080002.getErrMsg(), new Object[0]);
        }
        if (PSDateUtil.isSecondDateIsGreaterThanFirstDate((String)endDate, (String)startDate)) {
            throw new BizBaseException(PSErrorMsg.PS080003.getErrCode(), PSErrorMsg.PS080003.getErrMsg(), new Object[0]);
        }
    }

    private YuinResultDto<Ps04004RspDto> handleException(String errCode, String errMsg) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        YuinResultHead head = new YuinResultHead();
        yuinResultDto.setHead(head);
        Ps04004RspDto rspDto = new Ps04004RspDto("0", errCode, errMsg);
        yuinResultDto.setBody((Object)rspDto);
        head.setResponseCode(rspDto.getErrcode());
        head.setResponseMsg(rspDto.getErrmsg());
        head.setStatus(rspDto.getStatus());
        return yuinResultDto;
    }
}

