/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.resource;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.util.date.DateFormatEnum;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.commons.validation.util.ValidatorUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps04003.Ps04003ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps04003.Ps04003RspDto;
import cn.com.yusys.yusp.pay.position.application.service.PS04003Service;
import cn.com.yusys.yusp.pay.position.domain.util.PSDateUtil;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"PS04003"})
@RestController
@RequestMapping(value={"/api/payment/ps"})
public class PS04003Resource {
    @Autowired
    private PS04003Service pS04003Service;

    @ApiOperation(value="\u7b2c\u4e09\u65b9\u5b9e\u65f6\u4ea4\u6613\u91cf\u76d1\u6d4b")
    @PostMapping(value={"/ps04003"})
    public YuinResultDto<Ps04003RspDto> ps04003(@RequestBody YuinRequestDto<Ps04003ReqDto> yuinRequestDto) {
        try {
            this.validateRequestDto(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        try {
            return this.pS04003Service.ps04003(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.handleException(PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg());
        }
    }

    private void validateRequestDto(YuinRequestDto<Ps04003ReqDto> requestDto) {
        try {
            ValidatorUtils.validate((Object)requestDto.getBody(), (Class[])new Class[0]);
        }
        catch (BizBaseException bizBaseException) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), bizBaseException.getCode(), new Object[0]);
        }
        String workDate = ((Ps04003ReqDto)requestDto.getBody()).getWorkDate();
        String currentDate = DateUtils.getCurrentDate((DateFormatEnum)DateFormatEnum.DATE_COMPACT);
        if (PSDateUtil.isSecondDateIsGreaterThanFirstDate((String)currentDate, (String)workDate)) {
            throw new BizBaseException(PSErrorMsg.PS080006.getErrCode(), PSErrorMsg.PS080006.getErrMsg(), new Object[0]);
        }
    }

    private YuinResultDto<Ps04003RspDto> handleException(String errCode, String errMsg) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        YuinResultHead head = new YuinResultHead();
        yuinResultDto.setHead(head);
        Ps04003RspDto rspDto = new Ps04003RspDto("0", errCode, errMsg);
        yuinResultDto.setBody((Object)rspDto);
        head.setResponseCode(rspDto.getErrcode());
        head.setResponseMsg(rspDto.getErrmsg());
        head.setStatus(rspDto.getStatus());
        return yuinResultDto;
    }
}

