/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.resource;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.validation.util.ValidatorUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps04001.Ps04001ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps04001.Ps04001RspDto;
import cn.com.yusys.yusp.pay.position.application.service.PS04001Service;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"PS04001"})
@RestController
@RequestMapping(value={"/api/payment/ps"})
public class PS04001Resource {
    private static final Logger log = LoggerFactory.getLogger(PS04001Resource.class);
    @Autowired
    private PS04001Service pS04001Service;

    @ApiOperation(value="\u5934\u5bf8\u76d1\u6d4b\u6a21\u5757\u5404\u529f\u80fd\u7edf\u4e00\u63a5\u53e3")
    @PostMapping(value={"/ps04001"})
    public YuinResultDto<Ps04001RspDto> ps04001(@RequestBody YuinRequestDto<Ps04001ReqDto> yuinRequestDto) {
        try {
            log.info("\u6536\u5230\u8bf7\u6c42\u7684\u4ea4\u6613:ps04001");
            String reqJsonStr = JSON.toJSONString(yuinRequestDto);
            log.info("\u6536\u5230\u8bf7\u6c42\u6570\u636e:" + reqJsonStr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            this.validateRequestDto(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        try {
            YuinResultDto<Ps04001RspDto> yuinResultDto = this.pS04001Service.ps04001(yuinRequestDto);
            String respJsonStr = JSON.toJSONString(yuinResultDto);
            log.info("\u5e94\u7b54\u6570\u636e:" + respJsonStr);
            return yuinResultDto;
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.handleException(PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg());
        }
    }

    private void validateRequestDto(YuinRequestDto<Ps04001ReqDto> requestDto) {
        try {
            ValidatorUtils.validate((Object)requestDto.getBody(), (Class[])new Class[0]);
        }
        catch (BizBaseException bizBaseException) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), bizBaseException.getCode(), new Object[0]);
        }
        String brType = ((Ps04001ReqDto)requestDto.getBody()).getBrType();
        String brNo = ((Ps04001ReqDto)requestDto.getBody()).getBrNo();
        if ("03".equals(brType) && StringUtils.isBlank((String)brNo)) {
            throw new BizBaseException(PSErrorMsg.PS000008.getErrCode(), "\u673a\u6784\u53f7" + PSErrorMsg.PS000008.getErrMsg(), new Object[0]);
        }
    }

    private YuinResultDto<Ps04001RspDto> handleException(String errCode, String errMsg) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        YuinResultHead head = new YuinResultHead();
        yuinResultDto.setHead(head);
        Ps04001RspDto rspDto = new Ps04001RspDto("0", errCode, errMsg);
        yuinResultDto.setBody((Object)rspDto);
        head.setResponseCode(rspDto.getErrcode());
        head.setResponseMsg(rspDto.getErrmsg());
        head.setStatus(rspDto.getStatus());
        return yuinResultDto;
    }
}

