/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.resource;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.validation.util.ValidatorUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps02001.Ps02001RspDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps03008.Ps03008DtelRspDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps03008.Ps03008ReqDto;
import cn.com.yusys.yusp.pay.position.application.service.PS03008Service;
import cn.com.yusys.yusp.pay.position.domain.util.PSDateUtil;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"PS03008"})
@RestController
public class PS03008Resource {
    @Autowired
    private PS03008Service pS03008Service;

    @ApiOperation(value="\u5934\u5bf8\u9884\u62a5\u624b\u5de5\u6838\u9500")
    @PostMapping(value={"/api/payment/ps/ps03008"})
    public YuinResultDto<Ps03008DtelRspDto> ps03008(@RequestBody @Validated YuinRequestDto<Ps03008ReqDto> yuinRequestDto) {
        try {
            this.validateRequestDto(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        try {
            return this.pS03008Service.ps03008(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.handleException(PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg());
        }
    }

    private void validateRequestDto(YuinRequestDto<Ps03008ReqDto> yuinRequestDto) {
        Ps03008ReqDto ps03008ReqDto = (Ps03008ReqDto)yuinRequestDto.getBody();
        try {
            ValidatorUtils.validate((Object)ps03008ReqDto, (Class[])new Class[0]);
        }
        catch (BizBaseException bizBaseException) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), bizBaseException.getCode(), new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)((Ps03008ReqDto)yuinRequestDto.getBody()).getFunctype())) {
            throw new BizBaseException(PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000002.getErrMsg(), new Object[0]);
        }
        if ("1".equals(((Ps03008ReqDto)yuinRequestDto.getBody()).getFunctype())) {
            if (StringUtils.isBlank((CharSequence)((Ps03008ReqDto)yuinRequestDto.getBody()).getStartdate())) {
                throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
            }
            if (StringUtils.isBlank((CharSequence)((Ps03008ReqDto)yuinRequestDto.getBody()).getEnddate())) {
                throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
            }
            if (PSDateUtil.isSecondDateIsGreaterThanFirstDate((String)((Ps03008ReqDto)yuinRequestDto.getBody()).getEnddate(), (String)((Ps03008ReqDto)yuinRequestDto.getBody()).getStartdate())) {
                throw new BizBaseException(PSErrorMsg.PS080003.getErrCode(), PSErrorMsg.PS080003.getErrMsg(), new Object[0]);
            }
            if (StringUtils.isBlank((CharSequence)((Ps03008ReqDto)yuinRequestDto.getBody()).getBrnotype())) {
                throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
            }
            if ("03".equals(((Ps03008ReqDto)yuinRequestDto.getBody()).getBrnotype()) && StringUtils.isBlank((CharSequence)((Ps03008ReqDto)yuinRequestDto.getBody()).getBrno())) {
                throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
            }
        } else {
            if ("2".equals(((Ps03008ReqDto)yuinRequestDto.getBody()).getFunctype()) && ((Ps03008ReqDto)yuinRequestDto.getBody()).getWrtoffamt().compareTo(BigDecimal.ZERO) == 0) {
                throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
            }
            if (StringUtils.isBlank((CharSequence)((Ps03008ReqDto)yuinRequestDto.getBody()).getWorkdate())) {
                throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
            }
            if (StringUtils.isBlank((CharSequence)((Ps03008ReqDto)yuinRequestDto.getBody()).getPredno())) {
                throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
            }
        }
    }

    private YuinResultDto handleException(String errCode, String errMsg) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        Ps02001RspDto rspDto = new Ps02001RspDto("0", errCode, errMsg);
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode(rspDto.getErrcode());
        head.setResponseMsg(rspDto.getErrmsg());
        head.setStatus(rspDto.getStatus());
        yuinResultDto.setHead(head);
        yuinResultDto.setBody((Object)rspDto);
        return yuinResultDto;
    }
}

