/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.resource;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.validation.util.ValidatorUtils;
import cn.com.yusys.yusp.pay.position.application.dto.ps02001.Ps02001RspDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps03006.Ps03006DtelRspDto;
import cn.com.yusys.yusp.pay.position.application.dto.ps03006.Ps03006ReqDto;
import cn.com.yusys.yusp.pay.position.application.service.PS03006Service;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"PS03006"})
@RestController
public class PS03006Resource {
    @Autowired
    private PS03006Service pS03006Service;

    @ApiOperation(value="\u65d7\u53bf\u8054\u793e\u5321\u7b97\u7ed3\u679c\u67e5\u8be2")
    @PostMapping(value={"/api/payment/ps/ps03006"})
    public YuinResultDto<Ps03006DtelRspDto> ps03006(@RequestBody @Validated YuinRequestDto<Ps03006ReqDto> yuinRequestDto) {
        try {
            this.validateRequestDto(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        try {
            return this.pS03006Service.ps03006(yuinRequestDto);
        }
        catch (BizBaseException bizBaseException) {
            bizBaseException.printStackTrace();
            return this.handleException(bizBaseException.getCode(), bizBaseException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.handleException(PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg());
        }
    }

    private void validateRequestDto(YuinRequestDto<Ps03006ReqDto> yuinRequestDto) {
        Ps03006ReqDto ps03006ReqDto = (Ps03006ReqDto)yuinRequestDto.getBody();
        try {
            ValidatorUtils.validate((Object)ps03006ReqDto, (Class[])new Class[0]);
        }
        catch (BizBaseException bizBaseException) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), bizBaseException.getCode(), new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)ps03006ReqDto.getBrno())) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)ps03006ReqDto.getWorkdate())) {
            throw new BizBaseException(PSErrorMsg.PS000004.getErrCode(), PSErrorMsg.PS000004.getErrMsg(), new Object[0]);
        }
    }

    private YuinResultDto handleException(String errCode, String errMsg) {
        YuinResultDto yuinResultDto = new YuinResultDto();
        Ps02001RspDto rspDto = new Ps02001RspDto("0", errCode, errMsg);
        YuinResultHead head = new YuinResultHead();
        head.setResponseCode(rspDto.getErrcode());
        head.setResponseMsg(rspDto.getErrmsg());
        head.setStatus(rspDto.getStatus());
        yuinResultDto.setHead(head);
        yuinResultDto.setBody((Object)rspDto);
        return yuinResultDto;
    }
}

