/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.service;

import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.pay.position.application.dto.Ps06002.Ps06002ReqDto;
import cn.com.yusys.yusp.pay.position.application.dto.Ps06002.Ps06002RspDto;
import cn.com.yusys.yusp.pay.position.application.dto.Ps06002.Ps06002RspDtoTemp;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDMessagetemplateRepo;
import cn.com.yusys.yusp.pay.position.domain.util.PSErrorMsg;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDMessagetemplateVo;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinRequestHead;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultDto;
import cn.com.yusys.yusp.payment.common.base.dto.YuinResultHead;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PS06002Service {
    private static final Logger log = LoggerFactory.getLogger(PS06002Service.class);
    @Autowired
    private PsDMessagetemplateRepo psDMessagetemplateRepo;

    private Ps06002RspDto getMsgCode(String pre) {
        String msgCode = "";
        PsDMessagetemplateVo psDMessagetemplateVo = new PsDMessagetemplateVo();
        psDMessagetemplateVo.setSize(Long.valueOf(1L));
        psDMessagetemplateVo.setPage(Long.valueOf(1L));
        IPage rspDtoIPage = this.psDMessagetemplateRepo.doQuery(psDMessagetemplateVo);
        List listVo = rspDtoIPage.getRecords();
        if (CollectionUtils.isEmpty((Collection)listVo)) {
            msgCode = pre + "000001";
        } else {
            String srcMsgcode = ((PsDMessagetemplateVo)listVo.get(0)).getMsgcode();
            String temp = srcMsgcode.substring(pre.length());
            int i = Integer.parseInt(temp) + 1;
            msgCode = pre + String.format("%06d", i);
        }
        Ps06002RspDto ps06002RspDto = new Ps06002RspDto("1", "", "");
        ps06002RspDto.setMsgcode(msgCode);
        return ps06002RspDto;
    }

    public YuinResultDto<Ps06002RspDto> messageTmplateHandle(YuinRequestDto<Ps06002ReqDto> yuinRequestDto) {
        YuinRequestDto request = new YuinRequestDto();
        request.setSysHead(yuinRequestDto.getSysHead());
        request.setBody(BeanUtils.beanCopy((Object)yuinRequestDto.getBody(), PsDMessagetemplateVo.class));
        YuinResultDto yuinResultDto = new YuinResultDto();
        YuinResultHead resultHead = new YuinResultHead();
        resultHead.setResponseCode("200");
        resultHead.setResponseMsg("\u901a\u8baf\u6210\u529f");
        yuinResultDto.setHead(resultHead);
        PsDMessagetemplateVo psDMessagetemplateVo = (PsDMessagetemplateVo)Optional.ofNullable(request.getBody()).orElse(new PsDMessagetemplateVo());
        psDMessagetemplateVo.setPage(Long.valueOf(request.getSysHead().getPageNum().intValue()));
        psDMessagetemplateVo.setSize(Long.valueOf(request.getSysHead().getPageSize().intValue()));
        psDMessagetemplateVo.setAppid(request.getSysHead().getAppid());
        psDMessagetemplateVo.setSysid(request.getSysHead().getSysid());
        try {
            switch (StringUtils.isBlank((CharSequence)psDMessagetemplateVo.getFuncType()) ? "9999" : psDMessagetemplateVo.getFuncType()) {
                case "1": {
                    yuinResultDto.setBody((Object)this.doInsert(psDMessagetemplateVo, request.getSysHead()));
                    break;
                }
                case "2": {
                    yuinResultDto.setBody((Object)this.doUpdate(psDMessagetemplateVo, request.getSysHead()));
                    break;
                }
                case "3": {
                    yuinResultDto.setBody((Object)this.doDelete(psDMessagetemplateVo));
                    break;
                }
                case "4": {
                    yuinResultDto.setBody((Object)this.doQuery(psDMessagetemplateVo, resultHead));
                    break;
                }
                case "5": {
                    yuinResultDto.setBody((Object)this.getMsgCode("MSG"));
                    break;
                }
                default: {
                    yuinResultDto.setBody((Object)new Ps06002RspDto("0", PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000002.getErrMsg()));
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info(e.toString());
            yuinResultDto.setBody((Object)new Ps06002RspDto("0", PSErrorMsg.PS000001.getErrCode(), PSErrorMsg.PS000001.getErrMsg()));
        }
        return yuinResultDto;
    }

    private Ps06002RspDto doQuery(PsDMessagetemplateVo psDMessagetemplateVo, YuinResultHead resultHead) {
        IPage rspDtoIPage = this.psDMessagetemplateRepo.doQuery(psDMessagetemplateVo).convert(vo -> (Ps06002RspDtoTemp)BeanUtils.beanCopy((Object)vo, Ps06002RspDtoTemp.class));
        resultHead.setTotalSize(rspDtoIPage.getTotal());
        Ps06002RspDto ps06002RspDto = new Ps06002RspDto("1", "", "");
        ps06002RspDto.setList(rspDtoIPage.getRecords());
        return ps06002RspDto;
    }

    private Ps06002RspDto doDelete(PsDMessagetemplateVo psDMessagetemplateVo) {
        if (StringUtils.isBlank((CharSequence)psDMessagetemplateVo.getMsgcode())) {
            return new Ps06002RspDto("0", PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000004.getErrMsg() + "\u8bf7\u68c0\u67e5\u53c2\u6570\u4e0d\u53ef\u7f3a\u5c11\u5220\u9664\u4e3b\u952e:msgcode-\u6a21\u677f\u7f16\u53f7");
        }
        this.psDMessagetemplateRepo.doDelete(psDMessagetemplateVo);
        return new Ps06002RspDto("1", "", "");
    }

    private Ps06002RspDto doUpdate(PsDMessagetemplateVo psDMessagetemplateVo, YuinRequestHead requestHead) {
        if (StringUtils.isBlank((CharSequence)psDMessagetemplateVo.getMsgcode())) {
            return new Ps06002RspDto("0", PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000004.getErrMsg() + "\u8bf7\u68c0\u67e5\u53c2\u6570\u4e0d\u53ef\u7f3a\u5c11\u5220\u9664\u4e3b\u952e:msgcode-\u6a21\u677f\u7f16\u53f7");
        }
        psDMessagetemplateVo.setModifytime(DateUtils.getCurrDateTimeStr());
        psDMessagetemplateVo.setModifier(requestHead.getTellerno());
        this.psDMessagetemplateRepo.doUpdate(psDMessagetemplateVo);
        return new Ps06002RspDto("1", "", "");
    }

    private Ps06002RspDto doInsert(PsDMessagetemplateVo psDMessagetemplateVo, YuinRequestHead requestHead) {
        if (StringUtils.isBlank((CharSequence)psDMessagetemplateVo.getMsgcode())) {
            return new Ps06002RspDto("0", PSErrorMsg.PS000002.getErrCode(), PSErrorMsg.PS000004.getErrMsg() + "\u8bf7\u68c0\u67e5\u53c2\u6570\u4e0d\u53ef\u7f3a\u5c11\u5220\u9664\u4e3b\u952e:msgcode-\u6a21\u677f\u7f16\u53f7");
        }
        psDMessagetemplateVo.setCreatetime(DateUtils.getCurrDateTimeStr());
        psDMessagetemplateVo.setCreator(requestHead.getTellerno());
        this.psDMessagetemplateRepo.doInsert(psDMessagetemplateVo);
        return new Ps06002RspDto("1", "", "");
    }
}

