/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.pay.position.application.service;

import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDBankaccbookRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsDCorpaccbookRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsRBankPosDayBalRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsRCorpaccdaybalRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsTBankbaljnlRepo;
import cn.com.yusys.yusp.pay.position.domain.repo.PsTCorpbaljnlRepo;
import cn.com.yusys.yusp.pay.position.domain.util.PSDateUtil;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDBankaccbookVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsDCorpaccbookVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsRBankPosDayBalVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsRCorpaccdaybalVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsTBankbaljnlVo;
import cn.com.yusys.yusp.pay.position.domain.vo.PsTCorpbaljnlVo;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PS04007Service {
    private static final Logger log = LoggerFactory.getLogger(PS04007Service.class);
    @Autowired
    private PsDCorpaccbookRepo psDCorpaccbookRepo;
    @Autowired
    private PsDBankaccbookRepo psDBankaccbookRepo;
    @Autowired
    private PsTBankbaljnlRepo psTBankbaljnlRepo;
    @Autowired
    private PsTCorpbaljnlRepo psTCorpbaljnlRepo;
    @Autowired
    private PsRCorpaccdaybalRepo psRCorpaccdaybalRepo;
    @Autowired
    private PsRBankPosDayBalRepo psRBankPosDayBalRepo;

    public void taskExecution() {
        String yesterday = PSDateUtil.getYesterdayDate();
        this.taskExecutionForBankAcc(yesterday);
        this.taskExecutionForCorpAcc(yesterday);
    }

    private void taskExecutionForBankAcc(String workDate) {
        try {
            List list = this.psDBankaccbookRepo.getAllAccBookList();
            for (PsDBankaccbookVo bankaccbookVo : list) {
                PsRBankPosDayBalVo dbVo;
                PsTBankbaljnlVo bankbaljnlVo = this.psTBankbaljnlRepo.getLatestInfo(bankaccbookVo.getPostaccno(), workDate);
                if (ObjectUtils.isEmpty((Object)bankbaljnlVo) || CollectionUtils.nonNull((Object)(dbVo = this.psRBankPosDayBalRepo.getRBankPosDayBalInfo(bankaccbookVo.getClearbrno(), bankaccbookVo.getPostaccno(), workDate)))) continue;
                PsRBankPosDayBalVo bankPosDayBalVo = new PsRBankPosDayBalVo();
                bankPosDayBalVo.setAcctype(bankaccbookVo.getAcctype());
                bankPosDayBalVo.setAppid(bankaccbookVo.getAppid());
                bankPosDayBalVo.setBal(bankbaljnlVo.getTodaybal());
                bankPosDayBalVo.setClearbrno(bankaccbookVo.getClearbrno());
                bankPosDayBalVo.setPosorgtype(bankaccbookVo.getPosorgtype());
                bankPosDayBalVo.setPostaccno(bankaccbookVo.getPostaccno());
                bankPosDayBalVo.setSysid(bankaccbookVo.getSysid());
                bankPosDayBalVo.setWorkdate(workDate);
                this.psRBankPosDayBalRepo.save(bankPosDayBalVo);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void taskExecutionForCorpAcc(String workDate) {
        try {
            List list = this.psDCorpaccbookRepo.getAllCorpAccBookList();
            for (PsDCorpaccbookVo corpaccbookVo : list) {
                PsRCorpaccdaybalVo dbVo;
                PsTCorpbaljnlVo corpbaljnlVo = this.psTCorpbaljnlRepo.getLatestInfo(corpaccbookVo.getPostype(), corpaccbookVo.getPostaccno(), workDate);
                if (ObjectUtils.isEmpty((Object)corpbaljnlVo) || CollectionUtils.nonNull((Object)(dbVo = this.psRCorpaccdaybalRepo.getRCorpaccdaybalInfo(corpaccbookVo.getPostype(), corpaccbookVo.getPostaccno(), workDate)))) continue;
                PsRCorpaccdaybalVo corpaccdaybalVo = new PsRCorpaccdaybalVo();
                corpaccdaybalVo.setAppid(corpaccbookVo.getAppid());
                corpaccdaybalVo.setBal(corpbaljnlVo.getTodaybal());
                corpaccdaybalVo.setPostaccno(corpaccbookVo.getPostaccno());
                corpaccdaybalVo.setPostname(corpaccbookVo.getPosname());
                corpaccdaybalVo.setPosttype(corpaccbookVo.getPostype());
                corpaccdaybalVo.setSysid(corpaccbookVo.getSysid());
                corpaccdaybalVo.setWorkdate(workDate);
                this.psRCorpaccdaybalRepo.save(corpaccdaybalVo);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

